# (c) Copyright 2010, Николай Слободской (Nick Slobodsky)
# This file is part of PlansPlant.
#
# PlansPlant is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
#
# PlansPlant is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with PlansPlant.  If not, see <http://www.gnu.org/licenses/>.
#
TEMPLATE = lib
VERSION = 0.1.1

TARGET = plansplant

#! \todo Consider move headers to the same dir as the source.
HEADERS = plansplant/tasks.hpp plansplant/widgets.hpp plansplant/export.hpp
SOURCES = tasks.cpp widgets.cpp export.cpp
FORMS = forms/task.ui forms/blockers_editor.ui
RESOURCES = plansplant.qrc

# INCLUDEPATH += ../../timeshop/lib

DEFINES += PLANSPLANT_LIB_SHARED
LIBS += -ltimeshop

#! \todo Move translation to separate langpack.
trans.target = lang/libplansplant-ru.qm
trans.depends = lang/libplansplant-ru.ts
trans.commands = $${QT_BIN_DIR}lrelease lib.pro
QMAKE_EXTRA_TARGETS += trans
QMAKE_CLEAN += $${trans.target}
PRE_TARGETDEPS += $${trans.target}
TRANSLATIONS = $${trans.depends}

unix {
isEmpty( PREFIX ) {
  PREFIX = /usr/local
}
DEFINES += PLANSPLANT_DATADIR=\'\"$${PREFIX}/share/plansplant\"\'

LIBDIR = $${PREFIX}/lib
INCDIR = $${PREFIX}/include/plansplant
DATADIR = $${PREFIX}/share

target.path += $${LIBDIR}
INSTALLS += target

headers.path = $${INCDIR}
headers.files = $${HEADERS}
INSTALLS += headers

maemo5 {
ICONSUBDIR=hildon
}
else {
ICONSUBDIR=apps
}
# Icons install
ICONDIRPREFIX=$${DATADIR}/icons/hicolor

icon.files = images/plansplant.png
icon.path = $${ICONDIRPREFIX}/48x48/$${ICONSUBDIR}
INSTALLS += icon
}
