#include "pggui.h"

#include<QTextCodec>
pggui::pggui(QWidget *parent)
    : QWidget(parent)
{
    gpgText = new QTextEdit;
    pgguiAboutButton = new QPushButton(tr("About"));
    gpgEncryptButton = new QPushButton(tr("Encryption"));
    gpgDecryptButton = new QPushButton(tr("Decryption"));
    gpgKeyManagmentButton = new QPushButton(tr("Key Managemnt"));
    strLine = new QString;


    QHBoxLayout *ButtonLayout1 = new QHBoxLayout;
    ButtonLayout1->addWidget(gpgEncryptButton);
    ButtonLayout1->addWidget(gpgDecryptButton);
    ButtonLayout1->addWidget(gpgKeyManagmentButton);
    ButtonLayout1->addWidget(pgguiAboutButton);

    QVBoxLayout *mainLayout = new QVBoxLayout;
    mainLayout->addWidget(gpgText);
    mainLayout->addLayout(ButtonLayout1);

    this->setLayout(mainLayout);
    setWindowTitle("Gnu PG GUI");

    gpgEncryptButton->setEnabled(0);
    gpgText->setReadOnly(1);

#ifdef Q_WS_MAEMO_5

    // enable the kinetic scroller on scrollArea
     QAbstractKineticScroller *scroller = gpgText->property("kineticScroller")
                                              .value<QAbstractKineticScroller *>();
     scroller->setEnabled(1);
     this->setAttribute(Qt::WA_Maemo5StackedWindow);
#endif

     //Key Management Window start

     gpgCreateKeysButton = new QPushButton(tr("Create Keys"));
     gpgImportKeysButton = new QPushButton(tr("Import Keys"));



     KeyManagmentWindow = new QMainWindow(this);

 #ifdef Q_WS_MAEMO_5
     KeyManagmentWindow->setAttribute(Qt::WA_Maemo5StackedWindow);
 #endif

     QVBoxLayout *KeyManagmentWindowLayout = new QVBoxLayout;
     KeyManagmentWindowLayout->addWidget(gpgCreateKeysButton);
     KeyManagmentWindowLayout->addWidget(gpgImportKeysButton);



     QWidget *KeyManagemntLayout = new QWidget;
     KeyManagemntLayout->setLayout(KeyManagmentWindowLayout);
     KeyManagmentWindow->setCentralWidget(KeyManagemntLayout);

     gpgCreateKeysButton->setEnabled(0);


     //Key Management Window end


     //Password Enter Window start

//     passwordLine = new QLineEdit;
//     QPushButton *passwordOk = new QPushButton(tr("OK"));
//     passwordLine->setEchoMode(QLineEdit::Password);

//     gpgEnterKeyWindow = new QMainWindow(KeyManagmentWindow);

//#ifdef Q_WS_MAEMO_5
//    gpgEnterKeyWindow->setAttribute(Qt::WA_Maemo5StackedWindow);
//#endif

//     QHBoxLayout *gpgEnterKeyWindowLayout = new QHBoxLayout;
//     gpgEnterKeyWindowLayout->addWidget(passwordLine);
//     gpgEnterKeyWindowLayout->addWidget(passwordOk);


//     QWidget *gpgEnterKeyWindowLayoutWidget = new QWidget;
//     gpgEnterKeyWindowLayoutWidget->setLayout(gpgEnterKeyWindowLayout);
//     gpgEnterKeyWindow->setCentralWidget(gpgEnterKeyWindowLayoutWidget);

     //Password Enter Window end

   dialog = new passwordDialog;

   gpg = new QProcess;

   connect(pgguiAboutButton,SIGNAL(clicked()),this,SLOT(pgguiAbout()));
   connect(gpg,SIGNAL(readyReadStandardOutput()),this,SLOT(slotStringReceived())); //Receive output
   connect(gpg,SIGNAL(readyReadStandardError()),this,SLOT(slotErrorStringReceived())); //Receive Errors
   connect(gpgEncryptButton,SIGNAL(clicked()),this,SLOT(gpgEncryption()));
   connect(gpgDecryptButton,SIGNAL(clicked()),this,SLOT(gpgDecryption()));
   connect(gpgKeyManagmentButton,SIGNAL(clicked()),KeyManagmentWindow,SLOT(show()));
   connect(gpgImportKeysButton,SIGNAL(clicked()),this,SLOT(gpgImportKey()));



   QTextCodec::setCodecForCStrings( QTextCodec::codecForName( "UTF-8" ) ); //general Text-Coding, needed for "Umlaute"
   QTextCodec::setCodecForLocale( QTextCodec::codecForName("UTF-8") );
   QTextCodec::setCodecForTr( QTextCodec::codecForName("UTF-8") );

   //check,wether pggui has been set up
   #ifdef Q_WS_MAEMO_5
       QFile conf("/home/user/.gnupg-pggui/conf.txt");

       if (!conf.exists()) {
       system("mkdir /home/user/.gnupg-pggui");
       system("touch /home/user/.gnupg-pggui/conf.txt");
       system("chmod 0700 /home/user/.gnupg-pggui");
       system("chmod 0644 /home/user/.gnupg-pggui/conf.txt");


       qDebug() <<"Config-Directory created and conf file touched" ;

        QMaemo5InformationBox::information(this, "<b>First start<b> \n Pggui directory created",
                                           QMaemo5InformationBox::DefaultTimeout);


   }

   #endif


}

void pggui::pgguiAbout()
{
    QDialog *about = new QDialog(this);

    QLabel *aboutText = new QLabel(tr(" Private Guard Graphical User Interface \n created by Florian Brandes. For more information \n please visit https://garage.maemo.org/projects/pggui \n"));
    aboutText->setAlignment(Qt::AlignCenter);


    QHBoxLayout *layout = new QHBoxLayout;
    layout->addWidget(aboutText);


    about->setLayout(layout);

    about->show();




}

void pggui::slotStringReceived()
{

    //Insert if loop here, in order to check the input and to know what to do with it
    // Or maybe control the behaviour through a "Mode" control...

    *strLine = QString(gpg->readAllStandardOutput());

//    if (strLine->contains("Content-Type: multipart/signed")) {
//        QString message;
//        QString signature;
//        int bound;
//        int bound_up;
//        int bound_down;
//        int bound_last;
//        QString boundary;
//        bound = strLine->indexOf("boundary=");
//        bound = bound + 10;
//        boundary = strLine->mid(bound,22);

//        qDebug() << "count: " << strLine->count(boundary);

//        qDebug () << "Boundary at: " << bound;
//        qDebug() << "Boundary string: " << boundary;

//        bound_up = strLine->indexOf(boundary,bound + 1);
//        bound_down = strLine->indexOf(boundary,bound_up +1);
//        bound_last = strLine->indexOf(boundary,bound_down + 1);


//        message = strLine->mid(bound_up + 22,bound_down - bound_up - 24);
//        signature = strLine->mid(bound_down + 22, bound_last - bound_down - 24);


//        qDebug() << "decode: " << message;
//        qDebug() << "Signature: " << signature;
//    }



    //check if encoded message has been encoded in Base64
    if (strLine->contains("Content-Transfer-Encoding: base64")) {
        gpgDecode();        
    } else {
        //decode "quoted-printable". at least a little bit
        if (strLine->contains("Content-Transfer-Encoding: quoted-printable")) {
          strLine->replace("=20"," ");
          strLine->replace("=E2=80=99", "’");

          qDebug() << "Text ist quoted pritable...Decoding";

        }

        gpgText->append(*strLine);
    }

}

void pggui::gpgEncryption()
{


    //    QFile file("/home/user/MyDocs/.documents/encrypted");

    //    if (file.isOpen())
    //    {
    //        gpgText->append("File successfully opened");
    //    } else {
    //        file.open(QFile::ReadOnly);
    //        gpgText->append("manually opened file");
    //    }

    //    if (file.exists())
    //        gpgText->append("file exissts");
    //    if (file.isReadable())
    //        gpgText->append("file is readable");
    //    if (!file.exists())
    //        return;


    //    while (!file.atEnd()) {
    //             QByteArray line = file.readLine();
    //             gpgText->append(line);
    //         }


}

void pggui::gpgDecryption()
{

    gpgText->clear();


    qDebug() << "GPG Decryptionslot started...";

    QFile secring("/home/user/.gnupg-pggui/secring.gpg");

    if (!secring.exists()) {
        QMessageBox::information(this,tr("No private key available"),tr("No private key has been imported. Please do so in order to decrypt messeages. Keys can be imported under \"Key Managmement\" -> \"Import Keys\""));
        return;
        qDebug() << "No keyfile";
    }

    if (secring.size() == 0) {
        QMessageBox::information(this,tr("No private key available"),tr("No private key has been imported. Please do so in order to decrypt messeages. Keys can be imported under \"Key Managmement\" -> \"Import Keys\""));
        return;
        qDebug() << "No keys in file";
    }


    qDebug() <<"Choose File to decrypt...";

    QString fileName;

    fileName = QFileDialog::getOpenFileName(this,tr("Find file"),"~/MyDocs/.documents/",
                                            tr("Encrypted messages (*.gpg *.asc)"));

    qDebug() << "Filename: " << fileName;

    if (fileName.isEmpty()) {
        QMessageBox::information(this,tr(" No File selected!"),tr("No file has been selected! \n Please choose a file next time"));
        qDebug() << "No File selected";
        return;
    }

    dialog->show();

    if (dialog->exec() == QDialog::Accepted) {
        QString password = dialog->getPassword();

    //qDebug() << "password: " << password;

    qDebug() << "Starting gpg";

    QString program = "gpg";
    QStringList arguments;


#ifdef Q_WS_MAEMO_5
    arguments <<"--batch" << "--passphrase-fd" <<"0" << "--homedir" << "/home/user/.gnupg-pggui" << "--decrypt" << fileName;

#endif

#ifndef Q_WS_MAEMO_5
    arguments <<"--batch" << "--passphrase-fd" <<"0" << "--decrypt" << fileName;
#endif


    qDebug() << "Command: " << program << arguments ;
    qDebug() << "Starting now";

    gpg->start(program, arguments);

    gpg->waitForStarted();

    qDebug() << "starting to write";


    QByteArray passwordArray;
    passwordArray.append(password);
    passwordArray.append("\n");
    gpg->write(passwordArray);

    gpg->waitForBytesWritten();
    gpg->closeWriteChannel();

    qDebug() << "Done";

}

   }


void pggui::slotErrorStringReceived()
{
    QString strLine = QString(gpg->readAllStandardError());

    gpgText->append(strLine);
}



void pggui::gpgDecode()
{
    QString *decodeString = new QString(*strLine);
    decodeString->remove(0,77);

    qDebug() << "decodeString: " << *decodeString;

    QByteArray x;
    x.append(*decodeString);

    qDebug() << "x: " << x;

    QByteArray text = QByteArray::fromBase64(x);

    qDebug() << "Text: " << text.data();

    QString y;

    y.append(text.data());

    if (y.contains("Content-Transfer-Encoding: quoted-printable")) {
      y.replace("=20"," ");
      y.replace("=E2=80=99", "’");

      qDebug() << "Text ist quoted pritable...Decoding";
  }

    gpgText->append(y);
}


void pggui::gpgImportKey()
{

    QString fileName;

    fileName = QFileDialog::getOpenFileName(this,tr("Find file"),"~/MyDocs/.documents/",
                                            tr("keys (*.gpg *.asc)"));

    qDebug() << "Filename: " << fileName;

    if (fileName.isEmpty()) {
        QMessageBox::information(this,tr("No Keyfile selected!"),tr(" No file has been selected! \n Please choose a file next time"));
        qDebug() << "No Key for import selected";
        return;
    }
    qDebug() << "Starting gpg for Key import";

    QString program = "gpg";
    QStringList arguments;


#ifdef Q_WS_MAEMO_5
    arguments <<"--batch" << "--homedir" << "/home/user/.gnupg-pggui" << "--import" << fileName;

#endif

#ifndef Q_WS_MAEMO_5
    arguments <<"--batch" << "--import" << fileName;
#endif

    gpgText->clear();
    qDebug() << "Command: " << program << arguments ;
    qDebug() << "Starting now";

    gpg->start(program, arguments);

    gpg->waitForStarted();

    qDebug() << "Done";

    QFile test("/home/user/.gnupg-pggui/secring");

    if (test.exists() && test.size() > 1) {

#ifdef Q_WS_MAEMO_5
        QMaemo5InformationBox::information(this,tr("Keys successfully imported"),QMaemo5InformationBox::DefaultTimeout);
#endif
    }

    system("chmod 0644 /home/user/.gnupg-pggui/pubring.gpg");
    system("chmod 0644 /home/user/.gnupg-pggui/pubring.gpg~");
    system("chmod 0600 /home/user/.gnupg-pggui/secring.gpg");
    system("chmod 0644 /home/user/.gnupg-pggui/trustdb.gpg");
    system("chmod 0600 /home/user/.gnupg-pggui/random_seed");

    KeyManagmentWindow->close();



}

pggui::~pggui()
{

}
