#include <QtGui>
#include "passworddialog.h"

passwordDialog::passwordDialog(QWidget *parent) :
    QDialog(parent)
{
    QLabel *label = new QLabel(tr("Please enter the password"));
    lineEdit = new QLineEdit;
    lineEdit->setEchoMode(QLineEdit::Password);

    okButton = new QPushButton(tr("ok"));

    QHBoxLayout *layout = new QHBoxLayout;
    layout->addWidget(label);
    layout->addWidget(lineEdit);
    layout->addWidget(okButton);

    setLayout(layout);
    setWindowTitle(tr("Enter password"));

    connect(okButton,SIGNAL(clicked()),this,SLOT(okClicked()));
    connect(okButton,SIGNAL(clicked()),this,SLOT(accept()));

}

void passwordDialog::okClicked()
{
    passwordText = lineEdit->text();
    lineEdit->clear();

    hide();

}

QString passwordDialog::getPassword()
{
    return passwordText;
}
