#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#ifdef ENABLE_NOTIFY
#include <libnotify/notify.h>
#endif

#include <QMainWindow>
#include <QAction>
#include <QToolBar>
#include <QPainter>
#include <QShortcut>

#ifdef Q_WS_MAEMO_5
#include "utils/fullscreenexitbutton.h"
#include <QtDBus>
/*
#define __GTK_BINDINGS_H__ //gtkbindings.h:79 has colliding symbol "signal"
extern "C" {
#include <hildon/hildon-banner.h>
}
#undef __GTK_BINDINGS_H__
*/
#endif

#include "widgets/uiaccountsettings.h"
#include "widgets/uinetworksettings.h"
#include <widgets/uihelp.h>
#include "widgets/qimageviewer.h"
#include "widgets/messagecomposer.h"
#include "widgets/qphotouploader.h"

#include "panels/imagebrowserpanel.h"
#include "panels/messagebrowserpanel.h"
#include "panels/profilebrowserpanel.h"

#include "ui/uiapplicationsettings.h"
#include <datatypes/message.h>
#include <servicemgr.h>

#define FRIENDS_PAGE 0
#define IMAGES_PAGE 1
#define MESSAGES_PAGE 2
#define MSG_COMPOSER_PAGE 100

#define _MAINICONSIZE_ 64

#ifdef TARGET
    #define APP_NAME TARGET
#else
    #define APP_NAME "mysocials"
#endif

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT
public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();

signals:
    void closeDialogs();

private:
    QFont usedFont;

    Ui::MainWindow *ui;
    ServiceMgr *sm;

    ImageBrowserPanel *imagesPanel;
    MessageBrowserPanel *messagesPanel;
    ProfileBrowserPanel *profilesPanel;

    MessageComposer *msgComposer;

#ifdef Q_WS_MAEMO_5
    FullScreenExitButton *fullScreenButton;
#endif

    QActionGroup *actionGroup;

    QAction *msgAction;
    QAction *friendAction;
    QAction *albumAction;
    QAction *moreAction;

    void init();
    void createActions();
    void createMenus();
    void showNotification(QString text);

protected:
    void changeEvent(QEvent *e);
    void closeEvent(QCloseEvent *e);

private slots:
    void onFullScreenToggled();
    void onAccountSettingsToggled();
    void onNetworkSettingsToggled();
    void onApplicationSettingsToggled();
    void onUploadImagesToggled();

    void onFriendsTriggered();
    void onMessagesTriggered();
    void onAlbumsTriggered();
    void onMoreTriggered();

    void onActionTriggered(QAction*);

    void openImage(Photo photo);
    void showFriendInfo(Friend fd);
    void showFriendAlbums(Friend fd);
    void showFriendMessages(Friend fd);
    void sendMessage(Friend fd);
    void createNewMessage();
    void replyMessage(Message msg);
    void editMessage(Message msg);
    void saveMessage(Message msg);
    void messageSent();
    void messageDeleted(Message msg);
    void gotErrorMsg(QString errorMsg, QTransport::Action acc, bool isMajor);

    void help();
    void about();

    void orientationChanged();

public slots:

};

#endif // MAINWINDOW_H
