// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#include "uiutils.h"

#ifdef Q_WS_MAEMO_5
#include <QMaemo5InformationBox>
#else
#include <QMessageBox>
#endif

#include <QApplication>
#include <QDesktopWidget>

UiUtils::UiUtils()
{
}

void UiUtils::ShowInformation(const QString &infomsg)
{
#ifdef Q_WS_MAEMO_5
    QMaemo5InformationBox::information(0, infomsg, QMaemo5InformationBox::NoTimeout);
#else
    QMessageBox::information(0, "Movie-Schedule", infomsg);
#endif
}

void UiUtils::ShowError(const QString &errormsg)
{
#ifdef Q_WS_MAEMO_5
    QMaemo5InformationBox::information(0, errormsg, QMaemo5InformationBox::NoTimeout);
#else
    QMessageBox::critical(0, "Movie-Schedule", errormsg);
#endif
}

bool UiUtils::IsLandscape()
{
    QRect screenGeometry = QApplication::desktop()->screenGeometry();
    return (screenGeometry.width() > screenGeometry.height());
}

bool UiUtils::IsPortrait()
{
    return !IsLandscape();
}
