#include "optionsdialog.h"
#include "ui_optionsdialog.h"
#include "uiutils.h"

#include <QMaemo5ValueButton>
#include <QMaemo5ListPickSelector>
#include <QStandardItem>
#include <QBoxLayout>
#include <QDesktopWidget>

static QStandardItem *CreateItem(const QString &label)
{
    QStandardItem *item = new QStandardItem(label);
    item->setTextAlignment(Qt::AlignCenter);
    item->setEditable(false);
    return item;
}

OptionsDialog::OptionsDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::OptionsDialog),
    _rotation_model(new QStandardItemModel(0, 1, this)),
    _rotation_selector(new QMaemo5ListPickSelector())
{
    ui->setupUi(this);
    ui->_button_box->addButton(ui->_done_button, QDialogButtonBox::AcceptRole);
    connect(ui->_button_box, SIGNAL(accepted()), this, SLOT(Accept()));
    connect(ui->_button_box, SIGNAL(accepted()), this, SLOT(deleteLater()));
    connect(ui->_button_box, SIGNAL(rejected()), this, SLOT(Cancel()));
    connect(ui->_button_box, SIGNAL(rejected()), this, SLOT(deleteLater()));
    ui->_rotation_combo_box->setValueLayout(QMaemo5ValueButton::ValueBesideText);
    _rotation_model->appendRow(CreateItem(tr("Landscape")));
    _rotation_model->appendRow(CreateItem(tr("Portrait")));
    _rotation_model->appendRow(CreateItem(tr("Automatic Rotation")));
    _rotation_selector->setModel(_rotation_model);
    _rotation_selector->setCurrentIndex(0);
    ui->_rotation_combo_box->setPickSelector(_rotation_selector);
    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(Rotate()));
    Rotate();
}

OptionsDialog::~OptionsDialog()
{
    delete ui;
}

void OptionsDialog::SetSettings(const Settings &settings)
{
    _settings = settings;
    int i = 0;
    switch (_settings.GetOrientationMode()) {
    case Settings::LANDSCAPE:
        i = 0;
        break;
    case Settings::PORTRAIT:
        i = 1;
        break;
    case Settings::AUTOROTATION:
        i = 2;
        break;
    }
    _rotation_selector->setCurrentIndex(i);
}

Settings OptionsDialog::GetSettings()
{
    switch (_rotation_selector->currentIndex()) {
    case 0:
        _settings.SetOrientationMode(Settings::LANDSCAPE);
        break;
    case 1:
        _settings.SetOrientationMode(Settings::PORTRAIT);
        break;
    case 2:
        _settings.SetOrientationMode(Settings::AUTOROTATION);
        break;
    }
    return _settings;
}

void OptionsDialog::Accept()
{
    emit Accept(GetSettings());
}

void OptionsDialog::Cancel()
{
    emit Cancel(GetSettings());
}

void OptionsDialog::Rotate()
{
    bool landscape = UiUtils::IsLandscape();
    ui->_dialog_layout->setDirection(landscape ? QBoxLayout::LeftToRight : QBoxLayout::TopToBottom);
    ui->_button_box->setOrientation(landscape ? Qt::Vertical : Qt::Horizontal);
    ui->_rotation_combo_box->setValueLayout(landscape ? QMaemo5ValueButton::ValueBesideText : QMaemo5ValueButton::ValueUnderText);
    adjustSize();
}
