// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#include "moviemodel.h"

#include "data/cinemaschedule.h"
#include "data/movie.h"
#include "utils/assertedlocker.h"

#include <iostream>

MovieModel::MovieModel(const CinemaSchedule *cinema_schedule, QObject *parent)
    : QAbstractListModel(parent),
    _cinema_schedule(cinema_schedule)
{
}

int MovieModel::rowCount(const QModelIndex &parent) const
{
    Q_UNUSED(parent);
    AssertedReadLocker locker(_cinema_schedule->GetLock());
    return _cinema_schedule->GetMovies().values().size();
}

QVariant MovieModel::data(const QModelIndex &index, int role) const
{
    AssertedReadLocker locker(_cinema_schedule->GetLock());
    if (!(index.isValid() && index.row() >= 0 && index.row() < _cinema_schedule->GetMovies().values().size())) {
        std::cout << "MovieModel: invalid index" << std::endl;
        return QVariant();
    }
    Movie *movie = _cinema_schedule->GetMovies().values().operator [](index.row());
    if (movie == 0) {
        std::cout << "movie is 0 (row = " << index.row() << ", size = " << _cinema_schedule->GetMovies().values().size() << ")" << std::endl;
        return QVariant();
    }
    switch (role) {
    case Qt::DisplayRole:
    case MovieItemRole:
        return qVariantFromValue(MovieItem(*movie));
    case MovieKeyRole:
        return qVariantFromValue(movie->GetKey());
    case SortRole:
        return QVariant(movie->GetName());
    }
    return QVariant();
}
