// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#ifndef ASYNCCALL_H
#define ASYNCCALL_H

#include "asynccallclient.h"
#include "asynccallproxy.h"

namespace AsyncCallPrivate {

    template<class OBJECT, typename METHOD>
    class AsyncCall0 : public CallProxyBase
    {
    public:
        AsyncCall0(OBJECT *object, const METHOD &method)
            : _object(object),
            _method(method)
        {
        }

        void CallClient()
        {
            AsyncCallClient *client = new AsyncCallClient(_object->thread());
            client->Call(this);
        }

        virtual void Call()
        {
            (_object->*_method)();
        }

    private:
        OBJECT *_object;
        METHOD _method;
    };

    template<class OBJECT, typename METHOD, typename ARG1>
    class AsyncCall1 : public CallProxyBase
    {
    public:
        AsyncCall1(OBJECT *object, const METHOD &method, const ARG1 &arg1)
            : _object(object),
            _method(method),
            _arg1(arg1)
        {   
        }

        void CallClient()
        {
            AsyncCallClient *client = new AsyncCallClient(_object->thread());
            client->Call(this);
        }

        virtual void Call()
        {
            (_object->*_method)(_arg1);
        }

    private:
        OBJECT *_object;
        METHOD _method;
        ARG1 _arg1;
    };

    template<class OBJECT, typename METHOD, typename ARG1, typename ARG2>
    class AsyncCall2 : public CallProxyBase
    {
    public:
        AsyncCall2(OBJECT *object, const METHOD &method, const ARG1 &arg1, const ARG2 &arg2)
            : _object(object),
            _method(method),
            _arg1(arg1),
            _arg2(arg2)
        {
        }

        void CallClient()
        {
            AsyncCallClient *client = new AsyncCallClient(_object->thread());
            client->Call(this);
        }

        virtual void Call()
        {
            (_object->*_method)(_arg1, _arg2);
        }

    private:
        OBJECT *_object;
        METHOD _method;
        ARG1 _arg1;
        ARG2 _arg2;
    };

    template<class OBJECT, typename METHOD, typename ARG1, typename ARG2, typename ARG3>
    class AsyncCall3 : public CallProxyBase
    {
    public:
        AsyncCall3(OBJECT *object, const METHOD &method, const ARG1 &arg1, const ARG2 &arg2, const ARG3 &arg3)
            : _object(object),
            _method(method),
            _arg1(arg1),
            _arg2(arg2),
            _arg3(arg3)
        {
        }

        void CallClient()
        {
            AsyncCallClient *client = new AsyncCallClient(_object->thread());
            client->Call(this);
        }

        virtual void Call()
        {
            (_object->*_method)(_arg1, _arg2, _arg3);
        }

    private:
        OBJECT *_object;
        METHOD _method;
        ARG1 _arg1;
        ARG2 _arg2;
        ARG3 _arg3;
    };

    template<class OBJECT, typename METHOD, typename ARG1, typename ARG2, typename ARG3, typename ARG4>
    class AsyncCall4 : public CallProxyBase
    {
    public:
        AsyncCall4(OBJECT *object, const METHOD &method, const ARG1 &arg1, const ARG2 &arg2, const ARG3 &arg3, const ARG4 &arg4)
            : _object(object),
            _method(method),
            _arg1(arg1),
            _arg2(arg2),
            _arg3(arg3),
            _arg4(arg4)
        {
        }

        void CallClient()
        {
            AsyncCallClient *client = new AsyncCallClient(_object->thread());
            client->Call(this);
        }

        virtual void Call()
        {
            (_object->*_method)(_arg1, _arg2, _arg3, _arg4);
        }

    private:
        OBJECT *_object;
        METHOD _method;
        ARG1 _arg1;
        ARG2 _arg2;
        ARG3 _arg3;
        ARG4 _arg4;
    };
}

template<class OBJECT, typename METHOD>
void CallAsync(OBJECT *object, const METHOD &method)
{
    AsyncCallPrivate::AsyncCall0<OBJECT, METHOD> *async_call = new AsyncCallPrivate::AsyncCall0<OBJECT, METHOD>(object, method);
    async_call->CallClient();
}

template<class OBJECT, typename METHOD, typename ARG1>
void CallAsync(OBJECT *object, const METHOD &method, const ARG1 &arg1)
{
    AsyncCallPrivate::AsyncCall1<OBJECT, METHOD, ARG1> *async_call = new AsyncCallPrivate::AsyncCall1<OBJECT, METHOD, ARG1>(object, method, arg1);
    async_call->CallClient();
}

template<class OBJECT, typename METHOD, typename ARG1, typename ARG2>
void CallAsync(OBJECT *object, const METHOD &method, const ARG1 &arg1, const ARG2 &arg2)
{
    AsyncCallPrivate::AsyncCall2<OBJECT, METHOD, ARG1, ARG2> *async_call = new AsyncCallPrivate::AsyncCall2<OBJECT, METHOD, ARG1, ARG2>(object, method, arg1, arg2);
    async_call->CallClient();
}

template<class OBJECT, typename METHOD, typename ARG1, typename ARG2, typename ARG3>
void CallAsync(OBJECT *object, const METHOD &method, const ARG1 &arg1, const ARG2 &arg2, const ARG3 &arg3)
{
    AsyncCallPrivate::AsyncCall3<OBJECT, METHOD, ARG1, ARG2, ARG3> *async_call = new AsyncCallPrivate::AsyncCall3<OBJECT, METHOD, ARG1, ARG2, ARG3>(object, method, arg1, arg2, arg3);
    async_call->CallClient();
}

template<class OBJECT, typename METHOD, typename ARG1, typename ARG2, typename ARG3, typename ARG4>
void CallAsync(OBJECT *object, const METHOD &method, const ARG1 &arg1, const ARG2 &arg2, const ARG3 &arg3, const ARG4 &arg4)
{
    AsyncCallPrivate::AsyncCall4<OBJECT, METHOD, ARG1, ARG2, ARG3, ARG4> *async_call = new AsyncCallPrivate::AsyncCall4<OBJECT, METHOD, ARG1, ARG2, ARG3, ARG4>(object, method, arg1, arg2, arg3, arg4);
    async_call->CallClient();
}

#endif // ASYNCCALL_H
