#!/usr/bin/python
# -*- coding: koi8-r -*-
import pygtk
pygtk.require('2.0')
import gtk
import gobject
import operator

import hildon

import os
import sys
import time
import zipfile
import StringIO
import copy

PYGTK_MIN_VER = (2, 8, 0)

if gtk.pygtk_version < PYGTK_MIN_VER:
        print "PyGTK version >= %s required, but you have only %s" % (
                ".".join(map(lambda a: str(a), PYGTK_MIN_VER)),
                ".".join(map(lambda a: str(a), gtk.pygtk_version))
                )
        sys.exit(1)

from optparse import OptionParser

PROGRAM = 'metromap'
MAPINI = 'metro.ini'
MAPMAP = 'metro.map'
MAPTRP = 'metro.trp'
MAPCTY = '.cty'
MAPVEC = 'metro.vec'
VECTORS = 'vectors.txt'

one_button = None

MD = None
MetroMap = None
Finder = None

nb = gtk.Notebook()
nb_pages_map = dict()

DTlist = dict()
DeletedTransfers = dict()

AddInfo = dict()

info_win = None
info_name = ''

scalelist = list()
for sc in xrange(5, 21):
        scalelist.append([str(sc * 10) + '%', sc / 10.0])
scale = 1.0

XSIZE, YSIZE = None, None
compact = False
dw, dh = gtk.gdk.screen_width(), gtk.gdk.screen_height()
if dw < 800:
        compact = True
delta = 5

dtime = 0
h = time.localtime()[3]
if h >= 21 or h <= 7:
        dtime = 1

CITY = None

import gettext

binpath = os.path.realpath(os.path.dirname(sys.argv[0]))
if binpath.endswith('/bin'): #FHS
        PREFIX = binpath[:binpath.rfind('/bin')]
        DATAPATH = PREFIX + '/share/' + PROGRAM + '/data/'
        MODULEPATH = PREFIX + '/share/' + PROGRAM + '/modules/'
        gettext.bindtextdomain(PROGRAM, PREFIX + '/share/locale/')
else:
        PREFIX = binpath
        DATAPATH = PREFIX + '/data/'
        MODULEPATH = PREFIX + '/modules/'
        gettext.bindtextdomain(PROGRAM, PREFIX + '/locale/')

sys.path.insert(1, MODULEPATH)
gettext.textdomain(PROGRAM)
_ = lambda a: unicode(gettext.gettext(a), "utf8")

if sys.version_info < (2, 5):
        class UOptionParser(OptionParser):
                def print_help(self, file=None):
                        if file is None:
                                file = sys.stdout
                        file.write(self.format_help().encode(file.encoding, 'replace'))
        oparser = UOptionParser()
else:
        oparser = OptionParser()

oparser.add_option("-d", "--debug", dest="debug", action="store_true", default=False,
                  help=_("Enable debugging messages"))
oparser.add_option("-n", "--no-cache", dest="nocache", action="store_true", default=False,
                  help=_("Disable image caching"),
                  )
#oparser.add_option("-o", "--one-button", dest = "one_button",  action="store_true", default = False,
#                  help = _("select start/end stations with one mouse button (useful when used with stylus)"),
#                  )
def ob_cb(option, opt, value, parser):
        global one_button
        one_button = True

oparser.add_option("-o", "--one-button", action="callback", callback=ob_cb,
                  help=_("select start/end stations with one mouse button (useful when used with stylus)"),
                  )
(options, args) = oparser.parse_args()

DEBUG = options.debug

from ReadMap import ReadMap, GetMapName, ReadVec, ReadAddInfo
from FindPath import FindPath

import MapDisplay
MapDisplay._ = _
from MapDisplay import MapDisplay, StationDisplay

import Interface
Interface._ = _

RCDIR = os.environ.get('HOME') + "/." + PROGRAM
CACHEDIR = RCDIR + '/cache'

if not os.path.isdir(RCDIR):
        try:
                os.mkdir(RCDIR)
        except:
                pass

if not os.path.isdir(CACHEDIR):
        try:
                os.mkdir(CACHEDIR)
        except:
                pass

if options.nocache:
        CACHEDIR = None

if DEBUG:
        print "Started"

#load config
if os.path.isfile(RCDIR + "/rc"):
        f = file(RCDIR + "/rc", 'r')
        done = False
        while not done:
                s = f.readline()
                if not s:
                        break
                p = s.split('=')
                if len(p) == 2:
                        if p[0] == 'city':
                                CITY = p[1].rstrip()
                        elif p[0] == 'zoom':
                                scale = float(p[1].rstrip())
                                if not scale in map(lambda a: a[1], scalelist):
                                        scale = 1
                        elif p[0] == 'xsize':
                                XSIZE = int(p[1].rstrip())
                        elif p[0] == 'ysize':
                                YSIZE = int(p[1].rstrip())
                        elif p[0] == 'delta':
                                delta = int(p[1].rstrip())
                                if delta < 0:
                                        delta = 0
                                elif delta > 99:
                                        delta = 99
                        elif p[0] == 'compact':
                                if p[1].rstrip().lower() == "true":
                                        compact = True
                        elif p[0] == 'one_button_mode':
                                if one_button == None: #do not overwrite if specifed on command line
                                        if p[1].rstrip().lower() == "true":
                                                one_button = True
                                        else:
                                                one_button = False
                        elif p[0].startswith('dt[') and p[0][-1] == ']':
                                DTlist[p[0][3:-1]] = list()
                                sp = p[1].rstrip().split(',')
                                for pair in sp:
                                        l = pair.rstrip().lstrip().split('-', 2)
                                        if len(l) == 2 and l[0].isdigit() and l[1].isdigit():
                                                DTlist[p[0][3:-1]].append((int(l[0]), int(l[1])))
        f.close()

if one_button == None: #not set from command line and/or config file, set default value
        one_button = False

#save config
def save_config():
        try:
                f = file(RCDIR + "/rc", 'w')
                f.write('city=' + CITY + '\n')
                f.write('xsize=' + str(Iface.xsize) + '\n')
                f.write('ysize=' + str(Iface.ysize) + '\n')
                f.write('delta=' + str(delta) + '\n')
                if Iface.compact_mode:
                        f.write('compact=true\n')
                else:
                        f.write('compact=false\n')
                if Iface.one_button:
                        f.write('one_button_mode=true\n')
                else:
                        f.write('one_button_mode=false\n')
                f.write('zoom=' + str(scale) + '\n')
                for c in DTlist.keys():
                        if len(DTlist[c]):
                                st = 'dt[' + c + ']='
                                for p in DTlist[c]:
                                        st += str(p[0]) + '-' + str(p[1]) + ','
                                st = st[:-1] + '\n'
                                f.write(st)
                f.close()
        except:
                pass

def sync_to_dt():
        DTlist[CITY] = list()
        for dt in DeletedTransfers.keys():
                if not (dt[0], dt[1]) in DTlist[CITY] and not (dt[1], dt[0]) in DTlist[CITY]:
                        DTlist[CITY].append((dt[0], dt[1]))

def sync_from_dt():
        global DeletedTransfers

        DeletedTransfers = dict()
        if DTlist.has_key(CITY):
                Finder.set_graph(dt_disable(Finder.graph, DTlist[CITY]))

def atexit(foo):
        save_config()
        gtk.main_quit()

st_start = None
st_end = None
path_list = list()

def ciext_file_find(path, name, ext):
        for f in os.listdir(path):
                if f.startswith(name) and len(f) == len(name) + len(ext) + 1 and \
                   f[-len(ext):].lower() == ext.lower():
                        return f
        #not found, return some shit
        return name + '.' + ext

def nocase_find(name, namelist):
        ll = map(lambda a: a.lower(), namelist)
        if name.lower() in ll:
                return namelist[ll.index(name.lower())]
        return None

def get_data_full(datapath, city, filename, ui_update_func=None):
        f = None
        n = None
        flist = list()
        try:
                flist = os.listdir(datapath + city + '/')
                if ui_update_func:
                        ui_update_func()
                filename = nocase_find(filename, flist)
                n = datapath + city + '/' + filename
                f = open(n)
        except:
                try:
                        n = datapath + ciext_file_find(datapath, city, 'pmz')
                        z = zipfile.ZipFile(n, 'r')
                        if ui_update_func:
                                ui_update_func()
                        flist = z.namelist()
                        filename = nocase_find(filename, flist)
                        f = StringIO.StringIO(z.read(filename))
                        z.close()
                        if ui_update_func:
                                ui_update_func()
                except:
                        try:
                                n = datapath + ciext_file_find(datapath, city, 'zip')
                                z = zipfile.ZipFile(n, 'r')
                                if ui_update_func:
                                        ui_update_func()
                                intn = city + '.pmz'
                                for zn in z.namelist():
                                        if zn.lower() == city.lower() + '.pmz':
                                                intn = zn
                                                break
                                pmzf = StringIO.StringIO(z.read(intn))
                                z.close()
                                if ui_update_func:
                                        ui_update_func()
                                z = zipfile.ZipFile(pmzf, 'r')
                                flist = z.namelist()
                                filename = nocase_find(filename, flist)
                                f = StringIO.StringIO(z.read(filename))
                                z.close()
                                if ui_update_func:
                                        ui_update_func()
                        except:
                                n = _("unknown")
                                f = None
        return n, f, flist

def get_data(city, filename, ui_update_func=None):
        for dp in DATAPATH, RCDIR + '/':
                n, f, flist = get_data_full(dp, city, filename, ui_update_func)
                if f:
                        break
        return n, f, flist

if DEBUG:
        start_time = time.time()
citylist = list()
for dp in DATAPATH, RCDIR + '/':
        if not os.path.isdir(dp):
                continue
        for c in os.listdir(dp):
                cn = c
                if c.lower().endswith('.zip') or c.lower().endswith('.pmz'):
                        cn = c[:-4]
                n, f, flist = get_data_full(dp, cn, MAPINI)
                if not f:
                        n, f, flist = get_data_full(dp, cn, cn + MAPCTY)
                if f:
                        name = GetMapName(f)
                        f.close()
                        if name:
                                citylist.append((name, cn))
if DEBUG:
        print _("List data files time:"), time.time() - start_time

if len(citylist) == 0:
        print unicode(_('No data files found, please install some.'))
        sys.exit(0)

if not CITY or not len(filter(lambda a: a[1] == CITY, citylist)):
        if len(filter(lambda a: a[1] == "Moscow", citylist)):
                CITY = "Moscow"
        else:
                CITY = citylist[0][1]

def station_selected(station, isstart):
        global st_start, st_end, path_list

        if st_start != station and st_end != station:
                if isstart:
                        st_start = station
                        Iface.set_from(station)
                        MD.set_start_station(station)
                else:
                        st_end = station
                        Iface.set_to(station)
                        MD.set_stop_station(station)

                if st_start != None and st_end != None:
                        path_list = Finder.waves_accurate(st_start, st_end, MetroMap.WaitLen)
                        path_list.sort()

                if len(path_list):
                        MD.set_path_list(path_list[0][2:])
                else:
                        MD.set_path_list(None)

                Iface.set_path_list(map(lambda a: _("Minutes: %s Changes: %d Stations: %d") % 
                        (("%.2f" % (a[0])).rstrip("0").rstrip("."), a[1], len(a) - a[1] - 3), path_list))

def list_selected(num):
        global path_list

        if path_list and num >= 0 and num < len(path_list):
                MD.set_path_list(path_list[num][2:])

def zoom_changed(zoom):
        global scale

        if scale != zoom:
                scale = zoom
                city_changed(None, None)

def city_changed(name):
        global st_start, st_end, path_list, MetroMap, MD, Finder, prefs, CITY, dtime, delta, scale, AddInfo, DEBUG

        if MD and MD.da:
                MD.da.hide()

        if name != None:
                Iface.progress_start(_("Reading map %s") % (name))
                if DEBUG:
                        start_time = time.time()
                CITY = name
                st_start = st_end = None
                path_list = list()
                n, f, flist = get_data(CITY, MAPINI, Iface.update)
                if not f:
                        #probably "new" map format
                        n, fcty, flist = get_data(CITY, CITY + MAPCTY, Iface.update)
                        if fcty:
                                n, fmap, flist = get_data(CITY, MAPMAP, Iface.update)
                                if fmap:
                                        vec_filename = CITY+MAPVEC
                                        for line in fmap.readlines():
                                            if line.startswith('ImageFileName='):
                                                vec_filename = line[14:].strip()
                                                if vec_filename.find(",") != -1:
                                                    filenames = vec_filename.split(",")
                                                    for n in filenames:
                                                        if n.find(".vec") != -1:
                                                            vec_filename = n
                                        fmap.seek(0)

                                        n, ftrp, flist = get_data(CITY, MAPTRP, Iface.update)
                                        if ftrp:
                                                n1, fvec, fl1 = get_data(CITY, vec_filename, Iface.update)
                                                f = (fcty, fmap, ftrp, fvec)
                if not f:
                        print unicode(_('Cannot find ') + MAPINI + _(' for city "') + CITY + '"')
                        sys.exit(0)

                Iface.progress_set_percentage(25)
                Iface.progress_set_text(_("Loading vectors"))
                vn, vf, devnull = get_data(CITY, VECTORS, Iface.update)
                if DEBUG:
                        print _("Load data time:"), time.time() - start_time
                        start_time = time.time()
                Iface.progress_set_percentage(50)
                Iface.progress_set_text(_("Parsing map data"))

                MetroMap = ReadMap(f, vf, Iface.update)
                if DEBUG:
                        print _("ReadMap time:"), time.time() - start_time
                Iface.progress_set_percentage(75)
                Iface.progress_set_text(_("Loading additional information"))
                if vf:
                        vf.close()
                if type(f) == tuple:
                        for fd in f:
                            if fd:
                                fd.close()
                else:
                        f.close()

                if DEBUG:
                        start_time = time.time()
                AddInfo = dict()
                txt_list = filter(lambda a: a.lower().endswith('.txt'), flist)
                for t in txt_list:
                        Iface.progress_set_percentage(75 + 15.0 / len(txt_list))
                        vn, vf, devnull = get_data(CITY, t, Iface.update)
                        if vf:
                                ai = ReadAddInfo(vf, MetroMap.MapEncoding)
                                if ai.name:
                                        AddInfo[ai.name] = ai
                                else:
                                        #some 'special' file
                                        pass
                if DEBUG:
                        print _("Load txt's time:"), time.time() - start_time

                MetroMap.SetDelayTime(dtime)
                Iface.update()

        if name == None:
                Iface.progress_start(_("Calculating map %s") % (name))
        snames = map(lambda a: ["%s (%s)" % (a['name'], MetroMap.Lines[a['line']]['name']), a['number']], MetroMap.Stations.values())
        snames.sort()

        sh = False #hack for StPetersburg map
        if CITY.lower() == 'peterburg':
                sh = True

        mdlines = copy.deepcopy(MetroMap.Lines)
        mdstations = copy.deepcopy(MetroMap.Stations)
        mdvectors = copy.deepcopy(MetroMap.Map['vectors'])
        Iface.update()

        if DEBUG:
                start_time = time.time()
        if scale != 1:
                Iface.progress_set_text(_("Scaling"))
                for k in mdlines.keys():
                        Iface.update()
                        mdlines[k]['diameter'] = int(round(mdlines[k]['diameter'] * scale))
                for k in mdstations.keys():
                        Iface.update()
                        mdstations[k]['diameter'] = int(round(mdstations[k]['diameter'] * scale))
                        for ak in mdstations[k]['add'].keys():
                                for i in xrange(len(mdstations[k]['add'][ak]['coords'])):
                                        foo = mdstations[k]['add'][ak]['coords'][i]
                                        mdstations[k]['add'][ak]['coords'][i] = (int(round(foo[0] * scale)), int(round(foo[1] * scale)))
                        mdstations[k]['x'] = int(round(mdstations[k]['x'] * scale))
                        mdstations[k]['y'] = int(round(mdstations[k]['y'] * scale))
                        mdstations[k]['namerect'][0] = int(round(mdstations[k]['namerect'][0] * scale))
                        mdstations[k]['namerect'][1] = int(round(mdstations[k]['namerect'][1] * scale))
                        mdstations[k]['namerect'][2] = int(round(mdstations[k]['namerect'][2] * scale))
                        mdstations[k]['namerect'][3] = int(round(mdstations[k]['namerect'][3] * scale))
                if mdvectors.has_key('lineswidth'):
                        Iface.update()
                        mdvectors['lineswidth'] = int(round(mdvectors['lineswidth'] * scale))
                for i in xrange(len(mdvectors['instructions'])):
                        Iface.update()
                        if mdvectors['instructions'][i][0] == 'spline':
                                mdvectors['instructions'][i][1] = int(round(mdvectors['instructions'][i][1] * scale))
                                for j in xrange(len(mdvectors['instructions'][i][2])):
                                        foo = mdvectors['instructions'][i][2][j]
                                        mdvectors['instructions'][i][2][j] = (int(round(foo[0] * scale)), int(round(foo[1] * scale)))
                        elif mdvectors['instructions'][i][0] == 'text':
                                mdvectors['instructions'][i][1]['size'] = int(round(mdvectors['instructions'][i][1]['size'] * scale))
                                mdvectors['instructions'][i][1]['x'] = int(round(mdvectors['instructions'][i][1]['x'] * scale))
                                mdvectors['instructions'][i][1]['y'] = int(round(mdvectors['instructions'][i][1]['y'] * scale))
        Iface.progress_set_percentage(100)
        Iface.progress_set_text(_("Starting"))
        if DEBUG:
                print _("Scale time:"), time.time() - start_time

        if DEBUG:
                start_time = time.time()
        MD = MapDisplay(mdlines, mdstations, mdvectors, station_selected, sh, cachedir=CACHEDIR, debug=DEBUG, pb=Iface, one_button=Iface.one_button)
        Iface.update()
        if DEBUG:
                print _("New MapDisplay time:"), time.time() - start_time
                start_time = time.time()
        MD.set_menu(Iface.menu_callback, Iface.menu_items)
        MD.set_dtcb(transfers_cb)
        Iface.progress_end()

        if name != None:
                Iface.set_path_list([])
        Iface.set_da(MD.da)
        Iface.set_st_list(snames)
        Iface.set_dtime(dtime)
        Iface.set_win_title(PROGRAM + ' - ' + MetroMap.Map['city'])
        Iface.set_one_button_cb(MD.set_one_button)
        if name == None:
                MD.set_start_station(st_start)
                MD.set_stop_station(st_end)
                Iface.set_from(st_start)
                Iface.set_to(st_end)
                Iface.path_selected(None,None)
        if name != None:
                if not Finder:
                        Finder = FindPath(MetroMap.Graph, delta)
                else:
                        Finder.set_graph(MetroMap.Graph)
        sync_from_dt()
        if DEBUG:
                print _("Rest of city changed time:"), time.time() - start_time

def show_info(st):
    #for st in MetroMap.Stations.keys():
        global info_name
        global info_win
        global numpages
        global button_info
        
        if st != None:
                sd = None
                if MetroMap.Stations[st].has_key('vfile'):
                        n, f, devnull = get_data(CITY, MetroMap.Stations[st]['vfile'])
                        if not f:
                                Interface.SimpleMessageBox('error', PROGRAM, _('File not found'),
                                                           _('Cannot find ') + MetroMap.Stations[st]['vfile'],
                                                           gtk.STOCK_OK, Iface.win)
                                return

                        rv = ReadVec(f.readlines())
                        for i in xrange(len(rv.data['instructions'])):
                                if rv.data['instructions'][i][0] == 'text':
                                        rv.data['instructions'][i][1]['text'] = unicode(rv.data['instructions'][i][1]['text_orig'], MetroMap.MapEncoding)
                        f.close()
                        sd = StationDisplay(rv.data)

                info_name = MetroMap.Stations[st]['name']

                info_win = hildon.StackableWindow()
                info_win.set_title(info_name)
                info_win.set_wmclass(PROGRAM + 'StInfo', PROGRAM)
                info_win.set_resizable(False)

                menu = hildon.AppMenu()
                info_win.set_app_menu(menu)

                if sd:
                        s_swin = Interface.SWin(sd.da)

                info_win.set_default_size(Iface.Swin.swin.get_allocation().width, Iface.Swin.swin.get_allocation().height)

                nb.set_show_tabs(False)

                if sd:
                        s_swin.swin.set_size_request(0, (Iface.Swin.swin.get_allocation().height / 3) * 2)

                button_info = []
                
                numpages = 0
                nb_pages_map.clear()
                for ai in AddInfo.keys():
                        s = MetroMap.Stations[st]['name'].lower()
                        l = MetroMap.Lines[MetroMap.Stations[st]['line']]['name'].lower()
                        if AddInfo[ai].data.has_key((l, s)):
                                if sd and AddInfo[ai].data[(l, s)] == MetroMap.Stations[st]['vfile']:
                                        nb.append_page(s_swin.swin, gtk.Label(ai))
                                else:
                                        view = hildon.TextView()
                                        view.set_wrap_mode(gtk.WRAP_WORD_CHAR)
                                        view.set_editable(False)
                                        view.set_cursor_visible(True)
                                        view.get_buffer().set_text(AddInfo[ai].data[(l, s)].replace(r"\n", chr(0x0a)))
                                        swin = hildon.PannableArea()
                                        swin.mode = hildon.PANNABLE_AREA_MODE_ACCEL
                                        #swin.set_shadow_type(gtk.SHADOW_IN)
                                        #swin.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
                                        swin.add(view)
                                        nb.append_page(swin, gtk.Label(ai))
                                nb_pages_map.setdefault(ai, numpages)

                                if numpages == 9:
#                                    if info_selector:
#                                        info_selector.destroy()
                                        
                                    info_selector = hildon.TouchSelector(text=True)
                                    info_selector.connect("changed", info_selected)
                                    
                                    button_more = hildon.PickerButton(gtk.HILDON_SIZE_AUTO,
                                                                     hildon.BUTTON_ARRANGEMENT_HORIZONTAL)
                                    button_more.set_title("More...")
                                    menu.append(button_more)
                                    button_more.show()
                                    button_more.set_selector(info_selector)
                                    
                                numpages += 1

                                if numpages < 10:
                                    button_info.append(hildon.Button(gtk.HILDON_SIZE_AUTO,
                                                 hildon.BUTTON_ARRANGEMENT_HORIZONTAL))
                                    button_info[len(button_info)-1].set_title(ai)
                                    menu.append(button_info[len(button_info)-1])
                                    #pannable.add_with_viewport(button_info)
                                    button_info[len(button_info)-1].connect("clicked", info_clicked)
                                    button_info[len(button_info)-1].show()
                                else:
                                    info_selector.append_text(ai)

                if numpages:
                        if numpages > 9:
                            info_selector.show()
                        info_win.add(nb)
                else:
                        info_win.add(gtk.Label(_("Sorry, no info available")))

                if numpages > 0:
                    info_win.set_title(info_name + " (" + button_info[0].get_title() + ")")
                else:
                    info_win.set_title(info_name)
                

                info_win.show_all()

def filter_clicked(self, button_info, menu, info_win):
        for b in button_info:
            b.hide()
        start = int(self.get_label())-1
        for i in range(start*10, min((start*10)+10,len(button_info))):
            button_info[i].show()
        menu.popup(info_win)

def info_clicked(self):
        global info_name
        global info_win
        info_win.set_title(info_name + " (" + self.get_title() + ")")
        nb.set_current_page(int(nb_pages_map.get(unicode(self.get_title()))))

def info_selected(self, foo):
        global info_name
        global info_win
        info_win.set_title(info_name + " (" + self.get_current_text() + ")")
        nb.set_current_page(int(nb_pages_map.get(unicode(self.get_current_text()))))

def dt_enable(g, pairs):
        for p in pairs:
                for tr in DeletedTransfers[(p[0], p[1])]:
                        g[p[0]].append(tr)
                        g[p[1]].append(tr)
                del DeletedTransfers[(p[0], p[1])]
                del DeletedTransfers[(p[1], p[0])]
        return g

def dt_disable(g, pairs):
        for p in pairs:
                DeletedTransfers[(p[0], p[1])] = list()
                DeletedTransfers[(p[1], p[0])] = list()
                for tr in g[p[0]]:
                        if tr[0] == p[1]:
                                DeletedTransfers[(p[0], p[1])].append(tr)
                                DeletedTransfers[(p[1], p[0])].append(tr)
                                g[p[0]].remove(tr)
                                break
                for tr in g[p[1]]:
                        if tr[0] == p[0]:
                                DeletedTransfers[(p[0], p[1])].append(tr)
                                DeletedTransfers[(p[1], p[0])].append(tr)
                                g[p[1]].remove(tr)
                                break
        return g

def transfers_cb(act, sfrom=None, sto=None):
        if act == 'get':
                return DeletedTransfers
        elif act == 'set':
                if sfrom == None or sto == None: #enable all disabled transfers
                        Finder.set_graph(dt_enable(Finder.graph, DTlist[CITY]))
                else:
                        if DeletedTransfers.has_key((sfrom, sto)):
                                Finder.set_graph(dt_enable(Finder.graph, [[sfrom, sto]]))
                        else:
                                Finder.set_graph(dt_disable(Finder.graph, [[sfrom, sto]]))
                recalc_paths()
                sync_to_dt()

def recalc_paths():
        global st_start

        if st_start != None:
                station = st_start
                st_start = None
                station_selected(station, True)

def dtime_changed(num):
        global MetroMap, dtime

        if num != dtime:
                dtime = num
                MetroMap.SetDelayTime(dtime)
                recalc_paths()

def delta_changed(num):
        global delta

        if num != delta:
                delta = num
                Finder.maxerror = delta
                recalc_paths()

                win.set_wmclass(PROGRAM + 'StInfo', PROGRAM)

Iface = Interface.Interface(PROGRAM, None, citylist=citylist, compact=compact, delta=delta,
                            citynow=CITY, xsize=XSIZE, ysize=YSIZE,
                            zoomlist=scalelist, zoomnow=scale, one_button=one_button)
Iface.win.connect('destroy', atexit)
Iface.set_path_cb(list_selected)
Iface.set_station_cb(station_selected)
Iface.set_city_cb(city_changed)
Iface.set_dtime_cb(dtime_changed)
Iface.set_delta_cb(delta_changed)
Iface.set_zoom_cb(zoom_changed)
Iface.quit_cb = atexit
Iface.show_info_cb = show_info

if DEBUG:
        start_time = time.time()
city_changed(CITY)
if DEBUG:
        print _("City changed total time:"), time.time() - start_time

gtk.main()

