#ifndef TOOLBARICON1_H
#define TOOLBARICON1_H

#include <QGraphicsWidget>
#include <QPainter>
#include <QStyleOptionGraphicsItem>

//GraphicsWidget is a QGraphicsWidget with a background
class GraphicsWidget : public QGraphicsWidget {
    Q_OBJECT
public:
    GraphicsWidget(QGraphicsItem *parent = 0) : QGraphicsWidget(parent)
    {}

    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget* = 0)
    {
        painter->setBrush(palette().window());
        painter->setPen(Qt::NoPen);
        painter->drawRect(boundingRect());
    }
    
};

//ToolBarIcons are used in the reading UI.
class ToolbarIcon : public QGraphicsWidget {
    Q_OBJECT
public:
    ToolbarIcon(const QString&, const QString&, QGraphicsItem *parent = 0);
    void paint(QPainter*, const QStyleOptionGraphicsItem*, QWidget* = 0);
    QRectF boundingRect() const;
    QSizeF sizeHint(Qt::SizeHint, const QSizeF& = QSizeF()) const;

protected:
    void mousePressEvent(QGraphicsSceneMouseEvent*);
    void mouseReleaseEvent(QGraphicsSceneMouseEvent*);

private:
    QPixmap pixmapNormal;
    QPixmap pixmapPressed;

signals:
    void pressed();
    void released();
};

#endif
