#include "toolbaricon.h"
#include <QStyleOptionGraphicsItem>
#include <QPainter>


ToolbarIcon::ToolbarIcon(const QString &normalIcon, const QString &pressedIcon, QGraphicsItem *parent) : QGraphicsWidget(parent)
{
    pixmapNormal.load(normalIcon);
    pixmapPressed.load(pressedIcon);
}

void ToolbarIcon::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *w)
{
    bool isDown = option->state & QStyle::State_Sunken;
    if(!isDown)
        painter->drawPixmap(0, 0, pixmapNormal);
    else
        painter->drawPixmap(0, 0, pixmapPressed);
}

QRectF ToolbarIcon::boundingRect() const
{
    return pixmapNormal.rect();
}
    
QSizeF ToolbarIcon::sizeHint(Qt::SizeHint which, const QSizeF &constraint) const
{
    if(which == Qt::MinimumSize)
        return pixmapNormal.size();
    else //if(which == Qt::MaximumSize)
        return constraint;
}

void ToolbarIcon::mousePressEvent(QGraphicsSceneMouseEvent*)
{
    update();
    emit pressed();
}

void ToolbarIcon::mouseReleaseEvent(QGraphicsSceneMouseEvent*)
{
    update();
    emit released();
}
