#ifndef SEARCHCATALOGSVIEW_H
#define SEARCHCATALOGSVIEW_H

#include <QLineEdit>
#include <QVBoxLayout>
#include <QScrollArea>
#include <QAbstractKineticScroller>
#include <QPushButton>

#include "book.h"
#include "feedbooks.h"
#include "booklistitem.h"

class SearchCatalogsView : public QWidget{
    Q_OBJECT
public:
    SearchCatalogsView(Catalog* c, QWidget *parent = 0); 

public slots:
    void searchButtonPressed();
    void addBook(Book*);
    void openBookInfo(Book*);
    void bookCount(int);

signals:
    void closing();

private:
    QLineEdit *searchEdit;
    QVBoxLayout *listLayout;
    QWidget *listContainer;
    QScrollArea *scrollArea;
    Catalog* catalog;

protected:
    void closeEvent(QCloseEvent*);
};


#endif
