#include "scrollablepage.h"
#include <QDebug>
#include <QWebElement>

ScrollablePage::ScrollablePage(QGraphicsItem *parent, Qt::WindowFlags wFlags) : QGraphicsWidget(parent, wFlags)
{
    setFiltersChildEvents(true);
    content = new GraphicsWebView(this);
    time.start();
}

QRectF ScrollablePage::boundingRect() const
{
    return geometry();
}

void ScrollablePage::setPage(QWebPage *page)
{
    content->setPage(page);
    page->setParent(content);
    QSizeF s = page->mainFrame()->contentsSize();
    s = s.expandedTo(size());
    content->setGeometry(QRectF(content->geometry().topLeft(), s));
    QSizeF prefS = page->preferredContentsSize();
    content->setMaximumWidth(prefS.width()-10);
}

void ScrollablePage::setPosition(int pos)
{
    setScrollPosition(QPoint(0, pos), QPoint(0, 0));
}

int ScrollablePage::getPosition()
{
    return -content->pos().y();
}

void ScrollablePage::scrollToAnchor(const QString &anchor)
{
    QWebElement element = content->page()->mainFrame()->findFirstElement(anchor);
    setScrollPosition(QPoint(0, element.geometry().topLeft().y()), QPoint(0, 0));
}

void ScrollablePage::scrollBy(int scroll)
{
    QPoint position = scrollPosition();
    int newYPosition = position.y() + scroll;
    position.setY(newYPosition);

    setScrollPosition(position, QPoint(0, 0));
}


void ScrollablePage::mousePressEvent(QGraphicsSceneMouseEvent *event)
{
    handleMouseEvent(event);
}
void ScrollablePage::mouseReleaseEvent(QGraphicsSceneMouseEvent *event)
{
    handleMouseEvent(event);
}
void ScrollablePage::mouseMoveEvent(QGraphicsSceneMouseEvent *event)
{
    handleMouseEvent(event);
}
void ScrollablePage::mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event)
{
    handleMouseEvent(event);
}

bool ScrollablePage::sceneEventFilter(QGraphicsItem *item, QEvent *event)
{
    bool res = false;
    if (item && (item == content) && content->isEnabled()) {
        switch (event->type()) {
            case QEvent::GraphicsSceneMousePress:
            case QEvent::GraphicsSceneMouseMove:
            case QEvent::GraphicsSceneMouseRelease:
            case QEvent::GraphicsSceneMouseDoubleClick:{
                QGraphicsSceneMouseEvent *e = reinterpret_cast<QGraphicsSceneMouseEvent *>(event);
                res = handleMouseEvent(e);
                break;
            }
            default:
                break;
        }
    }
    if (event->type() == QEvent::GraphicsSceneMouseMove)
        return true;
    return res ? true : QGraphicsWidget::sceneEventFilter(item, event);
}

QSize ScrollablePage::viewportSize() const
{
    return size().toSize();
}
QPoint ScrollablePage::maximumScrollPosition() const
{
    QSizeF s = content->size() - size();
    return QPoint(qMax(0, int(s.width())), qMax(0, int(s.height())));
}

QPoint ScrollablePage::scrollPosition() const
{
    return -content->pos().toPoint() + overShoot;
}

void ScrollablePage::setScrollPosition(const QPoint &p, const QPoint &os)
{
    overShoot = os;
    content->setPos(-p + overShoot);
    if(time.elapsed() > 1000){
        emit positionChanged(getPosition());
        time.restart();
    }
}
