#include "mainwindow.h"
#include "bookmark.h"
#include "addbookmarkdialog.h"
#include "addannotationdialog.h"
#include <QAction>
#include <QMenu>
#include <QMaemo5InformationBox>
#include <QHBoxLayout>

#include <QtGui/QX11Info>
#include <X11/Xlib.h>
#include <X11/Xatom.h>

MainWindow::MainWindow(osso_context_t *context, QWidget *parent) : QWidget(parent)
{
    bookView = new BookView(this);
    QHBoxLayout *layout = new QHBoxLayout(this);
    layout->addWidget(bookView);
    layout->setSpacing(0);
    layout->setMargin(0);
//    setCentralWidget(bookView); 

    connect(this, SIGNAL(volumeUpPressed()), bookView, SLOT(volumeUpPressed()));
    connect(this, SIGNAL(volumeDownPressed()), bookView, SLOT(volumeDownPressed()));

    connect(bookView, SIGNAL(closeWindow()), this, SLOT(close()));

    setWindowFlags(windowFlags() | Qt::Window);
    setAttribute(Qt::WA_Maemo5StackedWindow, true);
    grabZoomKeys(true);

    osso_context = context;
    brightnessTimer.setInterval(50000);
    connect(&brightnessTimer, SIGNAL(timeout()), this, SLOT(forceBacklightOn()));
    brightnessTimer.start();

}

MainWindow::~MainWindow()
{
    grabZoomKeys(false);
}

void MainWindow::openBook(const QString &filename)
{
    Book *book = new Book(filename);
    openBook(book);
}

void MainWindow::openBook(Book *book)
{
    if(bookView)
        bookView->setBook(book);
    currentBook = book;
    forceBacklightOn();
    showFullScreen();
}

void MainWindow::setFont(const QString &family, int size)
{
    if(bookView)
        bookView->setFont(family, size);
}

void MainWindow::setColorMode(int mode)
{
    if(bookView)
        bookView->setNightMode(mode);
}

void MainWindow::enableBacklightForcing(bool toggle)
{
    if(toggle)
        brightnessTimer.start();
    else
        brightnessTimer.stop();
}

void MainWindow::setViewMode(BookViewMode mode, Qt::WidgetAttribute orientation)
{
    if(bookView)
        bookView->setViewMode(mode, orientation);
}


void MainWindow::keyPressEvent(QKeyEvent *event)
{
    if(event->key() == Qt::Key_F7)
        emit volumeUpPressed();
    else if(event->key() == Qt::Key_F8)
        emit volumeDownPressed();
    QWidget::keyPressEvent(event);
}


void MainWindow::grabZoomKeys(bool grab)
{
    if(!winId()){
        qDebug("Can't grab keys unless we have a window id");
        return;
    }

    unsigned long val = (grab) ? 1 : 0;
    Atom atom = XInternAtom(QX11Info::display(), "_HILDON_ZOOM_KEY_ATOM", False);
    if(!atom){
        qDebug("Unable to obtain _HILDON_ZOOM_KEY_ATOM.");
        return;
    }

    XChangeProperty(QX11Info::display(),
        winId(),
        atom,
        XA_INTEGER,
        32,
        PropModeReplace,
        reinterpret_cast<unsigned char*>(&val),
        1);

}

void MainWindow::closeEvent(QCloseEvent *event)
{
    if(bookView)
        bookView->saveProgress(); 
    event->accept();
    deleteLater();
}


void MainWindow::forceBacklightOn()
{
    //Only force backlight if MainWindow is active.
    if(osso_context && isActiveWindow())
        osso_display_blanking_pause(osso_context);
}

