#ifndef LISTVIEWDIALOG_H
#define LISTVIEWDIALOG_H

#include <QListView>
#include <QHBoxLayout>
#include <QDebug>
#include <QMenu>
#include <QDialog>
#include <QApplication>
#include "listmodel.h"
#include "listitemdelegate.h"

class ListViewDialog : public QDialog{
    Q_OBJECT
public:
    ListViewDialog(QWidget *parent = 0, bool enableDelete = false) : QDialog(parent){
        view = new QListView(this);
        if(enableDelete){
            view->setContextMenuPolicy(Qt::CustomContextMenu);
            connect(view, SIGNAL(customContextMenuRequested(const QPoint&)), this, SLOT(openContextMenu(const QPoint&)));
        }
        ListItemDelegate *delegate = new ListItemDelegate(this);
        view->setItemDelegate(delegate);
        QHBoxLayout *layout = new QHBoxLayout(); 
        layout->setSpacing(0);
        layout->setMargin(0);
        layout->addWidget(view);
        setLayout(layout);
        connect(view, SIGNAL(activated(const QModelIndex&)), this, SLOT(itemSelected(const QModelIndex&)));

        view->setSelectionMode(QAbstractItemView::SingleSelection);
        int screenHeight = QApplication::desktop()->height();
        setMinimumHeight(screenHeight - 140);
    }

    void setModel(QAbstractItemModel *model){
        view->setModel(model);
    }

private:
    QListView *view;

public slots:
    void itemSelected(const QModelIndex &index){
        emit selectedIndex(index.row());
        emit selectedString(index.data(Qt::DisplayRole).toString());
        close();
    }

    void openContextMenu(const QPoint &pos)
    {
        QMenu *menu = new QMenu();
        QAction *deleteAction = menu->addAction(tr("Delete"));
        if(menu->exec(view->mapToGlobal(pos)) == deleteAction){
            QModelIndex index = view->indexAt(pos);
            emit deleteIndex(index.row());
            view->setRowHidden(index.row(), true);
        }

        view->clearSelection();

    }

signals:
    void selectedIndex(int);
    void selectedString(QString);
    void deleteIndex(int);
};

#endif
