#ifndef COLORSELECTOR_H
#define COLORSELECTOR_H

#include <QMaemo5AbstractPickSelector>
#include "colorselectordialog.h"

//ColorSelector is a Maemo 5 pick selector. 
//It is initialized with a QList of QColor values and uses ColorSelectorDialog as
//the actual color selecting widget.
class ColorSelector : public QMaemo5AbstractPickSelector{
    Q_OBJECT
public:
    ColorSelector(QList<QColor> c, QObject *parent = 0) : QMaemo5AbstractPickSelector(parent), current(0){
        colors = c;
        //The first color in the list is set as default.
        emit selected(colors[0].name());
    }

    QString currentValueText() const{
        return colors[current].name(); 
    }

    QWidget* widget(QWidget *parent){
        ColorSelectorDialog *dialog = new ColorSelectorDialog(colors, parent);
        connect(dialog, SIGNAL(selected(int)), this, SLOT(colorSelected(int)));
        return dialog;
        
    }

    void setColors(QList<QColor> c){
        colors = c;
    }

private:
    QList<QColor> colors;
    int current;

public slots:
    void colorSelected(int id){
        if(id >= 0 && id < colors.count()){
            emit selected(colors[id].name());
            current = id;
        }
    }

};

#endif
