#ifndef ADDANNOTATIONDIALOG_H
#define ADDANNOTATIONDIALOG_H

#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QDialogButtonBox>
#include <QTextBrowser>
#include <QScrollArea>
#include <QTextEdit>

#include "colorselector.h"
#include "textselectionwidget.h"
#include "colorvaluebutton.h"

class AddAnnotationDialog : public QDialog{
public:
    AddAnnotationDialog(QWidget *parent = 0) : QDialog(parent){
        setWindowTitle(tr("Add annotation"));
        QScrollArea *scrollArea = new QScrollArea();
        QAbstractKineticScroller *scroller = scrollArea->property("kineticScroller").value<QAbstractKineticScroller*>();
        containerWidget = new QWidget();

        QHBoxLayout *mainLayout = new QHBoxLayout();
        QVBoxLayout *layout = new QVBoxLayout();
        containerWidget->setLayout(layout);
        
        paragraphLabel = new TextSelectionWidget(scroller);
        layout->addWidget(paragraphLabel);

        annotationEdit = new QTextEdit;
        annotationEdit->setFixedHeight(210);
        layout->addWidget(annotationEdit);
        annotationEdit->grabKeyboard();        

        //TODO: Make palette application wide
        QList<QColor> colors;
        colors.push_back(QColor("#fce94f"));
        colors.push_back(QColor("#edd400"));
        colors.push_back(QColor("#c4a000"));

        colors.push_back(QColor("#fcaf3e"));
        colors.push_back(QColor("#f57900"));
        colors.push_back(QColor("#ce5c00"));

        colors.push_back(QColor("#e9b96e"));
        colors.push_back(QColor("#c17d11"));
        colors.push_back(QColor("#ce5c00"));

        colors.push_back(QColor("#8ae234"));
        colors.push_back(QColor("#73d216"));
        colors.push_back(QColor("#4e9a06"));

        colors.push_back(QColor("#729fcf"));
        colors.push_back(QColor("#3465a4"));
        colors.push_back(QColor("#204a87"));

        colors.push_back(QColor("#ad7fa8"));
        colors.push_back(QColor("#75507b"));
        colors.push_back(QColor("#5c3566"));

        colors.push_back(QColor("#ef2929"));
        colors.push_back(QColor("#cc0000"));
        colors.push_back(QColor("#a40000"));

        colors.push_back(QColor("#eeeeec"));
        colors.push_back(QColor("#d3d7cf"));
        colors.push_back(QColor("#babdb6"));

        colors.push_back(QColor("#888a85"));
        colors.push_back(QColor("#555753"));
        colors.push_back(QColor("#2e3436"));

        ColorValueButton *colorButton = new ColorValueButton();
        colorSelector = new ColorSelector(colors);
        colorButton->setPickSelector(colorSelector);
        layout->addWidget(colorButton);

        mainLayout->addWidget(scrollArea);
        mainLayout->setStretchFactor(scrollArea, 2);

        QDialogButtonBox *buttonBox = new QDialogButtonBox(QDialogButtonBox::Save);
        connect(buttonBox, SIGNAL(accepted()), this, SLOT(accept()));

        QVBoxLayout *subLayout = new QVBoxLayout();
        subLayout->setSizeConstraint(QLayout::SetMinimumSize);
        mainLayout->addLayout(subLayout);

        subLayout->addWidget(buttonBox);
        subLayout->setAlignment(buttonBox, Qt::AlignBottom);

        paragraphLabel->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Minimum);
        scrollArea->setWidgetResizable(true);
        scrollArea->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);

        scrollArea->setWidget(containerWidget);
        setLayout(mainLayout);
        

        
    }

    QString getAnnotation()
    {
        return annotationEdit->toPlainText();
    }

    void setParagraph(const QString &paragraph)
    {
        paragraphLabel->setText(paragraph); 
        containerWidget->adjustSize();
    }

    QString getSelectedText()
    {
        return paragraphLabel->getText(); 
    }

    QColor getColor()
    {
        return colorSelector->currentValueText();
    }

private:
    QTextEdit *annotationEdit;
    TextSelectionWidget *paragraphLabel;
    ColorSelector *colorSelector;
    QWidget *containerWidget;
};

#endif
