#ifndef TEXTSELECTIONWIDGET_H
#define TEXTSELECTIONWIDGET_H

#include <QWidget>
#include <QTextLayout>
#include <QPainter>
#include <QAbstractKineticScroller>

//TextSelectionWidget is a widget used in AddAnnotationDialog to select text which the annotation is connected to.
//This is necessary because Maemo 5 doesn't normally have this kind of widget available and in the Maemo 5 version of Qt textselections have been turned off in text widgets.
//
//TextSelectionWidget is given text which it draws with QTextLayout and provides two "handles" which
//the user can use to mark the selected text.
class TextSelectionWidget : public QWidget{
    Q_OBJECT
public:
    TextSelectionWidget(QAbstractKineticScroller *s = 0, QWidget *parent = 0);
    void setText(const QString&);
    QString getText();

protected:
    void paintEvent(QPaintEvent*);
    QSize sizeHint() const;
    void mousePressEvent(QMouseEvent*);
    void mouseMoveEvent(QMouseEvent*);
    void mouseReleaseEvent(QMouseEvent*);
    
private:
    QTextLayout *textLayout;
    int margin;
    int lineHeight;

    //QAbstractKineticScroller is used if the TextSelectionWidget is in a scrollable container.
    //This way we can prevent the view from scrolling when we move handlers.
    QAbstractKineticScroller *scroller;
    QPoint scrollPosition;
    qreal panningThreshold;

    QPoint startPoint;
    QPoint endPoint;
    int startPosition;
    int endPosition;

    bool movingStartHandle;
    bool movingEndHandle;
    QPoint startHandlePoint;
    QPoint endHandlePoint;
    QRect startHandleRect;
    QRect endHandleRect;
};

#endif
