#ifndef STARTWINDOW_H
#define STARTWINDOW_H

#include <QMainWindow>
#include <QResizeEvent>
#include <QSettings>

#include "libosso.h"

#include "library.h"
#include "mainwindow.h"
#include "settingsdialog.h"
#include "searchcatalogsview.h"

//StartWindow is the mainwindow visible when the application first starts.
//It contains menu for settings, button for opening files, buttons for accessing catalogs and
//a list of books in library.
class StartWindow : public QMainWindow
{
    Q_OBJECT
public:
    StartWindow(QWidget *parent = 0);
    ~StartWindow();

private:
    QScrollArea *scrollArea;
    QWidget *bookList;
    QVBoxLayout *listLayout;
    QAbstractKineticScroller *scroller;

    MainWindow *readingUI;
    SearchCatalogsView *searcCatalogsView;
    QListWidget *libraryList;
    QSettings *settings;

    void readSettings();
    Library *library;
    osso_context_t *osso_context;

    FeedBooks *feedBooksCatalog;

    QList<BookListItem*> bookListItems;


public slots:
    void openFile();
    void openBook(Book*);
    void openSettingsDialog();
    void openAboutDialog();

    void searchCatalogs();
    void searchCatalogsClosed();
    
    void bookViewClosed();

    void showMessage(const QString);

    void addBook(Book *book);
    void removeBook(Book *book);

    void reportBugs();

};

#endif
