#include "settingsdialog.h"

#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QPushButton>
#include <QFontDatabase>
#include <QDialogButtonBox>
#include <QScrollArea>

SettingsDialog::SettingsDialog(QWidget *parent) : QDialog(parent)
{
    setWindowTitle(tr("Settings"));
    QHBoxLayout *mainLayout = new QHBoxLayout(this); 
    setLayout(mainLayout);

    QVBoxLayout *subLayout = new QVBoxLayout();

    //mainLayout->addLayout(subLayout);
    QScrollArea *scrollArea = new QScrollArea();
    containerWidget = new QWidget();

    mainLayout->addWidget(scrollArea);
    mainLayout->setStretchFactor(scrollArea, 2);
    scrollArea->setWidget(containerWidget);
    scrollArea->setWidgetResizable(true);
    containerWidget->setLayout(subLayout);
    subLayout->setMargin(0);
    scrollArea->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);

    
    QDialogButtonBox *buttonBox = new QDialogButtonBox(QDialogButtonBox::Save);
    connect(buttonBox, SIGNAL(accepted()), this, SLOT(accept()));

    QVBoxLayout *subLayout2 = new QVBoxLayout();
    subLayout2->addWidget(buttonBox);
    mainLayout->addLayout(subLayout2);
    subLayout2->setAlignment(buttonBox, Qt::AlignBottom);

    QHBoxLayout *viewModeLayout = new QHBoxLayout();
    scrollRadioButton = new QRadioButton(tr("Scroll"), this);
    pagesRadioButton = new QRadioButton(tr("Pages"), this);
    viewModeLayout->setSpacing(0);

    QLabel *viewModeLabel = new QLabel(tr("Viewmode:"));
    subLayout->addWidget(viewModeLabel);

    subLayout->addLayout(viewModeLayout);
    viewModeLayout->addWidget(scrollRadioButton);
    viewModeLayout->addWidget(pagesRadioButton);

    QHBoxLayout *orientationLayout = new QHBoxLayout();
    portraitRadioButton = new QRadioButton(tr("Portrait"), this);
    landscapeRadioButton = new QRadioButton(tr("Landscape"), this);
    orientationLayout->setSpacing(0);

    QLabel *orientationLabel = new QLabel(tr("Orientation:"));
    subLayout->addWidget(orientationLabel);

    subLayout->addLayout(orientationLayout);

    orientationLayout->addWidget(portraitRadioButton);
    orientationLayout->addWidget(landscapeRadioButton);

    orientationButtonGroup = new QButtonGroup();
    orientationButtonGroup->addButton(portraitRadioButton);
    orientationButtonGroup->addButton(landscapeRadioButton);

    QHBoxLayout *colorsLayout = new QHBoxLayout();

    QLabel *colorModeLabel = new QLabel(tr("Colormode:"));
    subLayout->addWidget(colorModeLabel);

    normalRadioButton = new QRadioButton(tr("Normal"), this);
    invertedRadioButton = new QRadioButton(tr("Inverted"), this);
    colorsLayout->setSpacing(0);
    subLayout->addLayout(colorsLayout);

    colorsLayout->addWidget(normalRadioButton);
    colorsLayout->addWidget(invertedRadioButton);

    QButtonGroup *colorsButtonGroup = new QButtonGroup();
    colorsButtonGroup->addButton(normalRadioButton);
    colorsButtonGroup->addButton(invertedRadioButton);


    model = new QStandardItemModel(0, 1);
    QFontDatabase fontDB;
    QStringList families = fontDB.families(); 

    QStringList::iterator iter;
    for(iter = families.begin(); iter != families.end(); ++iter){
        QStandardItem *item = new QStandardItem(*iter);
        item->setTextAlignment(Qt::AlignCenter);
        item->setEditable(false);
        model->appendRow(item);

        QList<int> sizes = fontDB.smoothSizes(*iter, "Normal");
        if(sizes.count() > 0){
            QStandardItemModel *smodel = new QStandardItemModel(0, 1);
            for(QList<int>::iterator siter = sizes.begin(); siter != sizes.end(); ++siter)
            {
                QStandardItem *sitem = new QStandardItem(QString::number(*siter));
                smodel->appendRow(sitem);
            }
            fontSizes.insert(*iter, smodel);
        } else {
            families.erase(iter);
        }
    }

    QMaemo5ValueButton *fontButton = new QMaemo5ValueButton(tr("Font"));
    fontButton->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    fontSelector = new QMaemo5ListPickSelector;
    
    QList<QStandardItem*> sansList = model->findItems("Sans Serif");
    int defaultRow = 0;
    if(!sansList.isEmpty())
        defaultRow = sansList[0]->row();

    fontSelector->setModel(model);
    fontSelector->setCurrentIndex(defaultRow);
    fontButton->setPickSelector(fontSelector);
    connect(fontSelector, SIGNAL(selected(const QString&)), this, SLOT(fontChanged(const QString&)));
    subLayout->addWidget(fontButton);

    QMaemo5ValueButton *fontSizeButton = new QMaemo5ValueButton(tr("Font size"));
    fontSizeButton->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    fontSizeSelector = new QMaemo5ListPickSelector;
    fontSizeButton->setPickSelector(fontSizeSelector);
    fontSizeSelector->setModel(fontSizes[model->item(defaultRow)->text()]);
    fontSizeSelector->setCurrentIndex(0);
    subLayout->addWidget(fontSizeButton);

    backlightButton = new QCheckBox(tr("Keep backlight on"));
    subLayout->addWidget(backlightButton);
    backlightButton->setCheckable(true);
    backlightButton->setChecked(true);


}

int SettingsDialog::getOrientation()
{
    if(portraitRadioButton->isChecked())return Qt::WA_Maemo5PortraitOrientation;
    else return Qt::WA_Maemo5LandscapeOrientation;
}

void SettingsDialog::setOrientation(int orientation)
{
    if(orientation == Qt::WA_Maemo5PortraitOrientation){
        portraitRadioButton->setChecked(true);
        containerWidget->setMaximumWidth(250);
    }else {
        landscapeRadioButton->setChecked(true);
    }
}

int SettingsDialog::getColors()
{
    if(normalRadioButton->isChecked()) return 1;
    else return 0;
}

void SettingsDialog::setColors(int colors)
{
    if(colors == 1)normalRadioButton->setChecked(true);
    else invertedRadioButton->setChecked(true);
}

void SettingsDialog::fontChanged(const QString &newfont)
{
    if(!newfont.isEmpty()){
        fontSizeSelector->setModel(fontSizes[newfont]);  
    }
}

void SettingsDialog::setFontFamily(const QString &family)
{
    if(!family.isEmpty()){
        QList<QStandardItem*> list = model->findItems(family);
        if(!list.isEmpty())
            fontSelector->setCurrentIndex(list.first()->row());
        else
            fontSelector->setCurrentIndex(0);
    }
}

QString SettingsDialog::getFontFamily()
{
    if(fontSelector->currentValueText().isEmpty())
        return "Sans Serif";
    return fontSelector->currentValueText();
}

void SettingsDialog::setFontSize(int size)
{
    QStandardItemModel *tmodel = fontSizes[fontSelector->currentValueText()];
    if(tmodel){
        QList<QStandardItem*> list = tmodel->findItems(QString::number(size));
        if(!list.isEmpty())
            fontSizeSelector->setCurrentIndex(list.first()->row());
        else
            fontSizeSelector->setCurrentIndex(0);
    }
}

int SettingsDialog::getFontSize()
{
    QString temp = fontSizeSelector->currentValueText();
    if(temp.toInt() == 0)
        return 20;
    return temp.toInt();
}

void SettingsDialog::setBacklightForce(bool toggle)
{
    backlightButton->setChecked(toggle);
}

bool SettingsDialog::getBacklighForce()
{
    return backlightButton->isChecked();
}

void SettingsDialog::setViewMode(BookViewMode mode)
{
    if(mode == ScrollingMode)
        scrollRadioButton->setChecked(true);
    else
        pagesRadioButton->setChecked(true);
}

BookViewMode SettingsDialog::getViewMode()
{
    if(scrollRadioButton->isChecked())
        return ScrollingMode;
    else
        return PageMode;
}
