#ifndef LISTVIEWDIALOG_H
#define LISTVIEWDIALOG_H

#include <QListView>
#include <QHBoxLayout>
#include <QDebug>
#include "listmodel.h"
#include "listitemdelegate.h"

class ListViewDialog : public QWidget{
    Q_OBJECT
public:
    ListViewDialog(QWidget *parent = 0) : QWidget(parent){
        view = new QListView(this);
        ListItemDelegate *delegate = new ListItemDelegate(this);
        view->setItemDelegate(delegate);
        QHBoxLayout *layout = new QHBoxLayout(); 
        layout->setSpacing(0);
        layout->setMargin(0);
        layout->addWidget(view);
        setLayout(layout);
        connect(view, SIGNAL(activated(const QModelIndex&)), this, SLOT(itemSelected(const QModelIndex&)));
    }

    void setModel(QAbstractItemModel *model){
        view->setModel(model);
    }

private:
    QListView *view;

public slots:
    void itemSelected(const QModelIndex &index){
        emit selectedIndex(index.row());
        emit selectedString(index.data(Qt::DisplayRole).toString());
        close();
    }

signals:
    void selectedIndex(int);
    void selectedString(QString);
};

#endif
