/*
  sudokutable.h
  Project: masudoku
  Platform: Fremantle (maemo5)
  Author: Petri Kultanen pete@petnetti.net
  Last Edit: 3.6.2010
*/
#ifndef SUDOKUTABLE_H
#define SUDOKUTABLE_H

#include <QObject>
#include <QPoint> //Needed in this header file
//Forward class declarations
class QString;

/*
  CSudokuTable Handle Sudoku game table
  */
class CSudokuTable : public QObject
{
public:
    Q_OBJECT
signals:
    void error(QString aErrior);

public:
    CSudokuTable();
    ~CSudokuTable();
    bool isEmptyL(int aCol, int aRow);
    bool isTableEmpty();
    bool isTableFull();
    bool isErrorInTableL();
    bool isNumInAnyDirectionL(int aNnum, int aCol, int aRow);
    bool isTableSolvableL();

    int missingNumbers();
    int getNumL(int aCol, int aRow);
    void setNumL(int aNum,int aCol,int aRow);
    void clearTable();

    bool fillOneNumberL();
    bool fillWholeTableL();// find correct numbers to table, go thorough whole table as many times as possible

    void removeNumbers(int aAmount);
    void removeAllNumbersL();
    void generateFullTableL();
    void newGame(int aAmount);
    void loadFromFileL(bool aAuto);
    void saveToFileL(bool aAuto);
    QPoint lastPlace(){return iLastPlace;}
    bool isMemoryNumber(int aNum, int aCol,int aRow);
    bool setMemoryNumber(int aNum, int aCol,int aRow);
    bool removeMemoryNumber(int aNum, int aCol,int aRow);
    void removeMemoryNumbers(int aCol, int aRow);
	//For save game
	qint32 getMemoryDataNum(int aCol,int aRow);
	void setMemoryDataNum(qint32 aNum, int aCol, int aRow);
	
private:
    void copySudokuTableL(CSudokuTable* aTable);
    bool fillRowL();// find correct numbers to table, go thorough all Rows once
    bool fillColL();// find correct numbers to table, go thorough all columns once
    bool fillAllL();// find correct numbers to table, go thorough all 81 places once

    int getCellL(int aCol, int aRow);
    void clearRow(int aRow);
    bool tryNumberToColL(int aNum, int aCol);
    bool tryNumberToRowL(int aNum, int aRow);

    bool isNumInRowL(int aNum, int aRow);
    bool isNumInColL(int aNnum, int aCol);
    bool isNumInCellL(int aNum, int aCol, int aRow);

    int random();

private:
    int table[9][9];
    qint32 memoryTable[9][9];
    QPoint iLastPlace;
};

#endif // SUDOKUTABLE_H
