/*
  mainwindow.h
  Project: masudoku
  Platform: Fremantle (maemo5)
  Author: Petri Kultanen pete@petnetti.net
  Last Edit: 3.6.2010
*/
#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui/QMainWindow>


class CSudokuTable;
class SudokuTableWidget;
class SudokuSelectNumberWidget;
class QWidget;
class QPushButton;
class QLabel;
class QRadioButton;
class SudokuSettings;
class MainWindow : public QMainWindow
{
    Q_OBJECT

    public slots:
    void changeNumber(int aX,int aY);
    //void numberChanged(int aNum);
    void showError(QString aString);
    void newGame();
    void solveOne();
    void solveTable();
    void applySettingsChange();
    void repaintElements();
    void toggleNumberTypes();
    void checkTable();
    void aboutt();
    void showSettingsDialog();
	void updateBackground();
public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();

private:

    CSudokuTable *iTable;
    SudokuTableWidget *iTableWidget;
    SudokuSelectNumberWidget *iSelectNumberWidget;
	SudokuSettings* iSettings;
    QWidget *iMainWidget;
    QPushButton *iNewGameButton;
    QPushButton *iSolveOneButton;
    QPushButton *iSolveAllButton;
    QPushButton *iChangeSettingsButton;
    QLabel *iSolvableText;
    QRadioButton *iNormalNumberRadioButton;
    QRadioButton *iMarkupNumberRadioButton;

    bool iCriticalError;

};

#endif // MAINWINDOW_H
