/*
  Load applet - Maemo5 edition

*/

#include <gtk/gtk.h>
#include <hildon/hildon.h>
#include <glib/gerror.h>
#include <glib.h>
#include <glib/gstdio.h>
#include <string.h>
#include <osso-log.h>
#include <unistd.h>
#include <stdlib.h>

#include "item.h"

#define LOAD_APPLET_STATUS_MENU_ITEM_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE (obj, LOAD_APPLET_TYPE_STATUS_MENU_ITEM, LoadAppletStatusMenuItemPrivate))

struct _LoadAppletStatusMenuItemPrivate {
	GtkWidget *button;
	GtkWidget *icon;
	GdkPixbuf *pixbuf_current;
	GdkPixbuf *pixbuf_full;
	GdkPixbuf *pixbuf_empty;
	GdkPixbuf *pixbuf_save;
	gulong handler;
	guint timeout_id;
	gint lastU, lastN, lastIO, lastI;
	guchar last_mem_level;
	guchar last_cpu_level;
};

HD_DEFINE_PLUGIN_MODULE (LoadAppletStatusMenuItem, load_applet_status_menu_item, HD_TYPE_STATUS_MENU_ITEM)



#define SHUTTER_SOUND "/usr/share/sounds/la_shutter_sound.wav"
#define BEEP_SOUND    "/usr/share/sounds/ui-default_beep.wav" 
#define MAX_SSHOT_NAME_LEN 64
#define SSHOT_DEFAULT_NAME "screenshot"
static gchar *sshotfilename = NULL;
static char sshotname[MAX_SSHOT_NAME_LEN];
static guint screenshot_delay = 7;
static guint beeps = 0;
static gint sshotn = 0;




static void
load_applet_status_menu_item_class_finalize(LoadAppletStatusMenuItemClass * klass)
{
}

static void
load_applet_status_menu_item_dispose(GObject * object)
{
	G_OBJECT_CLASS(load_applet_status_menu_item_parent_class)->dispose(object);
}

static void
load_applet_status_menu_item_class_init(LoadAppletStatusMenuItemClass * klass)
{
	GObjectClass *object_class = G_OBJECT_CLASS(klass);

	object_class->dispose = load_applet_status_menu_item_dispose;

	g_type_class_add_private(klass, sizeof(LoadAppletStatusMenuItemPrivate));
}

/*
 * Get the filename for next screen-shot. Start with nr.
 * 
 */
static int
get_next_sshot(gint nr, const gchar *suffix)
{
	FILE *f;
	gint n;

	n = nr;
	f = NULL;
	do {
		g_snprintf (sshotname, MAX_SSHOT_NAME_LEN-1, "%s/MyDocs/.images/%s%02d.%s", getenv("HOME"), sshotfilename, n, suffix);
		f = g_fopen(sshotname, "r");
		if (f) {
			fclose(f); 
			n++;
		}
	}
	while(f != NULL);
		
	return n;
}



/*
 * Close the menu, make sure it is cosed and redrawn
 */
static void
do_little_dance (void)
{
	//TODO - hide the menu!!!
	
	while (gtk_events_pending())
	{
		gtk_main_iteration();
	}

	usleep(1000);

	sched_yield();
}


/*
 *  Take screeshot using the root window drawable
 */
static gboolean
take_screenshot(void)
{
	int width, height;
	GdkDrawable *root_window;
	GdkPixbuf *pixbuf;
	gboolean ret;
	GError *error = NULL;
	
	do_little_dance();
	sshotn = get_next_sshot(sshotn, "png");


	root_window = gdk_get_default_root_window();
	gdk_drawable_get_size(root_window, &width, &height);
	pixbuf = gdk_pixbuf_get_from_drawable(NULL,
                                           root_window,
                                           gdk_drawable_get_colormap (root_window),
                                           0, 0,
                                           0, 0,
                                           width, height);
      

	ret = gdk_pixbuf_save(pixbuf, sshotname, "png", &error, NULL);
	g_object_unref(pixbuf);

	//DEBUG
	printf("\tSaving %s\n", sshotname);

	return FALSE;
}


/*
 * Either beep or play shutter sound and make the screenshot
 */
static gboolean
beep_or_shoot(gpointer data)
{
	beeps++;
	if (beeps >= screenshot_delay) {
		hildon_play_system_sound(SHUTTER_SOUND);
		take_screenshot();
		return FALSE; 
	} else {
		//TODO - eventually uncomment this
		//For some reason the beeping does not work on device :(
		//hildon_play_system_sound(BEEP_SOUND);
		return TRUE;  
	}
}

/*
 * Answer the callback by setting delayed screenshot
 */
static void
activate_delayed_screenshot_item(GtkMenuItem *item, gpointer data)
{
	beeps = 0;
	gtk_timeout_add(1000, beep_or_shoot, NULL);
}




/*
 * utility function to load icon into pixbuf 
 */
static GdkPixbuf*
la_load_pixmap(const gchar* location)
{
	GdkPixbuf *pixbuf;
	GError *error = NULL;

	pixbuf = gdk_pixbuf_new_from_file(location, &error); 
	if (error) {
		g_error("Loading %s failed with : %s", location, error->message);
		g_error_free (error);
	}
	return pixbuf;
}



/*
 * Load icons into pixbufs
 */
static void
la_load_pixmaps(LoadAppletStatusMenuItemPrivate *priv)
{
	#define ICON_DIR   "/usr/share/pixmaps/"
	#define ICON_EMPTY ICON_DIR"la_empty.png"
	#define ICON_FULL  ICON_DIR"la_full.png"
	#define ICON_SAVE  ICON_DIR"la_save.png"
	#define ICON_ICON  ICON_DIR"la_icon.png"

	priv->pixbuf_current = la_load_pixmap(ICON_ICON);  //major Major Major
	priv->pixbuf_empty   = la_load_pixmap(ICON_EMPTY);
	priv->pixbuf_full    = la_load_pixmap(ICON_FULL);
	priv->pixbuf_save    = la_load_pixmap(ICON_SAVE);
}



/*
 * Read current MEM usage and return indicator between 5 and 1 - how many bars are "full"
 */
static guchar
la_check_mem (LoadAppletStatusMenuItemPrivate *priv)
{
	#define MEMFILE "/proc/meminfo"
	#define MAX_READ_CHARS 128
	char read_buffer[MAX_READ_CHARS];
	FILE *fin;
	int mem_used = 0;
	int mem_total = 0;
	int mem_cached = 0;
	int mem_buffers = 0;
	int mem_free = 0;

	//Open the memory info file and get current free memory
	fin = fopen(MEMFILE, "r");
	if (fin == NULL) {
		g_warning("Can't open "MEMFILE"\n");
		return TRUE;
	}
	while (fgets(read_buffer, MAX_READ_CHARS, fin) != NULL) {
		if (strncmp(read_buffer, "MemTotal", 8) == 0) {
			sscanf(read_buffer + 10, "%d", &mem_total);
		} else if (strncmp(read_buffer, "MemFree", 6) == 0) {
			sscanf(read_buffer + 9, "%d", &mem_free);
		} else if (strncmp(read_buffer, "Buffers", 6) == 0) {
			sscanf(read_buffer + 9, "%d", &mem_buffers);
		} else if (strncmp(read_buffer, "Cached", 6) == 0) {
			sscanf(read_buffer + 8, "%d", &mem_cached);
			break;
		}
	}
	fclose(fin);
	mem_used = mem_total - mem_free - mem_buffers - mem_cached;

	//very scientific - whatever looks good
	if (mem_used > 0.9*mem_total)
		return 5;
	else if (mem_used > 0.7*mem_total)
		return 4;
	else if (mem_used > 0.5*mem_total)
		return 3;
	else if (mem_used > 0.4*mem_total)
		return 2;
	else
		return 1;
}

/*
 * Read current CPU usage and return indicator between 5 and 1 - how many bars are "full"
 */
static guchar
la_check_cpu (LoadAppletStatusMenuItemPrivate *priv)
{
	#define CPUFILE "/proc/stat"
	gint curU, curN, curIO, curI;
	gint deltaU, deltaN, deltaIO, deltaI;
	int load, idle;
	GError *error = NULL;
	gchar *contents;
	gsize lenght;
	gchar **splits;

	if (!g_file_get_contents (CPUFILE, &contents, &lenght, &error)) {
		fprintf (stderr, "ERR: can't read file %s: %s\n", CPUFILE, error->message);
		g_error_free (error);
		return 0;
	}
	
	splits = g_strsplit_set (contents, " ",  -1);

	sscanf(splits[2], "%d", &curU);
	sscanf(splits[3], "%d", &curN);
	sscanf(splits[4], "%d", &curIO);
	sscanf(splits[5], "%d", &curI);
	
	g_strfreev (splits);
	g_free (contents);
    
	idle = (curI - priv->lastI);
	if (idle == 0) load = 100;
	else load = 100-idle;
	if (load>100) load = 0;
	deltaU = curU - priv->lastU;
	deltaN = curN - priv->lastN;
	deltaIO = curIO - priv->lastIO;
	deltaI = curI - priv->lastI;
	priv->lastU = curU;
	priv->lastN = curN;
	priv->lastIO = curIO;
	priv->lastI = curI;

	if (load > 90)
		return 5;
	else if (load > 75)
		return 4;
	else if (load > 50)
		return 3;
	else if (load > 25)
		return 2;
	else
		return 1;
}


/*
 * Compose and blit the current status of memory bars
 */
static void
la_blit_memory_bars (const guchar level, LoadAppletStatusMenuItemPrivate *priv)
{
	guint x, y;

	x = 0;
	y = 6;
	if (level > 0)
		gdk_pixbuf_composite(priv->pixbuf_full, priv->pixbuf_current, x, y, 12, 38, x, y, 1, 1, GDK_INTERP_NEAREST, 255);
	else
		gdk_pixbuf_composite(priv->pixbuf_empty, priv->pixbuf_current, x, y, 12, 38, x, y, 1, 1, GDK_INTERP_NEAREST, 255);
	x = 14;
	if (level > 1)
		gdk_pixbuf_composite(priv->pixbuf_full, priv->pixbuf_current, x, y, 12, 38, x, y, 1, 1, GDK_INTERP_NEAREST, 255);
	else
		gdk_pixbuf_composite(priv->pixbuf_empty, priv->pixbuf_current, x, y, 12, 38, x, y, 1, 1, GDK_INTERP_NEAREST, 255);
	x = 28;
	if (level > 2)
		gdk_pixbuf_composite(priv->pixbuf_full, priv->pixbuf_current, x, y, 12, 38, x, y, 1, 1, GDK_INTERP_NEAREST, 255);
	else
		gdk_pixbuf_composite(priv->pixbuf_empty, priv->pixbuf_current, x, y, 12, 38, x, y, 1, 1, GDK_INTERP_NEAREST, 255);
	x = 42;
	if (level > 3)
		gdk_pixbuf_composite(priv->pixbuf_full, priv->pixbuf_current, x, y, 12, 38, x, y, 1, 1, GDK_INTERP_NEAREST, 255);
	else
		gdk_pixbuf_composite(priv->pixbuf_empty, priv->pixbuf_current, x, y, 12, 38, x, y, 1, 1, GDK_INTERP_NEAREST, 255);
	x = 56;
	if (level > 4)
		gdk_pixbuf_composite(priv->pixbuf_full, priv->pixbuf_current, x, y, 12, 38, x, y, 1, 1, GDK_INTERP_NEAREST, 255);
	else
		gdk_pixbuf_composite(priv->pixbuf_empty, priv->pixbuf_current, x, y, 12, 38, x, y, 1, 1, GDK_INTERP_NEAREST, 255);
}


/* 
 * Compose and blit current status of CPU bars
 */
static void
la_blit_cpu_bars (const guchar level, LoadAppletStatusMenuItemPrivate *priv)
{
	guint x, y;

	x = 266;
	y = 6;
	if (level > 0)
		gdk_pixbuf_composite(priv->pixbuf_full,  priv->pixbuf_current, x, y, 12, 38, x, y, 1, 1, GDK_INTERP_NEAREST, 255);
	else
		gdk_pixbuf_composite(priv->pixbuf_empty, priv->pixbuf_current, x, y, 12, 38, x, y, 1, 1, GDK_INTERP_NEAREST, 255);
	x = 252;
	if (level > 1)
		gdk_pixbuf_composite(priv->pixbuf_full,  priv->pixbuf_current, x, y, 12, 38, x, y, 1, 1, GDK_INTERP_NEAREST, 255);
	else
		gdk_pixbuf_composite(priv->pixbuf_empty, priv->pixbuf_current, x, y, 12, 38, x, y, 1, 1, GDK_INTERP_NEAREST, 255);
	x = 238;
	if (level > 2)
		gdk_pixbuf_composite(priv->pixbuf_full,  priv->pixbuf_current, x, y, 12, 38, x, y, 1, 1, GDK_INTERP_NEAREST, 255);
	else
		gdk_pixbuf_composite(priv->pixbuf_empty, priv->pixbuf_current, x, y, 12, 38, x, y, 1, 1, GDK_INTERP_NEAREST, 255);
	x = 224;
	if (level > 3)
		gdk_pixbuf_composite(priv->pixbuf_full,  priv->pixbuf_current, x, y, 12, 38, x, y, 1, 1, GDK_INTERP_NEAREST, 255);
	else
		gdk_pixbuf_composite(priv->pixbuf_empty, priv->pixbuf_current, x, y, 12, 38, x, y, 1, 1, GDK_INTERP_NEAREST, 255);
	x = 210;
	if (level > 4)
		gdk_pixbuf_composite(priv->pixbuf_full,  priv->pixbuf_current, x, y, 12, 38, x, y, 1, 1, GDK_INTERP_NEAREST, 255);
	else
		gdk_pixbuf_composite(priv->pixbuf_empty, priv->pixbuf_current, x, y, 12, 38, x, y, 1, 1, GDK_INTERP_NEAREST, 255);
}


/*
 * Ran to check and update the CPU and memory reading
 */
static gboolean
la_check_load (gpointer data)
{
	guchar current_cpu_level;
	guchar current_mem_level;
	LoadAppletStatusMenuItemPrivate *priv = (LoadAppletStatusMenuItemPrivate*)data;
   
	current_cpu_level = la_check_cpu(priv); 
	current_mem_level = la_check_mem(priv);

	//Update and blit only if data changed!
	if ((current_mem_level != priv->last_mem_level) || (current_cpu_level != priv->last_cpu_level)) {
		//gdk_pixbuf_fill(priv->pixbuf_current, 0x00000000); //Why?
		la_blit_memory_bars (current_mem_level, priv);
		la_blit_cpu_bars (current_cpu_level, priv);
		gtk_image_set_from_pixbuf(GTK_IMAGE(priv->icon), priv->pixbuf_current);
		priv->last_mem_level = current_mem_level;
		priv->last_cpu_level = current_cpu_level;
	}

	return TRUE;  
}



static void
load_applet_status_menu_item_init (LoadAppletStatusMenuItem * menu_item)
{
	GtkWidget *hbox;

	menu_item->priv = LOAD_APPLET_STATUS_MENU_ITEM_GET_PRIVATE (menu_item);

	hbox = gtk_hbox_new(FALSE, 0);
	
	menu_item->priv->button = gtk_button_new();
	gtk_widget_show(menu_item->priv->button);
	gtk_box_pack_start(GTK_BOX(hbox), menu_item->priv->button, TRUE, TRUE, HILDON_MARGIN_DEFAULT);
	menu_item->priv->handler = g_signal_connect(menu_item->priv->button, "clicked", G_CALLBACK(activate_delayed_screenshot_item), menu_item);
	menu_item->priv->icon = gtk_image_new_from_pixbuf(NULL);
	gtk_widget_show(menu_item->priv->icon);
	gtk_container_add(GTK_CONTAINER(menu_item->priv->button), GTK_WIDGET(menu_item->priv->icon));
	gtk_widget_show(hbox);
	
	// Pack widgets to menu
	gtk_container_add(GTK_CONTAINER(menu_item), hbox);
	gtk_widget_show(GTK_WIDGET(menu_item));
	
	// More init
	sshotfilename = g_strdup(SSHOT_DEFAULT_NAME);
	la_load_pixmaps(menu_item->priv);
	menu_item->priv->last_mem_level = 0;
	menu_item->priv->last_cpu_level = 0;

	//TODO - do not run this in loop all time! Run in loop only when menu is open!!!!
	menu_item->priv->timeout_id = gtk_timeout_add(1000, la_check_load, menu_item->priv);
}



