#ifndef _MAINWINDOW_H
#define _MAINWINDOW_H

#include <QWidget>

class QVBoxLayout;
class QStackedWidget;
class QFrame;

class NetInterfaces;
class Launcher;
class Passwd;
class EditInterface;
class UsbManage;
class ProcessRunner;

class MainWindow : public QWidget
{
     Q_OBJECT

public:
     MainWindow(QObject *parent=0);

public slots:
	void showEdit(void);
	void showPasswd(void);
	void showLauncher(void);
	void showUsbManage(void);
	void activateLauncher(void);

private:
     QVBoxLayout *m_mainlayout;
     QFrame *m_separator; // separator line for top and bottom

     // Allways visible at top of window
     NetInterfaces *m_netinterfaces;

     QStackedWidget *m_stack;

     // One of these is visible at bottom of window.
     enum { LAUNCHER = 0, PASSWD, USB, EDIT };
     Launcher *m_launcher;
     Passwd *m_passwd;
     UsbManage *m_usbmanage;
     EditInterface *m_editinterface;

     // Shared script runner for m_netinterfaces and m_editinterface
     ProcessRunner *m_runner;
};

#endif
