/*
 * Copyright 2010 Felipe Crochik <foss@crochik.com>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef GRAPHICSVIEW_H
#define GRAPHICSVIEW_H

#include <QGraphicsView>

#include <QtGui>
#include <QtWebKit>
#include <QtDebug>

#include "viewportitem.h"

class GraphicsView : public QGraphicsView
{
public:
    GraphicsView(QWidget *pParent);

public:
    ViewportItem *viewportItem() const;

protected:
    void resizeEvent(QResizeEvent *e);

private:
    ViewportItem *viewport;

};

#endif // GRAPHICSVIEW_H
