#include "graphicsviewwindow.h"

GraphicsViewWindow::GraphicsViewWindow(MainWindow *pParent) :
    MainWindow(pParent)
{
    m_pGraphicsView = NULL;
    m_pGWebView = NULL;

    QWebSettings::globalSettings()->setAttribute(QWebSettings::TiledBackingStoreEnabled, true);

#if (QT_VERSION >= QT_VERSION_CHECK(4, 7, 0))
    //QWebSettings::globalSettings()->setAttribute(QWebSettings::FrameFlatteningEnable, true);
#endif

    // using graphics view
    m_pGraphicsView = new GraphicsView(this);
    m_pGWebView = new QGraphicsWebView();

    m_pGWebView->setPalette(QApplication::palette("QWebView"));
    m_webPage.setPalette(QApplication::palette("QWebView"));

#if (QT_VERSION >= QT_VERSION_CHECK(4, 7, 0))
    m_pGWebView->setResizesToContents(true);
#endif

    m_pGWebView->setAttribute(Qt::WA_OpaquePaintEvent, true);
    //m_pGWebView->setInputMethodHints(Qt::ImhNoAutoUppercase | Qt::ImhNoPredictiveText);

    m_pGraphicsView->viewportItem()->setWidget(m_pGWebView);

    connect(m_pGWebView, SIGNAL(loadStarted()), this, SLOT(showLoading()));
    connect(m_pGWebView, SIGNAL(urlChanged(QUrl)), this, SLOT(changeUrl(QUrl)));
    connect(m_pGWebView, SIGNAL(loadFinished(bool)), this, SLOT(hideLoading(bool)));

    m_pGWebView->setPage(&m_webPage);
    setCentralWidget(m_pGraphicsView);

    startUp();
}

void GraphicsViewWindow::updateTitle() {
    QString title = m_currentUrl.isEmpty() || !m_pGWebView ? "Macuco" : m_pGWebView->title();

#ifndef Q_WS_MAEMO_5
    if ( m_webPage.isIphoneUserAgent() ) title += " - iPhone";
    title += QString(" - %1%").arg(QString::number(m_zoomFactor*100, 'f', 0));
#endif

    setWindowTitle(title);
}

void GraphicsViewWindow::visitUrl(QUrl url) {
    Q_ASSERT(m_pGWebView);
    m_pGWebView->load(url);
}

void GraphicsViewWindow::setZoom(qreal zoomFactor) {
    MainWindow::setZoom(zoomFactor);
    Q_ASSERT(m_pGWebView && m_pGraphicsView);

    if ( !m_pGWebView ) return;

    m_pGraphicsView->viewportItem()->setScrollPosition(QPoint(0,0), QPoint(0,0));
    m_pGWebView->setZoomFactor(m_zoomFactor);

#if (QT_VERSION < QT_VERSION_CHECK(4, 7, 0))
    // before resizetocontents
    m_pGraphicsView->viewportItem()->resizeWebViewToFrame();
#endif
}
