<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>
<xsl:param name="MID"/>  
<xsl:param name="SID"/>  
<xsl:param name="SECRET"/>

<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>
<xsl:variable name="NUMBER" select="'number'"/>
<xsl:variable name="STRUCT" select="'struct'"/>
<xsl:variable name="ARRAY" select="'array'"/>

<xsl:include href="errors.xsl"/>
<xsl:include href="attachment.xsl"/>

<xsl:template match="/">
 <xsl:apply-templates select="/data/response"/>
 <xsl:apply-templates select="/data/error"/>
 <xsl:apply-templates select="/data/info"/>
</xsl:template>

<xsl:template match="response">

    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">messages</xsl:attribute>
        <xsl:attribute name="function">getListWallMessages</xsl:attribute>
        <xsl:element name="{$PARAMS}">

            <xsl:attribute name="id">
                <xsl:if test="/data/Request/Params/@id">
                    <xsl:value-of select="/data/Request/Params/@id"/>
                </xsl:if>
                <xsl:if test="not(/data/Request/Params/@id)">
                    <xsl:text>vk</xsl:text>
                    <xsl:value-of select="$MID"/>
                </xsl:if>
            </xsl:attribute>

            <xsl:element name="{$ARRAY}">
                <xsl:variable name="quantity" select="count(messages/item)"/>

                <xsl:attribute name="name">messageList</xsl:attribute>
                <xsl:attribute name="page">
                        <xsl:value-of select="/data/Request/Params/number[@name='page']"/> 
                </xsl:attribute>

                <xsl:attribute name="pageSize">
                        <xsl:value-of select="/data/Request/Params/number[@name='pageSize']"/> 
                </xsl:attribute>

                <xsl:attribute name="quantity">
                    <xsl:if test="number($quantity) > 0">
                        <xsl:value-of select="number($quantity) - 1"/>
                    </xsl:if>
                    <xsl:if test="number($quantity) = 0">
                        <xsl:value-of select="number($quantity)"/>
                    </xsl:if>
                </xsl:attribute>

                <xsl:for-each select="messages/item">
                    <xsl:if test="id">
                        <xsl:element name="{$STRUCT}">
                            <xsl:attribute name="name">message</xsl:attribute>
                            <xsl:attribute name="id">
                                <xsl:text>vk</xsl:text>
                            <xsl:value-of select="id"/>
                            </xsl:attribute>

                            <xsl:element name="{$STRING}">
                               <xsl:attribute name="name">SenderId</xsl:attribute>
                                <xsl:text>vk</xsl:text>
                               <xsl:value-of select="from_id"/>
                            </xsl:element>

                            <xsl:if test="from_id">
                                <xsl:if test="from_id != '0'">
                                    <xsl:variable name="current_uid" select="from_id"/>
                                    <xsl:element name="{$STRING}">
                                       <xsl:attribute name="name">SenderName</xsl:attribute>
                                            <xsl:value-of select="//sender/item[uid=$current_uid]/first_name"/>
                                            <xsl:text> </xsl:text>
                                            <xsl:value-of select="//sender/item[uid=$current_uid]/last_name"/>
                                    </xsl:element>
                                </xsl:if>
                            </xsl:if>

                            <xsl:element name="{$STRING}">
                                <xsl:attribute name="name">Time</xsl:attribute>
                                <xsl:value-of select="date"/>
                            </xsl:element>

                            <xsl:element name="{$STRING}">
                                <xsl:attribute name="name">Text</xsl:attribute>
                                <xsl:value-of select="text"/>
                            </xsl:element>

                            <xsl:apply-templates select="attachment"/>

                        </xsl:element>
                    </xsl:if>
                </xsl:for-each>
            </xsl:element> 

        </xsl:element> 
    </xsl:element> 
</xsl:template>

</xsl:stylesheet>
