<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>

<xsl:variable name="REQUEST" select="'Request'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>

<xsl:include href="errors.xsl"/>

<xsl:template match="/">
 <xsl:apply-templates select="/data/response"/>
 <xsl:apply-templates select="/data/error"/>
 <xsl:apply-templates select="/data/info"/>
</xsl:template>

<xsl:template match="response">
    <xsl:element name="{$REQUEST}">
        <xsl:attribute name="class">
            <xsl:value-of select="/data/Request/Params/string[@name = 'class']"/>
        </xsl:attribute>
        <xsl:attribute name="function">
            <xsl:value-of select="/data/Request/Params/string[@name = 'function']"/>
        </xsl:attribute>

        <xsl:element name="{$PARAMS}">
            <xsl:attribute name="id">
                <xsl:value-of select="/data/Request/Params/Params/@id"/>
            </xsl:attribute>

            <xsl:for-each select="/data/Request/Params/Params/*"> 
                <xsl:copy-of select="."/>
            </xsl:for-each>
            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">captcha_sid</xsl:attribute>
                <xsl:value-of select="/data/Request/Params/string[@name = 'sid']"/>
            </xsl:element> 
            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">captcha_key</xsl:attribute>
                <xsl:value-of select="."/>
            </xsl:element> 

        </xsl:element> 
    </xsl:element>
</xsl:template>
</xsl:stylesheet>
