<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>
<xsl:param name="MID"/>  
<xsl:param name="SID"/>  
<xsl:param name="COUNTER"/> 
<xsl:param name="MAXCOUNTER"/> 
<xsl:param name="LOGIN"/> 
<xsl:param name="PASSWORD"/> 
<xsl:param name="STATUS"/>
<xsl:param name="AUTOUPDATE"/>  
<xsl:param name="CAPTCHA"/>
<xsl:param name="MESSAGE"/>

<xsl:variable name="PAGE_SIZE" select="20"/>  
<xsl:variable name="URL" select="'Url'"/>  
<xsl:variable name="GET_PROFILE" select="'getProfile'"/>  
<xsl:variable name="GET_PROFILE_NO_IMAGE" select="'getProfileNoImage'"/>  
<xsl:variable name="UPDATE_PROFILE" select="'updateProfile'"/>  
<xsl:variable name="SET_PROFILE" select="'setProfile'"/>
<xsl:variable name="GET_LIST_FRIENDS" select="'updateListFriends'"/>
<xsl:variable name="GET_INBOX_MESSAGES" select="'updateInboxMessages'"/>
<xsl:variable name="GET_NEW_INBOX_MESSAGES" select="'getNewInboxMessages'"/>
<xsl:variable name="GET_OUTBOX_MESSAGES" select="'updateOutboxMessages'"/>
<xsl:variable name="SEND_MESSAGE" select="'sendMessage'"/>
<xsl:variable name="GET_BINARY_DATA" select="'getBinaryData'"/>
<xsl:variable name="DELETE_FRIEND" select="'deleteFriend'"/>
<xsl:variable name="DELETE_MESSAGE" select="'deleteMessage'"/>
<xsl:variable name="READ_MESSAGE" select="'readMessage'"/>
<xsl:variable name="FUNCTION" select="/Request/@function"/>  

<xsl:template match="//Request">
    <xsl:choose>
          <xsl:when test="$FUNCTION = 'getSettings'">
                    
          </xsl:when>
          <xsl:otherwise>
                <xsl:element name="{$URL}">
        
                <xsl:if test="($FUNCTION = $GET_PROFILE) or ($FUNCTION = $GET_PROFILE_NO_IMAGE)">
                            <xsl:text>http://userapi.com/data?act=profile</xsl:text>
        
                </xsl:if>

                <xsl:if test="$FUNCTION = $UPDATE_PROFILE">
                            <xsl:text>http://userapi.com/data?act=profile</xsl:text>
        
                </xsl:if>

                <xsl:if test="$FUNCTION = $SET_PROFILE">
                            <xsl:text>http://userapi.com/data?act=edit_page</xsl:text>
                </xsl:if>
                <xsl:if test="$FUNCTION = $GET_LIST_FRIENDS">
                            <xsl:text>http://userapi.com/data?friends=</xsl:text>
                                            <xsl:value-of select="number($COUNTER)"/>
                                            <xsl:text>-</xsl:text>
                                           <xsl:choose>
                                          <xsl:when test="number($COUNTER) + number($PAGE_SIZE) > number($MAXCOUNTER)">
                                              <xsl:value-of select="number($MAXCOUNTER)"/>
                                          </xsl:when> 
                                          <xsl:otherwise>
                                            <xsl:value-of select="number($COUNTER) + number($PAGE_SIZE)"/>
                                          </xsl:otherwise>
                                          </xsl:choose>
                </xsl:if> 

                <xsl:if test="$FUNCTION = $GET_INBOX_MESSAGES">
                            <xsl:text>http://userapi.com/data?act=inbox</xsl:text>
                                          <xsl:text disable-output-escaping="yes">&amp;from=</xsl:text>
                                          <xsl:value-of select="number($COUNTER)"/>
                                          <xsl:text disable-output-escaping="yes">&amp;to=</xsl:text>
                                          <xsl:choose>
                                          <xsl:when test="number($COUNTER) + number($PAGE_SIZE) > number($MAXCOUNTER)">
                                               <xsl:if test="number($MAXCOUNTER) - number($COUNTER) > 1">
                                                 <xsl:value-of select="number($MAXCOUNTER)-1"/>
                                               </xsl:if>
                                               <xsl:if test="not(number($MAXCOUNTER) - number($COUNTER) > 1)">
                                                 <xsl:value-of select="number($MAXCOUNTER)"/>
                                               </xsl:if>
                                          </xsl:when> 
                                          <xsl:otherwise>
                                            <xsl:value-of select="number($COUNTER) + number($PAGE_SIZE)-1"/>
                                          </xsl:otherwise>
                                          </xsl:choose>
                </xsl:if> 
                <xsl:if test="$FUNCTION = $GET_OUTBOX_MESSAGES">
                            <xsl:text>http://userapi.com/data?act=outbox</xsl:text>
                                            <xsl:text disable-output-escaping="yes">&amp;from=</xsl:text>
                                            <xsl:value-of select="number($COUNTER)"/>
                                            <xsl:text disable-output-escaping="yes">&amp;to=</xsl:text>
                                          <xsl:choose>
                                          <xsl:when test="number($COUNTER) + number($PAGE_SIZE) > number($MAXCOUNTER)">
                                               <xsl:if test="number($MAXCOUNTER) - number($COUNTER) > 1">
                                                 <xsl:value-of select="number($MAXCOUNTER)-1"/>
                                               </xsl:if>
                                               <xsl:if test="not(number($MAXCOUNTER) - number($COUNTER) > 1)">
                                                 <xsl:value-of select="number($MAXCOUNTER)"/>
                                               </xsl:if>
                                          </xsl:when> 
                                          <xsl:otherwise>
                                            <xsl:value-of select="number($COUNTER) + number($PAGE_SIZE)-1"/>
                                          </xsl:otherwise>
                                          </xsl:choose>
                </xsl:if> 
                <xsl:if test="$FUNCTION = $READ_MESSAGE">
                  <xsl:text>http://userapi.com/data?act=history</xsl:text>
                </xsl:if> 

                <xsl:if test="$FUNCTION = $GET_NEW_INBOX_MESSAGES">  
                  <xsl:text>http://userapi.com/data?act=history</xsl:text>
                </xsl:if>

                <xsl:if test="$FUNCTION = $SEND_MESSAGE">
                            <xsl:text>http://userapi.com/data?act=add_message</xsl:text>
                </xsl:if>
                <xsl:if test="$FUNCTION = $DELETE_FRIEND">
                            <xsl:text>http://userapi.com/data?act=del_friend</xsl:text>
                </xsl:if>
                <xsl:if test="$FUNCTION = $DELETE_MESSAGE">
                            <xsl:text>http://userapi.com/data?act=del_message</xsl:text>
                </xsl:if>

                <xsl:apply-templates select="Params"/>
                </xsl:element> 
          </xsl:otherwise>
    </xsl:choose> 
</xsl:template>

<xsl:template match="Params">
<xsl:if test="not($FUNCTION = $GET_BINARY_DATA)">
    <xsl:choose>
          <xsl:when test="string-length(@id) != 0">
                    <xsl:text disable-output-escaping="yes">&amp;id=</xsl:text>
                    <xsl:value-of select="substring-after(@id, 'vk') "/>
          </xsl:when>
          <xsl:otherwise>
                    <xsl:text disable-output-escaping="yes">&amp;id=</xsl:text>
                    <xsl:value-of select="$MID"/>
          </xsl:otherwise>
    </xsl:choose> 
    <xsl:text disable-output-escaping="yes">&amp;sid=</xsl:text>
    <xsl:value-of select="$SID"/>
</xsl:if>

     <xsl:for-each select="//string"> 
          <xsl:if test="@name = 'From'">
                    <xsl:text disable-output-escaping="yes">&amp;</xsl:text>
                    <xsl:text>from</xsl:text>
                    <xsl:text>=</xsl:text>
                    <xsl:value-of select="."/>
          </xsl:if>
          <xsl:if test="@name = 'To'">
                    <xsl:text disable-output-escaping="yes">&amp;</xsl:text>
                    <xsl:text>to</xsl:text>
                    <xsl:text>=</xsl:text>
                    <xsl:value-of select="."/>
          </xsl:if>
          <xsl:if test="@name = 'CityId'">
                    <xsl:text disable-output-escaping="yes">&amp;</xsl:text>
                    <xsl:text>cii</xsl:text>
                    <xsl:text>=</xsl:text>
                    <xsl:value-of select="."/>
          </xsl:if>
          <xsl:if test="@name = 'text'">
                    <xsl:text disable-output-escaping="yes">&amp;</xsl:text>
                    <xsl:text>message</xsl:text>
                    <xsl:text>=</xsl:text>
                    <xsl:value-of select="."/>
          </xsl:if>

          <xsl:if test="$CAPTCHA = '1'">
                  <xsl:if test="@name = 'fcsid'">
                            <xsl:text disable-output-escaping="yes">&amp;</xsl:text>
                            <xsl:text>fcsid</xsl:text>
                            <xsl:text>=</xsl:text>
                            <xsl:value-of select="."/>
                  </xsl:if>
                  <xsl:if test="@name = 'fccode'">
                            <xsl:text disable-output-escaping="yes">&amp;</xsl:text>
                            <xsl:text>fccode</xsl:text>
                            <xsl:text>=</xsl:text>
                            <xsl:value-of select="."/>
                  </xsl:if>
          </xsl:if>

          <xsl:if test="@name = 'messageId'">
              <xsl:if test="$FUNCTION = $DELETE_MESSAGE">
                    <xsl:text disable-output-escaping="yes">&amp;</xsl:text>
                    <xsl:text>wid</xsl:text>
                    <xsl:text>=</xsl:text>
                    <xsl:value-of select="$MID"/>
                    <xsl:text>_</xsl:text>
                    <xsl:value-of select="substring-after(., 'vk') "/>
              </xsl:if>
              <xsl:if test="$FUNCTION = $READ_MESSAGE">
                    <xsl:text disable-output-escaping="yes">&amp;</xsl:text>
                    <xsl:text>read</xsl:text>
                    <xsl:text>=</xsl:text>
                    <xsl:value-of select="substring-after(., 'vk') "/>
                    <xsl:text>_</xsl:text>
              </xsl:if>
          </xsl:if>

     </xsl:for-each>

     <xsl:for-each select="select"> 
            <xsl:choose>
                    <xsl:when test="@name = 'Gender'">
                            <xsl:text disable-output-escaping="yes">&amp;</xsl:text>
                            <xsl:text>sx=</xsl:text>
                    </xsl:when>
                    <xsl:when test="@name = 'FamilyState'">
                            <xsl:text disable-output-escaping="yes">&amp;</xsl:text>
                            <xsl:text>fs=</xsl:text>
                    </xsl:when>
                    <xsl:when test="@name = 'PoliticalView'">
                            <xsl:text disable-output-escaping="yes">&amp;</xsl:text>
                            <xsl:text>pv=</xsl:text>
                    </xsl:when>
             </xsl:choose> 
            <xsl:for-each select="string">
                    <xsl:if test="@selected = '1'">
                        <xsl:choose>
                                <xsl:when test=". = 'female'">1</xsl:when>
                                <xsl:when test=". = 'male'">2</xsl:when>
                                <xsl:when test=". = 'single'">1</xsl:when>
                                <xsl:when test=". = 'in a relationship'">2</xsl:when>
                                <xsl:when test=". = 'engaged'">3</xsl:when>
                                <xsl:when test=". = 'married'">4</xsl:when>
                                <xsl:when test=". = 'it is complicated'">5</xsl:when>
                                <xsl:when test=". = 'actively searching'">6</xsl:when>
                                <xsl:when test=". = 'Communist'">1</xsl:when>
                                <xsl:when test=". = 'Socialist'">2</xsl:when>
                                <xsl:when test=". = 'Moderate'">3</xsl:when>
                                <xsl:when test=". = 'Liberal'">4</xsl:when>
                                <xsl:when test=". = 'Conservative'">5</xsl:when>
                                <xsl:when test=". = 'Monarchist'">6</xsl:when>
                                <xsl:when test=". = 'Ultraconservative'">7</xsl:when>
                                <xsl:when test=". = 'Apathetic'">8</xsl:when>
                        </xsl:choose>
                    </xsl:if>
            </xsl:for-each>
     </xsl:for-each>

     <xsl:for-each select="date">
        <xsl:if test="@name = 'Birthday'">
                <xsl:text disable-output-escaping="yes">&amp;</xsl:text>
                <xsl:text>bd=</xsl:text>
                <xsl:value-of select="substring(., 1, 2) "/>

                <xsl:text disable-output-escaping="yes">&amp;</xsl:text>
                <xsl:text>bm=</xsl:text>
                <xsl:value-of select="substring(., 4, 2) "/>

                <xsl:text disable-output-escaping="yes">&amp;</xsl:text>
                <xsl:text>by=</xsl:text>
                <xsl:value-of select="substring(., 7, 4) "/>
        </xsl:if>
     </xsl:for-each>

     <xsl:for-each select="img">
          <xsl:if test="$FUNCTION = $GET_BINARY_DATA">
                <xsl:if test="position() = $COUNTER + 1">
                        <xsl:value-of select="@uri"/>
                </xsl:if>
          </xsl:if>
     </xsl:for-each>

</xsl:template>
</xsl:stylesheet>
