//******************************************************************************
//  Copyright (c) 2005-2010 by Jan Van hijfte
//
//  See the included file COPYING.TXT for details about the copyright.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//******************************************************************************


#include "qmaemo5valuebutton_c.h"

#if defined MAEMO5
QMaemo5ValueButtonH QMaemo5ValueButton_create(QWidgetH parent)
{
	return (QMaemo5ValueButtonH) new QMaemo5ValueButton((QWidget*)parent);
}

void QMaemo5ValueButton_destroy(QMaemo5ValueButtonH handle)
{
	delete (QMaemo5ValueButton *)handle;
}

QMaemo5ValueButtonH QMaemo5ValueButton_create2(PWideString text, QWidgetH parent)
{
	QString t_text;
	copyPWideStringToQString(text, t_text);
	return (QMaemo5ValueButtonH) new QMaemo5ValueButton(t_text, (QWidget*)parent);
}

QMaemo5ValueButtonH QMaemo5ValueButton_create3(const QIconH icon, PWideString text, QWidgetH parent)
{
	QString t_text;
	copyPWideStringToQString(text, t_text);
	return (QMaemo5ValueButtonH) new QMaemo5ValueButton(*(const QIcon*)icon, t_text, (QWidget*)parent);
}

void QMaemo5ValueButton_sizeHint(QMaemo5ValueButtonH handle, PSize retval)
{
	*(QSize *)retval = ((QMaemo5ValueButton *)handle)->sizeHint();
}

void QMaemo5ValueButton_valueText(QMaemo5ValueButtonH handle, PWideString retval)
{
	QString t_retval;
	t_retval = ((QMaemo5ValueButton *)handle)->valueText();
	copyQStringToPWideString(t_retval, retval);
}

QMaemo5ValueButton::ValueLayout QMaemo5ValueButton_valueLayout(QMaemo5ValueButtonH handle)
{
	return (QMaemo5ValueButton::ValueLayout) ((QMaemo5ValueButton *)handle)->valueLayout();
}

void QMaemo5ValueButton_setValueLayout(QMaemo5ValueButtonH handle, QMaemo5ValueButton::ValueLayout layout)
{
	((QMaemo5ValueButton *)handle)->setValueLayout(layout);
}

QMaemo5AbstractPickSelectorH QMaemo5ValueButton_pickSelector(QMaemo5ValueButtonH handle)
{
	return (QMaemo5AbstractPickSelectorH) ((QMaemo5ValueButton *)handle)->pickSelector();
}

void QMaemo5ValueButton_setPickSelector(QMaemo5ValueButtonH handle, QMaemo5AbstractPickSelectorH picker)
{
	((QMaemo5ValueButton *)handle)->setPickSelector((QMaemo5AbstractPickSelector*)picker);
}

void QMaemo5ValueButton_setValueText(QMaemo5ValueButtonH handle, PWideString text)
{
	QString t_text;
	copyPWideStringToQString(text, t_text);
	((QMaemo5ValueButton *)handle)->setValueText(t_text);
}

#endif
