//******************************************************************************
//  Copyright (c) 2005-2010 by Jan Van hijfte
//
//  See the included file COPYING.TXT for details about the copyright.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//******************************************************************************


#ifndef QAPPLICATION_C_H
#define QAPPLICATION_C_H

#include <QtGui>
#include "pascalbind.h"

C_EXPORT QApplicationH QApplication_create(int* argc, char** argv, int p3);
C_EXPORT void QApplication_destroy(QApplicationH handle);
C_EXPORT QApplicationH QApplication_create2(int* argc, char** argv, bool GUIenabled, int p4);
C_EXPORT QApplicationH QApplication_create3(int* argc, char** argv, QApplication::Type p3, int p4);
C_EXPORT QApplicationH QApplication_create4(Display* dpy, Qt::HANDLE visual, Qt::HANDLE cmap, int p4);
C_EXPORT QApplicationH QApplication_create5(Display* dpy, int* argc, char** argv, Qt::HANDLE visual, Qt::HANDLE cmap, int p6);
C_EXPORT QApplication::Type QApplication_type();
C_EXPORT QStyleH QApplication_style();
C_EXPORT void QApplication_setStyle(QStyleH p1);
C_EXPORT QStyleH QApplication_setStyle2(PWideString p1);
C_EXPORT int QApplication_colorSpec();
C_EXPORT void QApplication_setColorSpec(int p1);
C_EXPORT void QApplication_setGraphicsSystem(PWideString p1);
C_EXPORT QCursorH QApplication_overrideCursor();
C_EXPORT void QApplication_setOverrideCursor(const QCursorH p1);
C_EXPORT void QApplication_changeOverrideCursor(const QCursorH p1);
C_EXPORT void QApplication_restoreOverrideCursor();
C_EXPORT void QApplication_palette(QPaletteH retval);
C_EXPORT void QApplication_palette2(QPaletteH retval, const QWidgetH p1);
C_EXPORT void QApplication_palette3(QPaletteH retval, const char* className);
C_EXPORT void QApplication_setPalette(const QPaletteH p1, const char* className);
C_EXPORT void QApplication_font(QFontH retval);
C_EXPORT void QApplication_font2(QFontH retval, const QWidgetH p1);
C_EXPORT void QApplication_font3(QFontH retval, const char* className);
C_EXPORT void QApplication_setFont(const QFontH p1, const char* className);
C_EXPORT void QApplication_fontMetrics(QFontMetricsH retval);
C_EXPORT void QApplication_setWindowIcon(const QIconH icon);
C_EXPORT void QApplication_windowIcon(QIconH retval);
C_EXPORT QDesktopWidgetH QApplication_desktop();
C_EXPORT QWidgetH QApplication_activePopupWidget();
C_EXPORT QWidgetH QApplication_activeModalWidget();
C_EXPORT QClipboardH QApplication_clipboard();
C_EXPORT QWidgetH QApplication_focusWidget();
C_EXPORT QWidgetH QApplication_activeWindow();
C_EXPORT void QApplication_setActiveWindow(QWidgetH act);
C_EXPORT QWidgetH QApplication_widgetAt(const QPointH p);
C_EXPORT QWidgetH QApplication_widgetAt2(int x, int y);
C_EXPORT QWidgetH QApplication_topLevelAt(const QPointH p);
C_EXPORT QWidgetH QApplication_topLevelAt2(int x, int y);
C_EXPORT void QApplication_syncX();
C_EXPORT void QApplication_beep();
C_EXPORT void QApplication_alert(QWidgetH widget, int duration);
C_EXPORT unsigned int QApplication_keyboardModifiers();
C_EXPORT unsigned int QApplication_mouseButtons();
C_EXPORT void QApplication_setDesktopSettingsAware(bool p1);
C_EXPORT bool QApplication_desktopSettingsAware();
C_EXPORT void QApplication_setCursorFlashTime(int p1);
C_EXPORT int QApplication_cursorFlashTime();
C_EXPORT void QApplication_setDoubleClickInterval(int p1);
C_EXPORT int QApplication_doubleClickInterval();
C_EXPORT void QApplication_setKeyboardInputInterval(int p1);
C_EXPORT int QApplication_keyboardInputInterval();
C_EXPORT void QApplication_setWheelScrollLines(int p1);
C_EXPORT int QApplication_wheelScrollLines();
C_EXPORT void QApplication_setGlobalStrut(const QSizeH p1);
C_EXPORT void QApplication_globalStrut(PSize retval);
C_EXPORT void QApplication_setStartDragTime(int ms);
C_EXPORT int QApplication_startDragTime();
C_EXPORT void QApplication_setStartDragDistance(int l);
C_EXPORT int QApplication_startDragDistance();
C_EXPORT void QApplication_setLayoutDirection(Qt::LayoutDirection direction);
C_EXPORT Qt::LayoutDirection QApplication_layoutDirection();
C_EXPORT bool QApplication_isRightToLeft();
C_EXPORT bool QApplication_isLeftToRight();
C_EXPORT bool QApplication_isEffectEnabled(Qt::UIEffect p1);
C_EXPORT void QApplication_setEffectEnabled(Qt::UIEffect p1, bool enable);
C_EXPORT bool QApplication_x11EventFilter(QApplicationH handle, XEvent* p1);
C_EXPORT int QApplication_x11ClientMessage(QApplicationH handle, QWidgetH p1, XEvent* p2, bool passive_only);
C_EXPORT int QApplication_x11ProcessEvent(QApplicationH handle, XEvent* p1);
C_EXPORT bool QApplication_isSessionRestored(QApplicationH handle);
C_EXPORT void QApplication_sessionId(QApplicationH handle, PWideString retval);
C_EXPORT void QApplication_sessionKey(QApplicationH handle, PWideString retval);
C_EXPORT void QApplication_commitData(QApplicationH handle, QSessionManagerH sm);
C_EXPORT void QApplication_saveState(QApplicationH handle, QSessionManagerH sm);
C_EXPORT void QApplication_setInputContext(QApplicationH handle, QInputContextH p1);
C_EXPORT QInputContextH QApplication_inputContext(QApplicationH handle);
C_EXPORT void QApplication_keyboardInputLocale(QLocaleH retval);
C_EXPORT Qt::LayoutDirection QApplication_keyboardInputDirection();
C_EXPORT int QApplication_exec();
C_EXPORT bool QApplication_notify(QApplicationH handle, QObjectH p1, QEventH p2);
C_EXPORT void QApplication_setQuitOnLastWindowClosed(bool quit);
C_EXPORT bool QApplication_quitOnLastWindowClosed();
C_EXPORT void QApplication_styleSheet(QApplicationH handle, PWideString retval);
C_EXPORT void QApplication_setStyleSheet(QApplicationH handle, PWideString sheet);
C_EXPORT void QApplication_setAutoSipEnabled(QApplicationH handle, const bool enabled);
C_EXPORT bool QApplication_autoSipEnabled(QApplicationH handle);
C_EXPORT void QApplication_closeAllWindows();
C_EXPORT void QApplication_aboutQt();

#endif
