/*vim: set sw=4 ts=4 et: */
/*
 * This file is part of Live Wallpaper (livewp)
 * 
 * Copyright (C) 2010 Vlad Vasiliev
 * Copyright (C) 2010 Tanya Makova
 *       for the code
 * 
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 * 
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
*/
/*******************************************************************************/
#include "livewp-scene.h" 

void 
destroy_scene(AWallpaperPlugin *desktop_plugin)
{
    if (desktop_plugin->priv->scene){
	    GSList * tmp = desktop_plugin->priv->scene->actors;
	    while (tmp != NULL){
		destroy_actor(tmp->data);
		tmp = g_slist_next(tmp);
	    }
	    if (tmp)
		g_slist_free(tmp);
	    desktop_plugin->priv->scene->actors = NULL;
	    if (desktop_plugin->priv->scene){
		g_free(desktop_plugin->priv->scene);
		desktop_plugin->priv->scene = NULL;
	    }
    }
}

void
reload_scene(AWallpaperPlugin *desktop_plugin)
{
    fprintf(stderr,"Reload scene %s\n", desktop_plugin->priv->theme);  
    destroy_scene(desktop_plugin);
#if 0
    if (!strcmp(desktop_plugin->priv->theme,"Modern"))
        init_scene_Modern(desktop_plugin);
    else if (!strcmp(desktop_plugin->priv->theme,"Berlin")) 
        init_scene_Berlin(desktop_plugin);
    else if (!strcmp(desktop_plugin->priv->theme,"Matrix")) 
        init_scene_Matrix(desktop_plugin);
#endif
    init_scene_theme(desktop_plugin);
}

void
init_scene_Matrix(AWallpaperPlugin *desktop_plugin)
{
  Actor *actor;
  Scene *scene;
  GPtrArray *child;
  gint now = time(NULL);
  gint y1, y2;

  if (desktop_plugin->priv->rich_animation){
      y1 = -480;
      y2 = -480-480;
  }else {
      y1 = 0;
      y2 = -480;
  }

  //fprintf(stderr, "init scene2 \n");
  scene = g_new0(Scene, 1);
  //scene.daytime = get_daytime();
  scene->actors = NULL;
  desktop_plugin->priv->scene = scene;
  
  actor = init_object(desktop_plugin, "background", "bg.png", 
                      0, 0, 5, 800, 480, 
                      TRUE, TRUE, 100, 255, 
                      NULL, NULL, NULL);
  scene->actors = g_slist_append(scene->actors, actor);

  actor = init_object(desktop_plugin, "symbols", "symbols.png", 
                      0, 0, 10, 800, 480, 
                      TRUE, TRUE, 100, 255, 
                      NULL, NULL, NULL);
  scene->actors = g_slist_append(scene->actors, actor);

  child = g_ptr_array_sized_new(4);
  actor = init_object(desktop_plugin, "layer1", "layer1_2.png", 
                      0, y1, 6, 800, 960, 
                      TRUE, TRUE, 100, 255, 
                      NULL, NULL, NULL);
  //actor->time_start_animation = now;
  //actor->duration_animation = G_MAXINT;
  scene->actors = g_slist_append(scene->actors, actor);
  g_ptr_array_add(child, actor);

  actor = init_object(desktop_plugin, "layer1", "layer1_1.png", 
                      0, y2, 7, 800, 960, 
                      TRUE, TRUE, 100, 255, 
                      NULL, NULL, NULL);
  //actor->time_start_animation = now;
  //actor->duration_animation = G_MAXINT;
  scene->actors = g_slist_append(scene->actors, actor);
  g_ptr_array_add(child, actor);

  actor = init_object(desktop_plugin, "layer2", "layer2_2.png", 
                      0, y1, 8, 800, 960, 
                      TRUE, TRUE, 100, 255, 
                      NULL, NULL, NULL);
  //actor->time_start_animation = now;
  //actor->duration_animation = G_MAXINT;
  scene->actors = g_slist_append(scene->actors, actor);
  g_ptr_array_add(child, actor);

  actor = init_object(desktop_plugin, "layer2", "layer2_1.png", 
                      0, y2, 9, 800, 960, 
                      TRUE, TRUE, 100, 255, 
                      NULL, NULL, NULL);
  //actor->time_start_animation = now;
  //actor->duration_animation = G_MAXINT;
  scene->actors = g_slist_append(scene->actors, actor);
  g_ptr_array_add(child, actor);

  actor = init_object(desktop_plugin, "layers", "", 
                      0, y2, 9, 800, 960, 
                      FALSE, FALSE, 100, 255, 
                      (gpointer)&change_layer, NULL, child);
  actor->time_start_animation = now;
  actor->duration_animation = G_MAXINT;
  scene->actors = g_slist_append(scene->actors, actor);

  run_long_timeout(desktop_plugin);

}

/* Init Modern Scene */
void
init_scene_Modern(AWallpaperPlugin *desktop_plugin)
{
  Actor *actor;
  Scene *scene;
  gint now = time(NULL);
  gint i;
  gint winds[13][2];
  GPtrArray *child; 

  //fprintf(stderr, "init scene \n");
  scene = g_new0(Scene, 1);
  scene->daytime = get_daytime();
  scene->actors = NULL;
  scene->wind_orientation = -1;
  scene->wind_angle = 0.3;
  /* init value for random */
  scene->seed = time(NULL);
  scene->notification = TRUE;
  desktop_plugin->priv->scene = scene;
  actor = init_object(desktop_plugin, "sky", "sky0.png", 
                      0, 0, 5, 800, 480, 
                      TRUE , TRUE, 100, 255, 
                      (gpointer)&change_static_actor, NULL, NULL);
  scene->actors = g_slist_append(scene->actors, actor);
  change_static_actor(actor, desktop_plugin);
  
  actor = init_object(desktop_plugin, "sun", "sun.png", 
                      0, 0, 6, 88, 88, 
                      FALSE, FALSE, 100, 255, 
                      (gpointer)&change_sun, NULL, NULL);
  actor->time_start_animation = now;
  actor->duration_animation = G_MAXINT;
  change_sun(actor, desktop_plugin);
  scene->actors = g_slist_append(scene->actors, actor);

  //actor = init_object(desktop_plugin, "dot", "dot1.png", 0, 0, 11, 50, 50, 
    //                  TRUE, 100, 255, NULL, NULL);
  //scene.actors = g_slist_append(scene.actors, actor);
  
  actor = init_object(desktop_plugin, "cloud1", "cloud1.png", 
                      0, fast_rnd(300)-97, 7, 150, 97, 
                      FALSE, FALSE, 100, 255, 
                      (gpointer)&change_cloud, NULL, NULL);
  actor->time_start_animation = now + fast_rnd(20);
  actor->duration_animation = 3*60;
  scene->actors = g_slist_append(scene->actors, actor);
  
  actor = init_object(desktop_plugin, "cloud2", "cloud2.png", 
                      0, fast_rnd(300)-75, 7, 188, 75, 
                      FALSE, FALSE, 100, 255, 
                      (gpointer)&change_cloud, NULL, NULL);
  actor->time_start_animation = now + fast_rnd(40)+10;
  actor->duration_animation = 3*60;
  scene->actors = g_slist_append(scene->actors, actor);

  actor = init_object(desktop_plugin, "cloud4", "cloud4.png", 
                      0, fast_rnd(300)-75, 7, 150, 75, 
                      FALSE, FALSE, 100, 255, 
                      (gpointer)&change_cloud, NULL, NULL);
  actor->time_start_animation = now + fast_rnd(60) + 20;
  actor->duration_animation = 5*60;
  scene->actors = g_slist_append(scene->actors, actor);


  actor = init_object(desktop_plugin, "town", "town0.png", 
                      0, 0, 8, 800, 480, 
                      TRUE, TRUE, 100, 255, 
                      (gpointer)&change_static_actor, NULL, NULL);
  change_static_actor(actor, desktop_plugin);
  scene->actors = g_slist_append(scene->actors, actor);

  actor = init_object(desktop_plugin, "stend", "stend0.png", 
                      452, 166, 9, 300, 305, 
                      TRUE, TRUE, 100, 255, 
                      (gpointer)&change_static_actor, NULL, NULL);
  change_static_actor(actor, desktop_plugin);
  scene->actors = g_slist_append(scene->actors, actor);


  child = g_ptr_array_sized_new(4);
  actor = init_object(desktop_plugin, "call", "call.png", 
                      480, 190, 9, 50, 58, 
                      FALSE, TRUE, 100, 255, 
                      NULL, NULL, NULL);
  scene->actors = g_slist_append(scene->actors, actor);
  g_ptr_array_add(child, actor);

  actor = init_object(desktop_plugin, "chat", "chat.png", 
                      540, 190, 9, 50, 58, 
                      FALSE, TRUE, 100, 255, 
                      NULL, NULL, NULL);
  scene->actors = g_slist_append(scene->actors, actor);
  g_ptr_array_add(child, actor);

  actor = init_object(desktop_plugin, "mail", "mail.png", 
                      600, 190, 9, 50, 58, 
                      FALSE, TRUE, 100, 255, 
                      NULL, NULL, NULL);
  scene->actors = g_slist_append(scene->actors, actor);
  g_ptr_array_add(child, actor);
  
  actor = init_object(desktop_plugin, "sms", "sms.png", 
                      660, 190, 9, 50, 58, 
                      FALSE, TRUE, 100, 255, 
                      NULL, NULL, NULL);
  scene->actors = g_slist_append(scene->actors, actor);
  g_ptr_array_add(child, actor);

  actor = init_object(desktop_plugin, "billboard_text", "",
                      470, 174, 9, 300, 108,
                      FALSE, FALSE, 100, 255,
                      (gpointer)&change_billboard, NULL, child);
  create_hildon_actor_text(actor, desktop_plugin);
  //actor->time_start_animation = time(NULL) + 20;
  change_billboard(actor, desktop_plugin);
  scene->actors = g_slist_append(scene->actors, actor);

  actor = init_object(desktop_plugin, "tram", "tram.png", 
                      -300, 225, 10, 350, 210, 
                      FALSE, FALSE, 100, 255, 
                      (gpointer)&change_tram, NULL, NULL);
  actor->time_start_animation = time(NULL) + fast_rnd(10); 
  actor->duration_animation = 60;
  scene->actors = g_slist_append(scene->actors, actor);

  actor = init_object(desktop_plugin, "border", "border0.png", 
                      0, 480-79, 11, 800, 79,
                      TRUE, TRUE, 100, 255, 
                      (gpointer)&change_static_actor_with_corner, NULL, NULL);
  change_static_actor_with_corner(actor, desktop_plugin);
  scene->actors = g_slist_append(scene->actors, actor);
  
  actor = init_object(desktop_plugin, "moon", "moon1.png", 
                      400, 20, 6, 60, 60, 
                      FALSE, FALSE, 100, 255, 
                      (gpointer)&change_moon, NULL, NULL);
  change_moon(actor, desktop_plugin);
  scene->actors = g_slist_append(scene->actors, actor);

  actor = init_object(desktop_plugin, "wind", "", 
                      0, 0, 5, 0, 0, 
                      FALSE, FALSE, 100, 255, 
                      (gpointer)&change_wind, NULL, NULL);
  change_wind(actor, desktop_plugin);
  scene->actors = g_slist_append(scene->actors, actor);

    /* windows in 4-th house  */

    winds[0][0] = 482;
    winds[0][1] = 180;

    winds[1][0] = 495;
    winds[1][1] = 179;

    winds[2][0] = 482;
    winds[2][1] = 191;

    winds[3][0] = 495;
    winds[3][1] = 190;
    
    winds[4][0] = 482;
    winds[4][1] = 201;
    
    winds[5][0] = 495;
    winds[5][1] = 210;
    
    winds[6][0] = 482;
    winds[6][1] = 222;
    
    winds[7][0] = 495;
    winds[7][1] = 221;
    
    winds[8][0] = 459;
    winds[8][1] = 203;
    
    winds[9][0] = 495;
    winds[9][1] = 241;
    
    winds[10][0] = 495;
    winds[10][1] = 252;
    
    winds[11][0] = 482;
    winds[11][1] = 273;
    
    winds[12][0] = 495;
    winds[12][1] = 303;
    for (i=0; i<13; i++){
        actor = init_object(desktop_plugin, "window1", "window1.png", 
                            winds[i][0], winds[i][1], 8, 8, 10, 
                            FALSE, FALSE, 100, 255, 
                            (gpointer)&change_window1, NULL, NULL);
        //change_window1(actor, desktop_plugin);
        actor->time_start_animation = now + fast_rnd(30);
        scene->actors = g_slist_append(scene->actors, actor);

    }
    
    /* windows in 1-th house  */
    
    winds[0][0] = 86;
    winds[0][1] = 321;

    winds[1][0] = 86;
    winds[1][1] = 363;

    winds[2][0] = 86;
    winds[2][1] = 385;

    winds[3][0] = 86;
    winds[3][1] = 286;
    
    winds[4][0] = 94;
    winds[4][1] = 232;
    
    winds[5][0] = 94;
    winds[5][1] = 243;
    
    winds[6][0] = 94;
    winds[6][1] = 265;
    
    winds[7][0] = 94;
    winds[7][1] = 331;
    for (i=0; i<8; i++){
        actor = init_object(desktop_plugin, "window2", "window2.png", 
                            winds[i][0], winds[i][1], 8, 8, 10, 
                            FALSE, FALSE, 100, 255, 
                            (gpointer)&change_window1, NULL, NULL);
        //change_window1(actor, desktop_plugin);
        actor->time_start_animation = now + fast_rnd(30);
        scene->actors = g_slist_append(scene->actors, actor);

    }
    
    /* windows in 3-th house  */
    
    winds[0][0] = 251;
    winds[0][1] = 162;

    winds[1][0] = 251;
    winds[1][1] = 196;

    winds[2][0] = 251;
    winds[2][1] = 278;

    winds[3][0] = 251;
    winds[3][1] = 289;
    
    winds[4][0] = 313;
    winds[4][1] = 173;
    
    winds[5][0] = 322;
    winds[5][1] = 160;
    
    winds[6][0] = 303;
    winds[6][1] = 217;
    
    winds[7][0] = 322;
    winds[7][1] = 224;
    
    winds[8][0] = 323;
    winds[8][1] = 217;
    
    winds[9][0] = 322;
    winds[9][1] = 288;
    
    for (i=0; i<10; i++){
        actor = init_object(desktop_plugin, "window3", "window3.png", 
                            winds[i][0], winds[i][1], 8, 8, 10, 
                            FALSE, FALSE, 100, 255, 
                            (gpointer)&change_window1, NULL, NULL);
        //change_window1(actor, desktop_plugin);
        actor->time_start_animation = now + fast_rnd(30);
        scene->actors = g_slist_append(scene->actors, actor);

    }

    /* windows in 5-th house  */
    
    winds[0][0] = 610;
    winds[0][1] = 224;

    winds[1][0] = 602;
    winds[1][1] = 245;

    winds[2][0] = 602;
    winds[2][1] = 264;

    winds[3][0] = 610;
    winds[3][1] = 301;
    
    winds[4][0] = 610;
    winds[4][1] = 320;
    
    winds[5][0] = 593;
    winds[5][1] = 352;
    
    winds[6][0] = 610;
    winds[6][1] = 368;
    
    for (i=0; i<7; i++){
        actor = init_object(desktop_plugin, "window4", "window4.png", 
                            winds[i][0], winds[i][1], 8, 8, 10, 
                            FALSE, FALSE, 100, 255, 
                            (gpointer)&change_window1, NULL, NULL);
        //change_window1(actor, desktop_plugin);
        actor->time_start_animation = now + fast_rnd(30);
        scene->actors = g_slist_append(scene->actors, actor);

    }

    /* windows in 6-th house  */
    
    winds[0][0] = 717;
    winds[0][1] = 283;

    winds[1][0] = 698;
    winds[1][1] = 293;

    winds[2][0] = 717;
    winds[2][1] = 315;

    winds[3][0] = 717;
    winds[3][1] = 323;
    
    winds[4][0] = 698;
    winds[4][1] = 362;
    
    winds[5][0] = 698;
    winds[5][1] = 400;
    
    for (i=0; i<6; i++){
        actor = init_object(desktop_plugin, "window5", "window5.png", 
                            winds[i][0], winds[i][1], 8, 8, 10, 
                            FALSE, FALSE, 100, 255, 
                            (gpointer)&change_window1, NULL, NULL);
        //change_window1(actor, desktop_plugin);
        actor->time_start_animation = now + fast_rnd(30);
        scene->actors = g_slist_append(scene->actors, actor);

    }
    run_long_timeout(desktop_plugin);

#if 0    
  anim = g_new0(Animation, 1);
  anim->count = 1;
  anim->actor = actor;
  anim->func_change = &change_tram;
  anim->func_time = NULL;
  anim->timestart = time(NULL); 
  anim->timeall = 10;
  
  scene.dynamic_actors = g_slist_append(scene.dynamic_actors, anim);
#endif  
}

/* Init Berlin Scene */
void
init_scene_Berlin(AWallpaperPlugin *desktop_plugin)
{
  Actor *actor, *actor1, *actor2;
  Scene *scene;
  gint now = time(NULL);
  gint i; 
  gint winds[13][2];
  GPtrArray *child = NULL;

  scene = g_new0(Scene, 1);
  scene->daytime = get_daytime();
  scene->actors = NULL;
  scene->wind_orientation = -1;
  scene->wind_angle = 0.3;
  /* init value for random */
  scene->seed = time(NULL);
  desktop_plugin->priv->scene = scene;
  
  actor = init_object(desktop_plugin, "sky", "sky.png", 0, 0, 5, 800, 480, 
                      TRUE, TRUE, 100, 255, 
                      (gpointer)&change_static_actor, NULL, NULL);
  change_static_actor(actor, desktop_plugin);
  scene->actors = g_slist_append(scene->actors, actor);

  
  actor = init_object(desktop_plugin, "sun", "sun.png", 0, 0, 6, 88, 88, 
                      FALSE, FALSE, 100, 255, 
                      (gpointer)&change_sun, NULL, NULL);
  actor->time_start_animation = time(NULL);
  actor->duration_animation = G_MAXINT;
  change_sun(actor, desktop_plugin);
  scene->actors = g_slist_append(scene->actors, actor);

#if 0
  actor = init_object(desktop_plugin, "dot", "dot1.png", 0, 0, 11, 50, 50, 
                      TRUE, 100, 255, NULL, NULL);
  scene.actors = g_slist_append(scene.actors, actor);
#endif

  actor = init_object(desktop_plugin, "moon", "moon1.png", 400, 15, 6, 60, 60, 
                      FALSE, FALSE, 100, 255, 
                      (gpointer)&change_moon, NULL, NULL);
  change_moon(actor, desktop_plugin);
  scene->actors = g_slist_append(scene->actors, actor);
  
  actor = init_object(desktop_plugin, "cloud1", "cloud1.png", 0, fast_rnd(300)-97, 7, 150, 97, 
                      FALSE, FALSE, 100, 255, 
                      (gpointer)&change_cloud, NULL, NULL);
  actor->time_start_animation = now + fast_rnd(30) + 10;
  actor->duration_animation = 3*60;
  scene->actors = g_slist_append(scene->actors, actor);
  
  actor = init_object(desktop_plugin, "cloud2", "cloud2.png", 0, fast_rnd(300)-75, 7, 188, 75, 
                      FALSE, FALSE, 100, 255, 
                      (gpointer)&change_cloud, NULL, NULL);
  actor->time_start_animation = now + fast_rnd(10);
  actor->duration_animation = 3*60;
  scene->actors = g_slist_append(scene->actors, actor);

  actor = init_object(desktop_plugin, "cloud4", "cloud4.png", 0, fast_rnd(300)-75, 7, 150, 75, 
                      FALSE, FALSE, 100, 255, 
                      (gpointer)&change_cloud, NULL, NULL);
  actor->time_start_animation = now + fast_rnd(60) + 20;
  actor->duration_animation = 5*60;
  scene->actors = g_slist_append(scene->actors, actor);

 
  actor = init_object(desktop_plugin, "plane2", "plane3.png", 0, 45, 8, 160, 50, 
                      FALSE, FALSE, 100, 255, 
                      (gpointer)&change_plane2, NULL, NULL);
  actor->time_start_animation = now + fast_rnd(40) + 20;
  actor->duration_animation = 60;
  scene->actors = g_slist_append(scene->actors, actor);
  
  actor = init_object(desktop_plugin, "plane1", "tu154.png", 620, 233, 9, 300, 116, 
                      FALSE, FALSE, 100, 255, 
                      (gpointer)&change_plane1, NULL, NULL);
  actor->time_start_animation = now + fast_rnd(20);
  actor->duration_animation = 30;
  scene->actors = g_slist_append(scene->actors, actor);

  actor = init_object(desktop_plugin, "town", "town.png", 0, 0, 10, 800, 480, 
                      TRUE, TRUE, 100, 255, 
                      (gpointer)&change_static_actor_with_corner, NULL, NULL);
  change_static_actor_with_corner(actor, desktop_plugin);
  scene->actors = g_slist_append(scene->actors, actor);

  actor = init_object(desktop_plugin, "wind", "", 0, 0, 5, 0, 0, 
                      FALSE, FALSE, 100, 255, 
                      (gpointer)&change_wind, NULL, NULL);
  change_wind(actor, desktop_plugin);
  scene->actors = g_slist_append(scene->actors, actor);

  actor1 = init_object(desktop_plugin, "signal_red", "red.png", 
                      486, 425, 10, 18, 38, 
                      FALSE, TRUE, 100, 255, NULL, NULL, NULL);
  //actor->time_start_animation = now + fast_rnd(30) + 10;  
  scene->actors = g_slist_append(scene->actors, actor1);
   
  actor2 = init_object(desktop_plugin, "signal_green", "green.png", 
                      486, 425, 10, 18, 38, 
                      TRUE, TRUE, 100, 255, NULL, NULL, NULL);
  //actor->time_start_animation = now + fast_rnd(30) + 10;  
  scene->actors = g_slist_append(scene->actors, actor2);
  child = g_ptr_array_sized_new(2);
  g_ptr_array_add(child, actor1);
  g_ptr_array_add(child, actor2);
  actor = init_object(desktop_plugin, "signal", "",
                      486, 425, 10, 18, 38,
                      FALSE, FALSE, 100, 255, 
                      (gpointer)&change_signal, NULL, child);
  actor->time_start_animation = now + fast_rnd(30) + 10;
  scene->actors = g_slist_append(scene->actors, actor);
    
    winds[0][0] = 389;
    winds[0][1] = 305;

    winds[1][0] = 373;
    winds[1][1] = 306;

    winds[2][0] = 355;
    winds[2][1] = 306;

    winds[3][0] = 356;
    winds[3][1] = 288;
    
    winds[4][0] = 337;
    winds[4][1] = 269;
    
    winds[5][0] = 372;
    winds[5][1] = 268;
  
    winds[6][0] = 372;
    winds[6][1] = 249;
    
    winds[7][0] = 388;
    winds[7][1] = 249;
    
    winds[8][0] = 387;
    winds[8][1] = 230;
    
    winds[9][0] = 372;
    winds[9][1] = 211;
    
    winds[10][0] = 355;
    winds[10][1] = 159;
    
    winds[11][0] = 335;
    winds[11][1] = 158;
    
    winds[12][0] = 386;
    winds[12][1] = 119;
  
    for (i=0; i<13; i++){
        actor = init_object(desktop_plugin, "window", "window.png", 
                            winds[i][0], winds[i][1], 10, 8, 9, 
                            FALSE, TRUE, 100, 255, 
                            (gpointer)&change_window1, NULL, NULL);
        //change_window1(actor, desktop_plugin);
        actor->time_start_animation = now + fast_rnd(30);
        scene->actors = g_slist_append(scene->actors, actor);

    }
    
    run_long_timeout(desktop_plugin);

}

void 
init_scene_theme(AWallpaperPlugin *desktop_plugin)
{
    void (*func)(gpointer);
    func = g_hash_table_lookup(desktop_plugin->priv->hash_scene_func, desktop_plugin->priv->theme);
    if (func){
        (*func)(desktop_plugin);
    }
}
