/* vim: set sw=4 ts=4 et: */
/*
 * This file is part of Live Wallpaper (livewp)
 * 
 * Copyright (C) 2010 Vlad Vasiliev
 * Copyright (C) 2010 Tanya Makova
 *       for the code
 * 
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 * 
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
*/
/*******************************************************************************/
#include "livewp-common.h"
#include "livewp-settings.h"
/*******************************************************************************/

void 
btn_setting_clicked(HildonButton *btn, gpointer data)
{
    Animation_WallpaperPrivate *priv = data;
    // open settings dialog
    fprintf(stderr, "btn setting clicked, %s\n", priv->theme);
    lw_main_settings(priv, NULL);
    fprintf(stderr, "btn setting clicked, %s\n", priv->theme);
}
void
btn_power_clicked(HildonButton *btn, gpointer data)
{
    const gchar *value; 
    value = hildon_button_get_value(btn);
    fprintf(stderr, "applet must be %s\n", value);
    if (!strcmp(value, "stop"))
        hildon_button_set_text(HILDON_BUTTON(btn), _("Start"), "start");
    else 
        hildon_button_set_text(HILDON_BUTTON(btn), _("Stop"), "stop");
}
int
main(int argc, char *argv[])
{
    GtkWidget *main_widget = NULL;
    GtkWidget *window;
    GtkWidget *btn_setting, *vbox, *btn_power;
    gint result;
    HildonProgram       *app;

    Animation_WallpaperPrivate *priv = g_new0 (Animation_WallpaperPrivate, 1);

#ifdef ENABLE_NLS
    setlocale(LC_ALL, "");
    bindtextdomain(GETTEXT_PACKAGE, LOCALEDIR);
    bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
    textdomain(GETTEXT_PACKAGE);
#endif
    /* Ininitializing */
    hildon_gtk_init (&argc, &argv);
    app = HILDON_PROGRAM (hildon_program_get_instance());
    g_set_application_name (PACKAGE);
 
    priv->osso = osso_initialize("org.maemo.livewp", VERSION, TRUE, NULL);
    if(!priv->osso){
        fprintf(stderr,"osso_initialize failed\n");
        return 1;
    }

    /* Load config */
    read_config(priv);

    /* Initialize DBUS */
    livewp_initialize_dbus(priv);

    /* Create Main GUI */
    main_widget = hildon_stackable_window_new ();
    gtk_window_set_title(GTK_WINDOW(main_widget), PACKAGE);

    vbox = gtk_vbox_new(FALSE, 5);
    btn_setting = hildon_button_new(HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT,
                               HILDON_BUTTON_ARRANGEMENT_HORIZONTAL);
    hildon_button_set_text(HILDON_BUTTON(btn_setting), _("Settings"), "");
    g_signal_connect(btn_setting, "clicked", G_CALLBACK(btn_setting_clicked), priv);
    //gtk_container_add(GTK_CONTAINER(main_widget), button);
    gtk_box_pack_start(vbox, btn_setting, FALSE, FALSE, 0);
    
    btn_power = hildon_button_new(HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT,
                               HILDON_BUTTON_ARRANGEMENT_HORIZONTAL);
    if (1)/* if applet started*/{
        hildon_button_set_text(HILDON_BUTTON(btn_power), _("Stop"), "stop");
    }
    else{ 
        hildon_button_set_text(HILDON_BUTTON(btn_power), _("Start"), "start");
    }
    g_signal_connect(btn_power, "clicked", G_CALLBACK(btn_power_clicked), priv);
    //gtk_container_add(GTK_CONTAINER(main_widget), button);
    gtk_box_pack_start(vbox, btn_power, FALSE, FALSE, 0);

    gtk_container_add(GTK_CONTAINER(main_widget), vbox);

    g_signal_connect(main_widget, "destroy", G_CALLBACK(gtk_main_quit), NULL);
    hildon_program_add_window(app, HILDON_WINDOW(main_widget));

    gtk_widget_show_all(GTK_WIDGET(main_widget));
    gtk_main();
    return 0;
}
