/* vim: set sw=4 ts=4 et: */
/*
 * This file is part of Live Wallpaper (livewp)
 * 
 * Copyright (C) 2010 Vlad Vasiliev
 * Copyright (C) 2010 Tanya Makova
 *       for the code
 * 
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 * 
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
*/
/*******************************************************************************/
#include "livewp-settings.h"
/*******************************************************************************/
void lw_about(void){

    GtkWidget *window = NULL,
    *vbox = NULL,
    *label_about = NULL;
    window = gtk_dialog_new();
    gtk_window_set_title(GTK_WINDOW(window), _("About"));
    gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_CENTER);
    gtk_window_set_modal(GTK_WINDOW(window), TRUE);
    vbox = gtk_vbox_new (FALSE, 5);
    label_about = gtk_label_new (_("Live Wallpaper\n Version 0.5 \n Copyright(c) 2010\n \
Tanya Makova\n Vlad Vasiliev\n \
Copyright(c) 2010 for design themes Berlin and Modern Vasya Bobrikov\n \
Copyright(c) 2010 for design theme Matrix Andrew Zhilin\n \
Translators:\n \
Finnish - Marko Vertainen\n \
Spain  - Alejandro López\n \
Russian - Tanya Makova \n \
          Vlad Vasiliev\n")); 
    gtk_box_pack_start (GTK_BOX (vbox), label_about, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->vbox),
                                   vbox, TRUE, TRUE, 0);
    gtk_widget_show (label_about);
    gtk_widget_show (vbox);
    gtk_widget_show (window);
    gtk_dialog_run(GTK_DIALOG(window));

}
/*******************************************************************************/
GtkWidget *
create_theme_selector (void)
{
      GtkWidget *selector;

      selector = hildon_touch_selector_new_text ();

      hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (selector), _("Berlin"));
      hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (selector), _("Modern"));
      hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (selector), _("Matrix"));
      return selector;
}
/*******************************************************************************/
GtkWidget *
create_themes_button (gchar *theme){

    GtkWidget *button;
    GtkWidget *selector;

    selector = create_theme_selector();
    button = hildon_picker_button_new (HILDON_SIZE_AUTO, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
    hildon_button_set_title (HILDON_BUTTON (button), _("Theme"));
    hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (button),
                                                       HILDON_TOUCH_SELECTOR (selector));
    if (theme) {
        if (!strcmp(theme, "Berlin")){
            hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (selector), 0, 0);
            hildon_button_set_value(HILDON_BUTTON(button), _("Berlin"));
        }
        if (!strcmp(theme, "Modern")){
            hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (selector), 0, 1);
            hildon_button_set_value(HILDON_BUTTON(button), _("Modern"));
        }
        if (!strcmp(theme, "Matrix")){
            hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (selector), 0, 2);
            hildon_button_set_value(HILDON_BUTTON(button), _("Matrix"));
        }

    }
    return button;
}

/*******************************************************************************/
GtkWidget *
create_rich_animation_button (gboolean active)
{
    GtkWidget *button;
    button = hildon_check_button_new (HILDON_SIZE_AUTO);
    gtk_button_set_label (GTK_BUTTON (button), _("Rich Animation"));
    hildon_check_button_set_active(HILDON_CHECK_BUTTON(button), active);
    return button;
}
/*******************************************************************************/
GtkWidget *
create_enable_button (gboolean active)
{
    GtkWidget *button;
    button = hildon_check_button_new (HILDON_SIZE_AUTO);
    gtk_button_set_label (GTK_BUTTON (button), _("Enable"));
    hildon_check_button_set_active(HILDON_CHECK_BUTTON(button), active);
    return button;
}

/*******************************************************************************/
void
show_settings(GtkWidget *widget, Animation_WallpaperPrivate *priv){
    lw_settings(priv, NULL);
}
/*******************************************************************************/
void 
lw_settings(Animation_WallpaperPrivate *priv, gpointer data){
    gint result;
    GtkWidget *window = NULL;
    GtkWidget *save_button;
    GtkWidget *theme_button;
    GtkWidget *enable_button;
    GtkWidget *rich_animation_button;

    window = gtk_dialog_new();

    gtk_window_set_title(GTK_WINDOW(window), _("Live Wallpaper Settings"));
    gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_CENTER);
    gtk_window_set_modal(GTK_WINDOW(window), TRUE);
    /* Create Enable button */
    enable_button = create_enable_button(check_applet_state()); 
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->vbox),
                                   enable_button, TRUE, TRUE, 5);
    /* Create Theme button */
    theme_button = create_themes_button(priv->theme);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->vbox),
                                   theme_button, TRUE, TRUE, 5);
    /* Create rich animation button */  
    rich_animation_button = create_rich_animation_button(priv->rich_animation);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->vbox),
                                   rich_animation_button, TRUE, TRUE, 5);
    gtk_widget_show (enable_button);
    gtk_widget_show (theme_button);
    gtk_widget_show (rich_animation_button);
    gtk_widget_show (window);
    gtk_dialog_add_button(GTK_DIALOG(window), _("About"), GTK_RESPONSE_NO);
    save_button = gtk_dialog_add_button(GTK_DIALOG(window), _("Save"), GTK_RESPONSE_YES);
    result = gtk_dialog_run(GTK_DIALOG(window));

    switch(result){
        case GTK_RESPONSE_YES:
            /* Check theme */
            if (hildon_button_get_value(HILDON_BUTTON (theme_button))){
                if (priv->theme)
                    g_free(priv->theme);
                if (!strcmp(hildon_button_get_value(HILDON_BUTTON (theme_button)), _("Berlin")))
                    priv->theme = g_strdup("Berlin");
                if (!strcmp(hildon_button_get_value(HILDON_BUTTON (theme_button)), _("Modern")))
                    priv->theme = g_strdup("Modern");
                if (!strcmp(hildon_button_get_value(HILDON_BUTTON (theme_button)), _("Matrix")))
                    priv->theme = g_strdup("Matrix");
            }
            /* Check rich animation */
            if (hildon_check_button_get_active (HILDON_CHECK_BUTTON(rich_animation_button)))
                priv->rich_animation = TRUE;
            else
                priv->rich_animation = FALSE;
            /* Save config */
            save_config(priv);
            /* action with applet */
            if (hildon_check_button_get_active (HILDON_CHECK_BUTTON(enable_button))){
                    if (!check_applet_state())
                        start_applet();
                    else
                        send_dbus_signal (priv,
                              LIVEWP_SIGNAL_INTERFACE,
                              LIVEWP_SIGNAL_PATH,
                              LIVEWP_RELOAD_CONFIG);
            }else
                    if (check_applet_state())
                        stop_applet();

            break;
        default:
        case GTK_RESPONSE_OK:
        break;
        case GTK_RESPONSE_NO:
            gtk_widget_destroy(window);
            window = NULL;
            lw_about();
        break;
    }
    if (window)
        gtk_widget_destroy(window);
}
/*******************************************************************************/
gboolean
check_applet_state(void){
    FILE    *file_in;
    gchar buffer[2048];
    gboolean result = FALSE;

    file_in = fopen("/home/user/.config/hildon-desktop/home.plugins","r");
    while (!feof(file_in)) {
            memset(buffer, 0, sizeof(buffer));
            fgets(buffer, sizeof(buffer) - 1, file_in);
            if (!strcmp(buffer, 
                        "X-Desktop-File=/usr/share/applications/hildon-home/livewp-home-widget.desktop\n")){
                result = TRUE;
                break;
            }
   }
   fclose(file_in);

    return result;
}
/*******************************************************************************/
void
start_applet(void){
    FILE    *file_out;

    file_out = fopen("/home/user/.config/hildon-desktop/home.plugins","w+");
    if (file_out){
        fputs("\n", file_out);
        fputs("[livewp-home-widget.desktop-0]\n",file_out);
        fputs("X-Desktop-File=/usr/share/applications/hildon-home/livewp-home-widget.desktop\n",file_out);
        fclose(file_out);
    }
}
/*******************************************************************************/
void
stop_applet(void){
    FILE    *file_in;
    FILE    *file_out;
    gchar buffer[2048];

    file_in = fopen("/home/user/.config/hildon-desktop/home.plugins","r");
    file_out = fopen("/tmp/livewallpaper.plugins","w");
    if (file_in && file_out){
        while (!feof(file_in)) {
            memset(buffer, 0, sizeof(buffer));
            fgets(buffer, sizeof(buffer) - 1, file_in);
            if (strcmp(buffer, "[livewp-home-widget.desktop-0]\n") &&
                strcmp(buffer, "X-Desktop-File=/usr/share/applications/hildon-home/livewp-home-widget.desktop\n"))
                fputs(buffer, file_out);
        }
        fclose(file_out);
        fclose(file_in);
        file_in = fopen("/tmp/livewallpaper.plugins","r");
        file_out = fopen("/home/user/.config/hildon-desktop/home.plugins","w");
        if (file_in && file_out){
            while (!feof(file_in)){
                memset(buffer, 0, sizeof(buffer));
                fgets(buffer, sizeof(buffer) - 1, file_in);
                fputs(buffer, file_out);
            }
            fclose(file_out);
            fclose(file_in);
            unlink ("/tmp/livewallpaper.plugins");
        }
    }
}
