/*
 * radiolist.cpp -- Show the list of available radio allowing user to select one
 *
 * Copyright (C) 2010 Andrea Grandi
 * Authors: Andrea Grandi <a.grandi@gmail.com>
 *
 * This file is part of LastGo and is published under the GNU GPLv2
 * See the README file for more details.
 */

#include "radiolist.h"
#include "ui_radiolist.h"
#include <QDebug>

RadioList::RadioList(QString user, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::RadioList)
{
    ui->setupUi(this);

    username = user;
    initializeRadioList();
    initializeListView();

    connect(ui->radioList, SIGNAL(itemActivated(QListWidgetItem*)), this, SLOT(radioSelected(QListWidgetItem*)));
    connect(ui->radioList, SIGNAL(itemClicked(QListWidgetItem*)), this, SLOT(radioSelected(QListWidgetItem*)));
}

RadioList::~RadioList()
{
    delete ui;
}

void RadioList::initializeRadioList()
{
    QMap<QString, QString> libRadio;
    libRadio["radio_name"] = username + "\'s Library";
    libRadio["radio_url"] = "lastfm://user/" + username + "/personal";

    QMap<QString, QString> neigRadio;
    neigRadio["radio_name"] = username + "\'s Neighbours";
    neigRadio["radio_url"] = "lastfm://user/" + username + "/neighbours";

    QMap<QString, QString> lovedRadio;
    lovedRadio["radio_name"] = username + "\'s Loved";
    lovedRadio["radio_url"] = "lastfm://user/" + username + "/loved";

    QMap<QString, QString> reccRadio;
    reccRadio["radio_name"] = username + "\'s Recommendation";
    reccRadio["radio_url"] = "lastfm://user/" + username + "/recommended";

    radios.append(libRadio);
    radios.append(neigRadio);
    radios.append(lovedRadio);
    radios.append(reccRadio);
}

void RadioList::initializeListView()
{
    for(int i = 0; i < radios.count(); i++)
    {
        ui->radioList->addItem(radios.at(i)["radio_name"]);
    }
}

void RadioList::radioSelected(QListWidgetItem *item)
{
    int position = item->listWidget()->row(item);
    radioName = radios.at(position)["radio_name"];
    radioUrl = radios.at(position)["radio_url"];
    this->close();
}
