/**************************************************************************
 *  Kchmviewer for Maemo5 - a CHM file viewer with broad language support *
 *  Copyright (C) 2009-2010 Max Kiva , max.kiva@gmail.com                 *
 *                                                                        *
 *  This program is free software: you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation, either version 3 of the License, or     *
 *  (at your option) any later version.                                   *
 *															                                  	      *
 *  This program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU General Public License     *
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 **************************************************************************/
#ifndef __CONTENTS_WIDGET_H__
#define __CONTENTS_WIDGET_H__

#include <qwidget.h>
#include <qlistwidget.h>
#include "chmtypes.h"


class ContentsWidget : public QWidget
{
  Q_OBJECT

  public:
    ContentsWidget( QWidget* parent = 0 );
    virtual ~ContentsWidget();

    void populate( const ChmEntryList& lst );
    int currentRow() const { return contents_->currentRow(); }

  signals:
    void selectedContentsItem();

  public slots:
    void contentsItemSelected();

  private:

     QListWidget* contents_;

};


#endif
