/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.ConstructKeys;
import com.sun.crypto.provider.SunJCE;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import java.util.Locale;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import sun.security.jca.Providers;
import sun.security.rsa.RSACore;
import sun.security.rsa.RSAKeyFactory;
import sun.security.rsa.RSAPadding;

public final class RSACipher
extends CipherSpi {
    private static final byte[] B0 = new byte[0];
    private static final int MODE_ENCRYPT = 1;
    private static final int MODE_DECRYPT = 2;
    private static final int MODE_SIGN = 3;
    private static final int MODE_VERIFY = 4;
    private static final String PAD_NONE = "NoPadding";
    private static final String PAD_PKCS1 = "PKCS1Padding";
    private static final String PAD_OAEP_MGF1 = "OAEP";
    private int mode;
    private String paddingType;
    private RSAPadding padding;
    private OAEPParameterSpec spec = null;
    private byte[] buffer;
    private int bufOfs;
    private int outputSize;
    private RSAPublicKey publicKey;
    private RSAPrivateKey privateKey;
    private String oaepHashAlgorithm = "SHA-1";

    public RSACipher() {
        SunJCE.ensureIntegrity(this.getClass());
        this.paddingType = PAD_PKCS1;
    }

    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if (!mode.equalsIgnoreCase("ECB")) {
            throw new NoSuchAlgorithmException("Unsupported mode " + mode);
        }
    }

    protected void engineSetPadding(String paddingName) throws NoSuchPaddingException {
        if (paddingName.equalsIgnoreCase(PAD_NONE)) {
            this.paddingType = PAD_NONE;
        } else if (paddingName.equalsIgnoreCase(PAD_PKCS1)) {
            this.paddingType = PAD_PKCS1;
        } else {
            String lowerPadding = paddingName.toLowerCase(Locale.ENGLISH);
            if (lowerPadding.equals("oaeppadding")) {
                this.paddingType = PAD_OAEP_MGF1;
            } else if (lowerPadding.startsWith("oaepwith") && lowerPadding.endsWith("andmgf1padding")) {
                this.paddingType = PAD_OAEP_MGF1;
                this.oaepHashAlgorithm = paddingName.substring(8, paddingName.length() - 14);
                if (Providers.getProviderList().getService("MessageDigest", this.oaepHashAlgorithm) == null) {
                    throw new NoSuchPaddingException("MessageDigest not available for " + paddingName);
                }
            } else {
                throw new NoSuchPaddingException("Padding " + paddingName + " not supported");
            }
        }
    }

    protected int engineGetBlockSize() {
        return 0;
    }

    protected int engineGetOutputSize(int inputLen) {
        return this.outputSize;
    }

    protected byte[] engineGetIV() {
        return null;
    }

    protected AlgorithmParameters engineGetParameters() {
        if (this.spec != null) {
            try {
                AlgorithmParameters params = AlgorithmParameters.getInstance(PAD_OAEP_MGF1, "SunJCE");
                params.init(this.spec);
                return params;
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new RuntimeException("Cannot find OAEP  AlgorithmParameters implementation in SunJCE provider");
            }
            catch (NoSuchProviderException nspe) {
                throw new RuntimeException("Cannot find SunJCE provider");
            }
            catch (InvalidParameterSpecException ipse) {
                throw new RuntimeException("OAEPParameterSpec not supported");
            }
        }
        return null;
    }

    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.init(opmode, key, random, null);
        }
        catch (InvalidAlgorithmParameterException iape) {
            InvalidKeyException ike = new InvalidKeyException("Wrong parameters");
            ike.initCause(iape);
            throw ike;
        }
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.init(opmode, key, random, params);
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params == null) {
            this.init(opmode, key, random, null);
        } else {
            try {
                OAEPParameterSpec spec = params.getParameterSpec(OAEPParameterSpec.class);
                this.init(opmode, key, random, spec);
            }
            catch (InvalidParameterSpecException ipse) {
                InvalidAlgorithmParameterException iape = new InvalidAlgorithmParameterException("Wrong parameter");
                iape.initCause(ipse);
                throw iape;
            }
        }
    }

    private void init(int opmode, Key key, SecureRandom random, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        int n;
        boolean encrypt;
        switch (opmode) {
            case 1: 
            case 3: {
                encrypt = true;
                break;
            }
            case 2: 
            case 4: {
                encrypt = false;
                break;
            }
            default: {
                throw new InvalidKeyException("Unknown mode: " + opmode);
            }
        }
        RSAKey rsaKey = RSAKeyFactory.toRSAKey(key);
        if (key instanceof RSAPublicKey) {
            this.mode = encrypt ? 1 : 4;
            this.publicKey = (RSAPublicKey)key;
            this.privateKey = null;
        } else {
            this.mode = encrypt ? 3 : 2;
            this.privateKey = (RSAPrivateKey)key;
            this.publicKey = null;
        }
        this.outputSize = n = RSACore.getByteLength(rsaKey.getModulus());
        this.bufOfs = 0;
        if (this.paddingType == PAD_NONE) {
            if (params != null) {
                throw new InvalidAlgorithmParameterException("Parameters not supported");
            }
            this.padding = RSAPadding.getInstance(3, n, random);
            this.buffer = new byte[n];
        } else if (this.paddingType == PAD_PKCS1) {
            if (params != null) {
                throw new InvalidAlgorithmParameterException("Parameters not supported");
            }
            int blockType = this.mode <= 2 ? 2 : 1;
            this.padding = RSAPadding.getInstance(blockType, n, random);
            if (encrypt) {
                int k = this.padding.getMaxDataSize();
                this.buffer = new byte[k];
            } else {
                this.buffer = new byte[n];
            }
        } else {
            OAEPParameterSpec myParams;
            if (this.mode == 3 || this.mode == 4) {
                throw new InvalidKeyException("OAEP cannot be used to sign or verify signatures");
            }
            if (params != null) {
                if (!(params instanceof OAEPParameterSpec)) {
                    throw new InvalidAlgorithmParameterException("Wrong Parameters for OAEP Padding");
                }
                myParams = (OAEPParameterSpec)params;
            } else {
                myParams = new OAEPParameterSpec(this.oaepHashAlgorithm, "MGF1", MGF1ParameterSpec.SHA1, PSource.PSpecified.DEFAULT);
            }
            this.padding = RSAPadding.getInstance(4, n, random, myParams);
            if (encrypt) {
                int k = this.padding.getMaxDataSize();
                this.buffer = new byte[k];
            } else {
                this.buffer = new byte[n];
            }
        }
    }

    private void update(byte[] in, int inOfs, int inLen) {
        if (inLen == 0 || in == null) {
            return;
        }
        if (this.bufOfs + inLen > this.buffer.length) {
            this.bufOfs = this.buffer.length + 1;
            return;
        }
        System.arraycopy(in, inOfs, this.buffer, this.bufOfs, inLen);
        this.bufOfs += inLen;
    }

    private byte[] doFinal() throws BadPaddingException, IllegalBlockSizeException {
        if (this.bufOfs > this.buffer.length) {
            throw new IllegalBlockSizeException("Data must not be longer than " + this.buffer.length + " bytes");
        }
        try {
            switch (this.mode) {
                case 3: {
                    byte[] data = this.padding.pad(this.buffer, 0, this.bufOfs);
                    byte[] byArray = RSACore.rsa(data, this.privateKey);
                    return byArray;
                }
                case 4: {
                    byte[] verifyBuffer = RSACore.convert(this.buffer, 0, this.bufOfs);
                    byte[] data = RSACore.rsa(verifyBuffer, this.publicKey);
                    byte[] byArray = this.padding.unpad(data);
                    return byArray;
                }
                case 1: {
                    byte[] data = this.padding.pad(this.buffer, 0, this.bufOfs);
                    byte[] byArray = RSACore.rsa(data, this.publicKey);
                    return byArray;
                }
                case 2: {
                    byte[] decryptBuffer = RSACore.convert(this.buffer, 0, this.bufOfs);
                    byte[] data = RSACore.rsa(decryptBuffer, this.privateKey);
                    byte[] byArray = this.padding.unpad(data);
                    return byArray;
                }
            }
            throw new AssertionError((Object)"Internal error");
        }
        finally {
            this.bufOfs = 0;
        }
    }

    protected byte[] engineUpdate(byte[] in, int inOfs, int inLen) {
        this.update(in, inOfs, inLen);
        return B0;
    }

    protected int engineUpdate(byte[] in, int inOfs, int inLen, byte[] out, int outOfs) {
        this.update(in, inOfs, inLen);
        return 0;
    }

    protected byte[] engineDoFinal(byte[] in, int inOfs, int inLen) throws BadPaddingException, IllegalBlockSizeException {
        this.update(in, inOfs, inLen);
        return this.doFinal();
    }

    protected int engineDoFinal(byte[] in, int inOfs, int inLen, byte[] out, int outOfs) throws ShortBufferException, BadPaddingException, IllegalBlockSizeException {
        if (this.outputSize > out.length - outOfs) {
            throw new ShortBufferException("Need " + this.outputSize + " bytes for output");
        }
        this.update(in, inOfs, inLen);
        byte[] result = this.doFinal();
        int n = result.length;
        System.arraycopy(result, 0, out, outOfs, n);
        return n;
    }

    protected byte[] engineWrap(Key key) throws InvalidKeyException, IllegalBlockSizeException {
        byte[] encoded = key.getEncoded();
        if (encoded == null || encoded.length == 0) {
            throw new InvalidKeyException("Could not obtain encoded key");
        }
        if (encoded.length > this.buffer.length) {
            throw new InvalidKeyException("Key is too long for wrapping");
        }
        this.update(encoded, 0, encoded.length);
        try {
            return this.doFinal();
        }
        catch (BadPaddingException e) {
            throw new InvalidKeyException("Wrapping failed", e);
        }
    }

    protected Key engineUnwrap(byte[] wrappedKey, String algorithm, int type) throws InvalidKeyException, NoSuchAlgorithmException {
        if (wrappedKey.length > this.buffer.length) {
            throw new InvalidKeyException("Key is too long for unwrapping");
        }
        this.update(wrappedKey, 0, wrappedKey.length);
        try {
            byte[] encoded = this.doFinal();
            return ConstructKeys.constructKey(encoded, algorithm, type);
        }
        catch (BadPaddingException e) {
            throw new InvalidKeyException("Unwrapping failed", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new InvalidKeyException("Unwrapping failed", e);
        }
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        RSAKey rsaKey = RSAKeyFactory.toRSAKey(key);
        return rsaKey.getModulus().bitLength();
    }
}

