/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.io.InputStream;
import javax.net.ssl.SSLException;
import sun.security.ssl.HandshakeHash;
import sun.security.ssl.InputRecord;

class HandshakeInStream
extends InputStream {
    InputRecord r = new InputRecord();

    HandshakeInStream(HandshakeHash handshakeHash) {
        this.r.setHandshakeHash(handshakeHash);
    }

    public int available() {
        return this.r.available();
    }

    public int read() throws IOException {
        int n = this.r.read();
        if (n == -1) {
            throw new SSLException("Unexpected end of handshake data");
        }
        return n;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int n = this.r.read(b, off, len);
        if (n != len) {
            throw new SSLException("Unexpected end of handshake data");
        }
        return n;
    }

    public long skip(long n) throws IOException {
        return this.r.skip(n);
    }

    public void mark(int readlimit) {
        this.r.mark(readlimit);
    }

    public void reset() {
        this.r.reset();
    }

    public boolean markSupported() {
        return true;
    }

    void incomingRecord(InputRecord in) throws IOException {
        this.r.queueHandshake(in);
    }

    void digestNow() {
        this.r.doHashes();
    }

    void ignore(int n) {
        this.r.ignore(n);
    }

    int getInt8() throws IOException {
        return this.read();
    }

    int getInt16() throws IOException {
        return this.getInt8() << 8 | this.getInt8();
    }

    int getInt24() throws IOException {
        return this.getInt8() << 16 | this.getInt8() << 8 | this.getInt8();
    }

    int getInt32() throws IOException {
        return this.getInt8() << 24 | this.getInt8() << 16 | this.getInt8() << 8 | this.getInt8();
    }

    byte[] getBytes8() throws IOException {
        int len = this.getInt8();
        byte[] b = new byte[len];
        this.read(b, 0, len);
        return b;
    }

    byte[] getBytes16() throws IOException {
        int len = this.getInt16();
        byte[] b = new byte[len];
        this.read(b, 0, len);
        return b;
    }

    byte[] getBytes24() throws IOException {
        int len = this.getInt24();
        byte[] b = new byte[len];
        this.read(b, 0, len);
        return b;
    }
}

