/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.io.PrintStream;
import java.math.BigInteger;
import sun.security.ssl.Debug;
import sun.security.ssl.HandshakeInStream;
import sun.security.ssl.HandshakeMessage;
import sun.security.ssl.HandshakeOutStream;

final class DHClientKeyExchange
extends HandshakeMessage {
    private byte[] dh_Yc;

    int messageType() {
        return 16;
    }

    BigInteger getClientPublicKey() {
        return new BigInteger(1, this.dh_Yc);
    }

    DHClientKeyExchange(BigInteger publicKey) {
        this.dh_Yc = DHClientKeyExchange.toByteArray(publicKey);
    }

    DHClientKeyExchange() {
        this.dh_Yc = null;
    }

    DHClientKeyExchange(HandshakeInStream input) throws IOException {
        this.dh_Yc = input.getBytes16();
    }

    int messageLength() {
        if (this.dh_Yc == null) {
            return 0;
        }
        return this.dh_Yc.length + 2;
    }

    void send(HandshakeOutStream s) throws IOException {
        s.putBytes16(this.dh_Yc);
    }

    void print(PrintStream s) throws IOException {
        s.println("*** ClientKeyExchange, DH");
        if (debug != null && Debug.isOn("verbose")) {
            Debug.println(s, "DH Public key", this.dh_Yc);
        }
    }
}

