/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.Surrogate;

public abstract class UnicodeEncoder
extends CharsetEncoder {
    protected static final char BYTE_ORDER_MARK = '\ufeff';
    protected static final char REVERSED_MARK = '\ufffe';
    protected static final int BIG = 0;
    protected static final int LITTLE = 1;
    private int byteOrder;
    private boolean usesMark;
    private boolean needsMark;
    private final Surrogate.Parser sgp;

    protected UnicodeEncoder(Charset cs, int bo, boolean m) {
        byte[] byArray;
        float f = m ? 4.0f : 2.0f;
        if (bo == 0) {
            byte[] byArray2 = new byte[2];
            byArray2[0] = -1;
            byArray = byArray2;
            byArray2[1] = -3;
        } else {
            byte[] byArray3 = new byte[2];
            byArray3[0] = -3;
            byArray = byArray3;
            byArray3[1] = -1;
        }
        super(cs, 2.0f, f, byArray);
        this.sgp = new Surrogate.Parser();
        this.usesMark = this.needsMark = m;
        this.byteOrder = bo;
    }

    private void put(char c, ByteBuffer dst) {
        if (this.byteOrder == 0) {
            dst.put((byte)(c >> 8));
            dst.put((byte)(c & 0xFF));
        } else {
            dst.put((byte)(c & 0xFF));
            dst.put((byte)(c >> 8));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CoderResult encodeLoop(CharBuffer src, ByteBuffer dst) {
        int mark = src.position();
        if (this.needsMark) {
            if (dst.remaining() < 2) {
                return CoderResult.OVERFLOW;
            }
            this.put('\ufeff', dst);
            this.needsMark = false;
        }
        try {
            while (src.hasRemaining()) {
                char c = src.get();
                if (!Surrogate.is(c)) {
                    if (dst.remaining() < 2) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    ++mark;
                    this.put(c, dst);
                    continue;
                }
                int d = this.sgp.parse(c, src);
                if (d < 0) {
                    CoderResult coderResult = this.sgp.error();
                    return coderResult;
                }
                if (dst.remaining() < 4) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                mark += 2;
                this.put(Surrogate.high(d), dst);
                this.put(Surrogate.low(d), dst);
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            src.position(mark);
        }
    }

    protected void implReset() {
        this.needsMark = this.usesMark;
    }

    public boolean canEncode(char c) {
        return !Surrogate.is(c);
    }
}

