/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public class ChunkedOutputStream
extends PrintStream {
    static final int DEFAULT_CHUNK_SIZE = 4096;
    private byte[] buf;
    private int count;
    private PrintStream out;
    private int preferredChunkSize;
    static final int MAX_BUF_SIZE = 10240;

    private int headerSize(int size) {
        return 2 + Integer.toHexString(size).length();
    }

    public ChunkedOutputStream(PrintStream o) {
        this(o, 4096);
    }

    public ChunkedOutputStream(PrintStream o, int size) {
        super(o);
        this.out = o;
        if (size <= 0) {
            size = 4096;
        }
        if (size > 0) {
            int adjusted_size = size - this.headerSize(size);
            if (adjusted_size + this.headerSize(adjusted_size) < size) {
                ++adjusted_size;
            }
            size = adjusted_size;
        }
        this.preferredChunkSize = size > 0 ? size : 4096 - this.headerSize(4096);
        this.buf = new byte[this.preferredChunkSize + 32];
    }

    private void flush(byte[] buf, boolean flushAll) {
        this.flush(buf, flushAll, 0);
    }

    private void flush(byte[] buf, boolean flushAll, int offset) {
        do {
            int chunkSize;
            if (this.count < this.preferredChunkSize) {
                if (!flushAll) break;
                chunkSize = this.count;
            } else {
                chunkSize = this.preferredChunkSize;
            }
            byte[] bytes = null;
            try {
                bytes = Integer.toHexString(chunkSize).getBytes("US-ASCII");
            }
            catch (UnsupportedEncodingException e) {
                throw new InternalError(e.getMessage());
            }
            this.out.write(bytes, 0, bytes.length);
            this.out.write(13);
            this.out.write(10);
            if (chunkSize > 0) {
                this.out.write(buf, offset, chunkSize);
                this.out.write(13);
                this.out.write(10);
            }
            this.out.flush();
            if (this.checkError()) break;
            if (chunkSize <= 0) continue;
            this.count -= chunkSize;
            offset += chunkSize;
        } while (this.count > 0);
        if (!this.checkError() && this.count > 0) {
            System.arraycopy(buf, offset, this.buf, 0, this.count);
        }
    }

    public boolean checkError() {
        return this.out.checkError();
    }

    private void checkFlush() {
        if (this.count >= this.preferredChunkSize) {
            this.flush(this.buf, false);
        }
    }

    private void ensureOpen() {
        if (this.out == null) {
            this.setError();
        }
    }

    public synchronized void write(byte[] b, int off, int len) {
        this.ensureOpen();
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        if (len > 10240) {
            int l = this.preferredChunkSize - this.count;
            if (l > 0) {
                System.arraycopy(b, off, this.buf, this.count, l);
                this.count = this.preferredChunkSize;
                this.flush(this.buf, false);
            }
            this.count = len - l;
            this.flush(b, false, l + off);
        } else {
            int newcount = this.count + len;
            if (newcount > this.buf.length) {
                byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
                System.arraycopy(this.buf, 0, newbuf, 0, this.count);
                this.buf = newbuf;
            }
            System.arraycopy(b, off, this.buf, this.count, len);
            this.count = newcount;
            this.checkFlush();
        }
    }

    public synchronized void write(int b) {
        this.ensureOpen();
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        this.buf[this.count] = (byte)b;
        this.count = newcount;
        this.checkFlush();
    }

    public synchronized void reset() {
        this.count = 0;
    }

    public int size() {
        return this.count;
    }

    public synchronized void close() {
        this.ensureOpen();
        if (this.count > 0) {
            this.flush(this.buf, true);
        }
        this.flush(this.buf, true);
        this.out = null;
    }

    public synchronized void flush() {
        this.ensureOpen();
        if (this.count > 0) {
            this.flush(this.buf, true);
        }
    }
}

