/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pisces;

import java.util.Arrays;

final class Helpers {
    private Helpers() {
        throw new Error("This is a non instantiable class");
    }

    static boolean within(float x, float y, float err) {
        float d = y - x;
        return d <= err && d >= -err;
    }

    static boolean within(double x, double y, double err) {
        double d = y - x;
        return d <= err && d >= -err;
    }

    static int quadraticRoots(float a, float b, float c, float[] zeroes, int off) {
        int ret = off;
        if (a != 0.0f) {
            float dis = b * b - 4.0f * a * c;
            if (dis > 0.0f) {
                float sqrtDis = (float)Math.sqrt(dis);
                if (b >= 0.0f) {
                    zeroes[ret++] = 2.0f * c / (-b - sqrtDis);
                    zeroes[ret++] = (-b - sqrtDis) / (2.0f * a);
                } else {
                    zeroes[ret++] = (-b + sqrtDis) / (2.0f * a);
                    zeroes[ret++] = 2.0f * c / (-b + sqrtDis);
                }
            } else if (dis == 0.0f) {
                float t = -b / (2.0f * a);
                zeroes[ret++] = t;
            }
        } else if (b != 0.0f) {
            float t = -c / b;
            zeroes[ret++] = t;
        }
        return ret - off;
    }

    static int cubicRootsInAB(float a, float b, float c, float d, float[] pts, int off, float E, float A, float B) {
        if (a == 0.0f) {
            return Helpers.quadraticRoots(b, c, d, pts, off);
        }
        float da = 3.0f * a;
        float db = 2.0f * b;
        int numCritPts = Helpers.quadraticRoots(da, db, c, pts, off + 1);
        if ((numCritPts = Helpers.filterOutNotInAB(pts, off + 1, numCritPts, A, B) - off - 1) == 2 && pts[off + 1] > pts[off + 2]) {
            float tmp = pts[off + 1];
            pts[off + 1] = pts[off + 2];
            pts[off + 2] = tmp;
        }
        int ret = off;
        pts[off] = A;
        pts[off + numCritPts + 1] = B;
        numCritPts += 2;
        float x0 = pts[off];
        float fx0 = Helpers.evalCubic(a, b, c, d, x0);
        for (int i = off; i < off + numCritPts - 1; ++i) {
            float x1 = pts[i + 1];
            float fx1 = Helpers.evalCubic(a, b, c, d, x1);
            if (fx0 == 0.0f) {
                pts[ret++] = x0;
            } else if (fx1 * fx0 < 0.0f) {
                pts[ret++] = Helpers.CubicNewton(a, b, c, d, x0 + fx0 * (x1 - x0) / (fx0 - fx1), E);
            }
            x0 = x1;
            fx0 = fx1;
        }
        return ret - off;
    }

    static float CubicNewton(float a, float b, float c, float d, float x0, float err) {
        float x1;
        int itlimit = 10;
        float fx0 = Helpers.evalCubic(a, b, c, d, x0);
        for (int count = 0; !(Math.abs((x1 = x0 - fx0 / Helpers.evalCubic(0.0f, 3.0f * a, 2.0f * b, c, x0)) - x0) < err * Math.abs(x1 + x0)) && count != 10; ++count) {
            x0 = x1;
            fx0 = Helpers.evalCubic(a, b, c, d, x0);
        }
        return x1;
    }

    static void fillWithIdxes(float[] data, int[] idxes) {
        if (idxes.length > 0) {
            idxes[0] = 0;
            for (int i = 1; i < idxes.length; ++i) {
                idxes[i] = idxes[i - 1] + (int)data[idxes[i - 1]];
            }
        }
    }

    static void fillWithIdxes(int[] idxes, int inc) {
        if (idxes.length > 0) {
            idxes[0] = 0;
            for (int i = 1; i < idxes.length; ++i) {
                idxes[i] = idxes[i - 1] + inc;
            }
        }
    }

    static float[] widenArray(float[] in, int cursize, int numToAdd) {
        if (in == null) {
            return new float[5 * numToAdd];
        }
        if (in.length >= cursize + numToAdd) {
            return in;
        }
        return Arrays.copyOf(in, 2 * (cursize + numToAdd));
    }

    static int[] widenArray(int[] in, int cursize, int numToAdd) {
        if (in.length >= cursize + numToAdd) {
            return in;
        }
        return Arrays.copyOf(in, 2 * (cursize + numToAdd));
    }

    static float evalCubic(float a, float b, float c, float d, float t) {
        return t * (t * (t * a + b) + c) + d;
    }

    static float evalQuad(float a, float b, float c, float t) {
        return t * (t * a + b) + c;
    }

    static int filterOutNotInAB(float[] nums, int off, int len, float a, float b) {
        int ret = off;
        for (int i = off; i < off + len; ++i) {
            if (!(nums[i] > a) || !(nums[i] < b)) continue;
            nums[ret++] = nums[i];
        }
        return ret;
    }

    static float polyLineLength(float[] poly, int off, int nCoords) {
        assert (nCoords % 2 == 0 && poly.length >= off + nCoords) : "";
        float acc = 0.0f;
        for (int i = off + 2; i < off + nCoords; i += 2) {
            acc += Helpers.linelen(poly[i], poly[i + 1], poly[i - 2], poly[i - 1]);
        }
        return acc;
    }

    static float linelen(float x1, float y1, float x2, float y2) {
        return (float)Math.hypot(x2 - x1, y2 - y1);
    }

    static void subdivide(float[] src, int srcoff, float[] left, int leftoff, float[] right, int rightoff, int type) {
        switch (type) {
            case 6: {
                Helpers.subdivideQuad(src, srcoff, left, leftoff, right, rightoff);
                break;
            }
            case 8: {
                Helpers.subdivideCubic(src, srcoff, left, leftoff, right, rightoff);
                break;
            }
            default: {
                throw new InternalError("Unsupported curve type");
            }
        }
    }

    static void isort(float[] a, int off, int len) {
        for (int i = off + 1; i < off + len; ++i) {
            float ai = a[i];
            for (int j = i - 1; j >= off && a[j] > ai; --j) {
                a[j + 1] = a[j];
            }
            a[j + 1] = ai;
        }
    }

    static void subdivideCubic(float[] src, int srcoff, float[] left, int leftoff, float[] right, int rightoff) {
        float x1 = src[srcoff + 0];
        float y1 = src[srcoff + 1];
        float ctrlx1 = src[srcoff + 2];
        float ctrly1 = src[srcoff + 3];
        float ctrlx2 = src[srcoff + 4];
        float ctrly2 = src[srcoff + 5];
        float x2 = src[srcoff + 6];
        float y2 = src[srcoff + 7];
        if (left != null) {
            left[leftoff + 0] = x1;
            left[leftoff + 1] = y1;
        }
        if (right != null) {
            right[rightoff + 6] = x2;
            right[rightoff + 7] = y2;
        }
        x1 = (x1 + ctrlx1) / 2.0f;
        y1 = (y1 + ctrly1) / 2.0f;
        x2 = (x2 + ctrlx2) / 2.0f;
        y2 = (y2 + ctrly2) / 2.0f;
        float centerx = (ctrlx1 + ctrlx2) / 2.0f;
        float centery = (ctrly1 + ctrly2) / 2.0f;
        ctrlx1 = (x1 + centerx) / 2.0f;
        ctrly1 = (y1 + centery) / 2.0f;
        ctrlx2 = (x2 + centerx) / 2.0f;
        ctrly2 = (y2 + centery) / 2.0f;
        centerx = (ctrlx1 + ctrlx2) / 2.0f;
        centery = (ctrly1 + ctrly2) / 2.0f;
        if (left != null) {
            left[leftoff + 2] = x1;
            left[leftoff + 3] = y1;
            left[leftoff + 4] = ctrlx1;
            left[leftoff + 5] = ctrly1;
            left[leftoff + 6] = centerx;
            left[leftoff + 7] = centery;
        }
        if (right != null) {
            right[rightoff + 0] = centerx;
            right[rightoff + 1] = centery;
            right[rightoff + 2] = ctrlx2;
            right[rightoff + 3] = ctrly2;
            right[rightoff + 4] = x2;
            right[rightoff + 5] = y2;
        }
    }

    static void subdivideCubicAt(float t, float[] src, int srcoff, float[] left, int leftoff, float[] right, int rightoff) {
        float x1 = src[srcoff + 0];
        float y1 = src[srcoff + 1];
        float ctrlx1 = src[srcoff + 2];
        float ctrly1 = src[srcoff + 3];
        float ctrlx2 = src[srcoff + 4];
        float ctrly2 = src[srcoff + 5];
        float x2 = src[srcoff + 6];
        float y2 = src[srcoff + 7];
        if (left != null) {
            left[leftoff + 0] = x1;
            left[leftoff + 1] = y1;
        }
        if (right != null) {
            right[rightoff + 6] = x2;
            right[rightoff + 7] = y2;
        }
        x1 += t * (ctrlx1 - x1);
        y1 += t * (ctrly1 - y1);
        x2 = ctrlx2 + t * (x2 - ctrlx2);
        y2 = ctrly2 + t * (y2 - ctrly2);
        float centerx = ctrlx1 + t * (ctrlx2 - ctrlx1);
        float centery = ctrly1 + t * (ctrly2 - ctrly1);
        ctrlx1 = x1 + t * (centerx - x1);
        ctrly1 = y1 + t * (centery - y1);
        ctrlx2 = centerx + t * (x2 - centerx);
        ctrly2 = centery + t * (y2 - centery);
        centerx = ctrlx1 + t * (ctrlx2 - ctrlx1);
        centery = ctrly1 + t * (ctrly2 - ctrly1);
        if (left != null) {
            left[leftoff + 2] = x1;
            left[leftoff + 3] = y1;
            left[leftoff + 4] = ctrlx1;
            left[leftoff + 5] = ctrly1;
            left[leftoff + 6] = centerx;
            left[leftoff + 7] = centery;
        }
        if (right != null) {
            right[rightoff + 0] = centerx;
            right[rightoff + 1] = centery;
            right[rightoff + 2] = ctrlx2;
            right[rightoff + 3] = ctrly2;
            right[rightoff + 4] = x2;
            right[rightoff + 5] = y2;
        }
    }

    static void subdivideQuad(float[] src, int srcoff, float[] left, int leftoff, float[] right, int rightoff) {
        float x1 = src[srcoff + 0];
        float y1 = src[srcoff + 1];
        float ctrlx = src[srcoff + 2];
        float ctrly = src[srcoff + 3];
        float x2 = src[srcoff + 4];
        float y2 = src[srcoff + 5];
        if (left != null) {
            left[leftoff + 0] = x1;
            left[leftoff + 1] = y1;
        }
        if (right != null) {
            right[rightoff + 4] = x2;
            right[rightoff + 5] = y2;
        }
        x1 = (x1 + ctrlx) / 2.0f;
        y1 = (y1 + ctrly) / 2.0f;
        x2 = (x2 + ctrlx) / 2.0f;
        y2 = (y2 + ctrly) / 2.0f;
        ctrlx = (x1 + x2) / 2.0f;
        ctrly = (y1 + y2) / 2.0f;
        if (left != null) {
            left[leftoff + 2] = x1;
            left[leftoff + 3] = y1;
            left[leftoff + 4] = ctrlx;
            left[leftoff + 5] = ctrly;
        }
        if (right != null) {
            right[rightoff + 0] = ctrlx;
            right[rightoff + 1] = ctrly;
            right[rightoff + 2] = x2;
            right[rightoff + 3] = y2;
        }
    }

    static void subdivideQuadAt(float t, float[] src, int srcoff, float[] left, int leftoff, float[] right, int rightoff) {
        float x1 = src[srcoff + 0];
        float y1 = src[srcoff + 1];
        float ctrlx = src[srcoff + 2];
        float ctrly = src[srcoff + 3];
        float x2 = src[srcoff + 4];
        float y2 = src[srcoff + 5];
        if (left != null) {
            left[leftoff + 0] = x1;
            left[leftoff + 1] = y1;
        }
        if (right != null) {
            right[rightoff + 4] = x2;
            right[rightoff + 5] = y2;
        }
        x1 += t * (ctrlx - x1);
        y1 += t * (ctrly - y1);
        x2 = ctrlx + t * (x2 - ctrlx);
        y2 = ctrly + t * (y2 - ctrly);
        ctrlx = x1 + t * (x2 - x1);
        ctrly = y1 + t * (y2 - y1);
        if (left != null) {
            left[leftoff + 2] = x1;
            left[leftoff + 3] = y1;
            left[leftoff + 4] = ctrlx;
            left[leftoff + 5] = ctrly;
        }
        if (right != null) {
            right[rightoff + 0] = ctrlx;
            right[rightoff + 1] = ctrly;
            right[rightoff + 2] = x2;
            right[rightoff + 3] = y2;
        }
    }

    static void subdivideAt(float t, float[] src, int srcoff, float[] left, int leftoff, float[] right, int rightoff, int size) {
        switch (size) {
            case 8: {
                Helpers.subdivideCubicAt(t, src, srcoff, left, leftoff, right, rightoff);
                break;
            }
            case 6: {
                Helpers.subdivideQuadAt(t, src, srcoff, left, leftoff, right, rightoff);
            }
        }
    }
}

