/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.TextAttribute;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.concurrent.ConcurrentHashMap;

abstract class Underline {
    private static final float DEFAULT_THICKNESS = 1.0f;
    private static final boolean USE_THICKNESS = true;
    private static final boolean IGNORE_THICKNESS = false;
    private static final ConcurrentHashMap<Object, Underline> UNDERLINES = new ConcurrentHashMap(6);
    private static final Underline[] UNDERLINE_LIST;

    Underline() {
    }

    abstract void drawUnderline(Graphics2D var1, float var2, float var3, float var4, float var5);

    abstract float getLowerDrawLimit(float var1);

    abstract Shape getUnderlineShape(float var1, float var2, float var3, float var4);

    static Underline getUnderline(Object value) {
        if (value == null) {
            return null;
        }
        return UNDERLINES.get(value);
    }

    static Underline getUnderline(int index) {
        return index < 0 ? null : UNDERLINE_LIST[index];
    }

    static {
        Underline[] uls = new Underline[6];
        uls[0] = new StandardUnderline(0.0f, 1.0f, null, true);
        UNDERLINES.put(TextAttribute.UNDERLINE_ON, uls[0]);
        uls[1] = new StandardUnderline(1.0f, 1.0f, null, false);
        UNDERLINES.put(TextAttribute.UNDERLINE_LOW_ONE_PIXEL, uls[1]);
        uls[2] = new StandardUnderline(1.0f, 2.0f, null, false);
        UNDERLINES.put(TextAttribute.UNDERLINE_LOW_TWO_PIXEL, uls[2]);
        uls[3] = new StandardUnderline(1.0f, 1.0f, new float[]{1.0f, 1.0f}, false);
        UNDERLINES.put(TextAttribute.UNDERLINE_LOW_DOTTED, uls[3]);
        uls[4] = new IMGrayUnderline();
        UNDERLINES.put(TextAttribute.UNDERLINE_LOW_GRAY, uls[4]);
        uls[5] = new StandardUnderline(1.0f, 1.0f, new float[]{4.0f, 4.0f}, false);
        UNDERLINES.put(TextAttribute.UNDERLINE_LOW_DASHED, uls[5]);
        UNDERLINE_LIST = uls;
    }

    private static class IMGrayUnderline
    extends Underline {
        private BasicStroke stroke = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{1.0f, 1.0f}, 0.0f);

        IMGrayUnderline() {
        }

        void drawUnderline(Graphics2D g2d, float thickness, float x1, float x2, float y) {
            Stroke saveStroke = g2d.getStroke();
            g2d.setStroke(this.stroke);
            Line2D.Float drawLine = new Line2D.Float(x1, y, x2, y);
            g2d.draw(drawLine);
            drawLine.y1 += 1.0f;
            drawLine.y2 += 1.0f;
            drawLine.x1 += 1.0f;
            g2d.draw(drawLine);
            g2d.setStroke(saveStroke);
        }

        float getLowerDrawLimit(float thickness) {
            return 2.0f;
        }

        Shape getUnderlineShape(float thickness, float x1, float x2, float y) {
            GeneralPath gp = new GeneralPath();
            Line2D.Float line = new Line2D.Float(x1, y, x2, y);
            gp.append(this.stroke.createStrokedShape(line), false);
            line.y1 += 1.0f;
            line.y2 += 1.0f;
            line.x1 += 1.0f;
            gp.append(this.stroke.createStrokedShape(line), false);
            return gp;
        }
    }

    private static final class StandardUnderline
    extends Underline {
        private float shift;
        private float thicknessMultiplier;
        private float[] dashPattern;
        private boolean useThickness;
        private BasicStroke cachedStroke;

        StandardUnderline(float shift, float thicknessMultiplier, float[] dashPattern, boolean useThickness) {
            this.shift = shift;
            this.thicknessMultiplier = thicknessMultiplier;
            this.dashPattern = dashPattern;
            this.useThickness = useThickness;
            this.cachedStroke = null;
        }

        private BasicStroke createStroke(float lineThickness) {
            if (this.dashPattern == null) {
                return new BasicStroke(lineThickness);
            }
            return new BasicStroke(lineThickness, 0, 0, 10.0f, this.dashPattern, 0.0f);
        }

        private float getLineThickness(float thickness) {
            if (this.useThickness) {
                return thickness * this.thicknessMultiplier;
            }
            return 1.0f * this.thicknessMultiplier;
        }

        private Stroke getStroke(float thickness) {
            float lineThickness = this.getLineThickness(thickness);
            BasicStroke stroke = this.cachedStroke;
            if (stroke == null || stroke.getLineWidth() != lineThickness) {
                this.cachedStroke = stroke = this.createStroke(lineThickness);
            }
            return stroke;
        }

        void drawUnderline(Graphics2D g2d, float thickness, float x1, float x2, float y) {
            Stroke saveStroke = g2d.getStroke();
            g2d.setStroke(this.getStroke(thickness));
            g2d.draw(new Line2D.Float(x1, y + this.shift, x2, y + this.shift));
            g2d.setStroke(saveStroke);
        }

        float getLowerDrawLimit(float thickness) {
            return this.shift + this.getLineThickness(thickness);
        }

        Shape getUnderlineShape(float thickness, float x1, float x2, float y) {
            Stroke ulStroke = this.getStroke(thickness);
            Line2D.Float line = new Line2D.Float(x1, y + this.shift, x2, y + this.shift);
            return ulStroke.createStrokedShape(line);
        }
    }
}

