/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.awt.geom.Point2D;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Locale;
import java.util.logging.Level;
import sun.awt.SunToolkit;
import sun.font.CharToGlyphMapper;
import sun.font.FileFont;
import sun.font.FontManager;
import sun.font.FontScaler;
import sun.font.FontScalerException;
import sun.font.NativeFont;
import sun.font.TrueTypeGlyphMapper;
import sun.java2d.Disposer;
import sun.java2d.DisposerRecord;
import sun.security.action.GetPropertyAction;

public class TrueTypeFont
extends FileFont {
    public static final int cmapTag = 1668112752;
    public static final int glyfTag = 1735162214;
    public static final int headTag = 1751474532;
    public static final int hheaTag = 1751672161;
    public static final int hmtxTag = 1752003704;
    public static final int locaTag = 1819239265;
    public static final int maxpTag = 1835104368;
    public static final int nameTag = 1851878757;
    public static final int postTag = 1886352244;
    public static final int os_2Tag = 1330851634;
    public static final int GDEFTag = 1195656518;
    public static final int GPOSTag = 1196445523;
    public static final int GSUBTag = 1196643650;
    public static final int mortTag = 1836020340;
    public static final int fdscTag = 1717859171;
    public static final int fvarTag = 1719034226;
    public static final int featTag = 1717920116;
    public static final int EBLCTag = 1161972803;
    public static final int gaspTag = 1734439792;
    public static final int ttcfTag = 1953784678;
    public static final int v1ttTag = 65536;
    public static final int trueTag = 1953658213;
    public static final int ottoTag = 0x4F54544F;
    public static final int MS_PLATFORM_ID = 3;
    public static final short ENGLISH_LOCALE_ID = 1033;
    public static final int FAMILY_NAME_ID = 1;
    public static final int FULL_NAME_ID = 4;
    public static final int POSTSCRIPT_NAME_ID = 6;
    TTDisposerRecord disposerRecord = new TTDisposerRecord();
    int fontIndex = 0;
    int directoryCount = 1;
    int directoryOffset;
    int numTables;
    DirectoryEntry[] tableDirectory;
    private boolean supportsJA;
    private boolean supportsCJK;
    private static final int TTCHEADERSIZE = 12;
    private static final int DIRECTORYHEADERSIZE = 12;
    private static final int DIRECTORYENTRYSIZE = 16;
    static final String[] encoding_mapping = new String[]{"cp1252", "cp1250", "cp1251", "cp1253", "cp1254", "cp1255", "cp1256", "cp1257", "", "", "", "", "", "", "", "", "ms874", "ms932", "gbk", "ms949", "ms950", "ms1361", "", "", "", "", "", "", "", "", "", ""};
    private static final String[][] languages = new String[][]{{"en", "ca", "da", "de", "es", "fi", "fr", "is", "it", "nl", "no", "pt", "sq", "sv"}, {"cs", "cz", "et", "hr", "hu", "nr", "pl", "ro", "sk", "sl", "sq", "sr"}, {"bg", "mk", "ru", "sh", "uk"}, {"el"}, {"tr"}, {"he"}, {"ar"}, {"et", "lt", "lv"}, {"th"}, {"ja"}, {"zh", "zh_CN"}, {"ko"}, {"zh_HK", "zh_TW"}, {"ko"}};
    private static final String[] codePages = new String[]{"cp1252", "cp1250", "cp1251", "cp1253", "cp1254", "cp1255", "cp1256", "cp1257", "ms874", "ms932", "gbk", "ms949", "ms950", "ms1361"};
    private static String defaultCodePage = null;
    public static final int reserved_bits1 = Integer.MIN_VALUE;
    public static final int reserved_bits2 = 65535;
    private static final int fsSelectionItalicBit = 1;
    private static final int fsSelectionBoldBit = 32;
    private static final int fsSelectionRegularBit = 64;
    private float stSize;
    private float stPos;
    private float ulSize;
    private float ulPos;
    private char[] gaspTable;

    TrueTypeFont(String platname, Object nativeNames, int fIndex, boolean javaRasterizer) throws FontFormatException {
        super(platname, nativeNames);
        this.useJavaRasterizer = javaRasterizer;
        this.fontRank = 3;
        try {
            this.verify();
            this.init(fIndex);
        }
        catch (Throwable t) {
            this.close();
            if (t instanceof FontFormatException) {
                throw (FontFormatException)t;
            }
            throw new FontFormatException("Unexpected runtime exception.");
        }
        Disposer.addObjectRecord(this, this.disposerRecord);
    }

    protected boolean checkUseNatives() {
        if (this.checkedNatives) {
            return this.useNatives;
        }
        if (!FontManager.isSolaris || this.useJavaRasterizer || FontManager.useT2K || this.nativeNames == null || this.getDirectoryEntry(1161972803) != null || GraphicsEnvironment.isHeadless()) {
            this.checkedNatives = true;
            return false;
        }
        if (this.nativeNames instanceof String) {
            String name = (String)this.nativeNames;
            if (name.indexOf("8859") > 0) {
                this.checkedNatives = true;
                return false;
            }
            if (NativeFont.hasExternalBitmaps(name)) {
                this.nativeFonts = new NativeFont[1];
                try {
                    this.nativeFonts[0] = new NativeFont(name, true);
                    this.useNatives = true;
                }
                catch (FontFormatException e) {
                    this.nativeFonts = null;
                }
            }
        } else if (this.nativeNames instanceof String[]) {
            int nn;
            String[] natNames = (String[])this.nativeNames;
            int numNames = natNames.length;
            boolean externalBitmaps = false;
            for (nn = 0; nn < numNames; ++nn) {
                if (natNames[nn].indexOf("8859") > 0) {
                    this.checkedNatives = true;
                    return false;
                }
                if (!NativeFont.hasExternalBitmaps(natNames[nn])) continue;
                externalBitmaps = true;
            }
            if (!externalBitmaps) {
                this.checkedNatives = true;
                return false;
            }
            this.useNatives = true;
            this.nativeFonts = new NativeFont[numNames];
            for (nn = 0; nn < numNames; ++nn) {
                try {
                    this.nativeFonts[nn] = new NativeFont(natNames[nn], true);
                    continue;
                }
                catch (FontFormatException e) {
                    this.useNatives = false;
                    this.nativeFonts = null;
                }
            }
        }
        if (this.useNatives) {
            this.glyphToCharMap = new char[this.getMapper().getNumGlyphs()];
        }
        this.checkedNatives = true;
        return this.useNatives;
    }

    private synchronized FileChannel open() throws FontFormatException {
        if (this.disposerRecord.channel == null) {
            if (FontManager.logging) {
                FontManager.logger.info("open TTF: " + this.platName);
            }
            try {
                RandomAccessFile raf = (RandomAccessFile)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            return new RandomAccessFile(TrueTypeFont.this.platName, "r");
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            return null;
                        }
                    }
                });
                this.disposerRecord.channel = raf.getChannel();
                this.fileSize = (int)this.disposerRecord.channel.size();
                FontManager.addToPool(this);
            }
            catch (NullPointerException e) {
                this.close();
                throw new FontFormatException(e.toString());
            }
            catch (ClosedChannelException e) {
                Thread.interrupted();
                this.close();
                this.open();
            }
            catch (IOException e) {
                this.close();
                throw new FontFormatException(e.toString());
            }
        }
        return this.disposerRecord.channel;
    }

    protected synchronized void close() {
        this.disposerRecord.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int readBlock(ByteBuffer buffer, int offset, int length) {
        int bread;
        block21: {
            bread = 0;
            try {
                TrueTypeFont trueTypeFont = this;
                synchronized (trueTypeFont) {
                    if (this.disposerRecord.channel == null) {
                        this.open();
                    }
                    if (offset + length > this.fileSize) {
                        if (offset >= this.fileSize) {
                            if (FontManager.logging) {
                                String msg = "Read offset is " + offset + " file size is " + this.fileSize + " file is " + this.platName;
                                FontManager.logger.severe(msg);
                            }
                            return -1;
                        }
                        length = this.fileSize - offset;
                    }
                    buffer.clear();
                    this.disposerRecord.channel.position(offset);
                    while (bread < length) {
                        int cnt = this.disposerRecord.channel.read(buffer);
                        if (cnt == -1) {
                            String msg = "Unexpected EOF " + this;
                            int currSize = (int)this.disposerRecord.channel.size();
                            if (currSize != this.fileSize) {
                                msg = msg + " File size was " + this.fileSize + " and now is " + currSize;
                            }
                            if (FontManager.logging) {
                                FontManager.logger.severe(msg);
                            }
                            if (bread > length / 2 || bread > 16384) {
                                buffer.flip();
                                if (FontManager.logging) {
                                    msg = "Returning " + bread + " bytes instead of " + length;
                                    FontManager.logger.severe(msg);
                                }
                            } else {
                                bread = -1;
                            }
                            throw new IOException(msg);
                        }
                        bread += cnt;
                    }
                    buffer.flip();
                    if (bread > length) {
                        bread = length;
                    }
                }
            }
            catch (FontFormatException e) {
                if (FontManager.logging) {
                    FontManager.logger.log(Level.SEVERE, "While reading " + this.platName, e);
                }
                bread = -1;
                this.deregisterFontAndClearStrikeCache();
            }
            catch (ClosedChannelException e) {
                Thread.interrupted();
                this.close();
                return this.readBlock(buffer, offset, length);
            }
            catch (IOException e) {
                if (FontManager.logging) {
                    FontManager.logger.log(Level.SEVERE, "While reading " + this.platName, e);
                }
                if (bread != 0) break block21;
                bread = -1;
                this.deregisterFontAndClearStrikeCache();
            }
        }
        return bread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ByteBuffer readBlock(int offset, int length) {
        ByteBuffer buffer = ByteBuffer.allocate(length);
        try {
            TrueTypeFont trueTypeFont = this;
            synchronized (trueTypeFont) {
                if (this.disposerRecord.channel == null) {
                    this.open();
                }
                if (offset + length > this.fileSize) {
                    if (offset > this.fileSize) {
                        return null;
                    }
                    buffer = ByteBuffer.allocate(this.fileSize - offset);
                }
                this.disposerRecord.channel.position(offset);
                this.disposerRecord.channel.read(buffer);
                buffer.flip();
            }
        }
        catch (FontFormatException e) {
            return null;
        }
        catch (ClosedChannelException e) {
            Thread.interrupted();
            this.close();
            this.readBlock(buffer, offset, length);
        }
        catch (IOException e) {
            return null;
        }
        return buffer;
    }

    byte[] readBytes(int offset, int length) {
        ByteBuffer buffer = this.readBlock(offset, length);
        if (buffer.hasArray()) {
            return buffer.array();
        }
        byte[] bufferBytes = new byte[buffer.limit()];
        buffer.get(bufferBytes);
        return bufferBytes;
    }

    private void verify() throws FontFormatException {
        this.open();
    }

    protected void init(int fIndex) throws FontFormatException {
        int headerOffset = 0;
        ByteBuffer buffer = this.readBlock(0, 12);
        try {
            switch (buffer.getInt()) {
                case 1953784678: {
                    buffer.getInt();
                    this.directoryCount = buffer.getInt();
                    if (fIndex >= this.directoryCount) {
                        throw new FontFormatException("Bad collection index");
                    }
                    this.fontIndex = fIndex;
                    buffer = this.readBlock(12 + 4 * fIndex, 4);
                    headerOffset = buffer.getInt();
                    break;
                }
                case 65536: 
                case 0x4F54544F: 
                case 1953658213: {
                    break;
                }
                default: {
                    throw new FontFormatException("Unsupported sfnt " + this.platName);
                }
            }
            buffer = this.readBlock(headerOffset + 4, 2);
            this.numTables = buffer.getShort();
            this.directoryOffset = headerOffset + 12;
            ByteBuffer bbuffer = this.readBlock(this.directoryOffset, this.numTables * 16);
            IntBuffer ibuffer = bbuffer.asIntBuffer();
            this.tableDirectory = new DirectoryEntry[this.numTables];
            for (int i = 0; i < this.numTables; ++i) {
                DirectoryEntry table;
                this.tableDirectory[i] = table = new DirectoryEntry();
                table.tag = ibuffer.get();
                ibuffer.get();
                table.offset = ibuffer.get();
                table.length = ibuffer.get();
                if (table.offset + table.length <= this.fileSize) continue;
                throw new FontFormatException("bad table, tag=" + table.tag);
            }
            this.initNames();
        }
        catch (Exception e) {
            if (FontManager.logging) {
                FontManager.logger.severe(e.toString());
            }
            if (e instanceof FontFormatException) {
                throw (FontFormatException)e;
            }
            throw new FontFormatException(e.toString());
        }
        if (this.familyName == null || this.fullName == null) {
            throw new FontFormatException("Font name not found");
        }
        ByteBuffer os2_Table = this.getTableBuffer(1330851634);
        this.setStyle(os2_Table);
        this.setCJKSupport(os2_Table);
        ByteBuffer head_Table = this.getTableBuffer(1751474532);
        int upem = -1;
        if (head_Table != null && head_Table.capacity() >= 18) {
            ShortBuffer sb = head_Table.asShortBuffer();
            upem = sb.get(9) & 0xFFFF;
        }
        this.setStrikethroughMetrics(os2_Table, upem);
        ByteBuffer post_Table = this.getTableBuffer(1886352244);
        this.setUnderlineMetrics(post_Table, upem);
    }

    static String getCodePage() {
        if (defaultCodePage != null) {
            return defaultCodePage;
        }
        if (FontManager.isWindows) {
            defaultCodePage = AccessController.doPrivileged(new GetPropertyAction("file.encoding"));
        } else {
            if (languages.length != codePages.length) {
                throw new InternalError("wrong code pages array length");
            }
            Locale locale = SunToolkit.getStartupLocale();
            String language = locale.getLanguage();
            if (language != null) {
                String country;
                if (language.equals("zh") && (country = locale.getCountry()) != null) {
                    language = language + "_" + country;
                }
                for (int i = 0; i < languages.length; ++i) {
                    for (int l = 0; l < languages[i].length; ++l) {
                        if (!language.equals(languages[i][l])) continue;
                        defaultCodePage = codePages[i];
                        return defaultCodePage;
                    }
                }
            }
        }
        if (defaultCodePage == null) {
            defaultCodePage = "";
        }
        return defaultCodePage;
    }

    boolean supportsEncoding(String encoding) {
        if (encoding == null) {
            encoding = TrueTypeFont.getCodePage();
        }
        if ("".equals(encoding)) {
            return false;
        }
        if ((encoding = encoding.toLowerCase()).equals("gb18030")) {
            encoding = "gbk";
        } else if (encoding.equals("ms950_hkscs")) {
            encoding = "ms950";
        }
        ByteBuffer buffer = this.getTableBuffer(1330851634);
        if (buffer == null || buffer.capacity() < 86) {
            return false;
        }
        int range1 = buffer.getInt(78);
        int range2 = buffer.getInt(82);
        for (int em = 0; em < encoding_mapping.length; ++em) {
            if (!encoding_mapping[em].equals(encoding) || (1 << em & range1) == 0) continue;
            return true;
        }
        return false;
    }

    private void setCJKSupport(ByteBuffer os2Table) {
        if (os2Table == null || os2Table.capacity() < 50) {
            return;
        }
        int range2 = os2Table.getInt(46);
        this.supportsCJK = (range2 & 0x29BF0000) != 0;
        this.supportsJA = (range2 & 0x60000) != 0;
    }

    boolean supportsJA() {
        return this.supportsJA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ByteBuffer getTableBuffer(int tag) {
        DirectoryEntry entry = null;
        for (int i = 0; i < this.numTables; ++i) {
            if (this.tableDirectory[i].tag != tag) continue;
            entry = this.tableDirectory[i];
            break;
        }
        if (entry == null || entry.length == 0 || entry.offset + entry.length > this.fileSize) {
            return null;
        }
        int bread = 0;
        ByteBuffer buffer = ByteBuffer.allocate(entry.length);
        TrueTypeFont trueTypeFont = this;
        synchronized (trueTypeFont) {
            try {
                if (this.disposerRecord.channel == null) {
                    this.open();
                }
                this.disposerRecord.channel.position(entry.offset);
                bread = this.disposerRecord.channel.read(buffer);
                buffer.flip();
            }
            catch (ClosedChannelException e) {
                Thread.interrupted();
                this.close();
                return this.getTableBuffer(tag);
            }
            catch (IOException e) {
                return null;
            }
            catch (FontFormatException e) {
                return null;
            }
            if (bread < entry.length) {
                return null;
            }
            return buffer;
        }
    }

    long getLayoutTableCache() {
        try {
            return this.getScaler().getLayoutTableCache();
        }
        catch (FontScalerException fe) {
            return 0L;
        }
    }

    byte[] getTableBytes(int tag) {
        ByteBuffer buffer = this.getTableBuffer(tag);
        if (buffer == null) {
            return null;
        }
        if (buffer.hasArray()) {
            try {
                return buffer.array();
            }
            catch (Exception re) {
                // empty catch block
            }
        }
        byte[] data = new byte[this.getTableSize(tag)];
        buffer.get(data);
        return data;
    }

    int getTableSize(int tag) {
        for (int i = 0; i < this.numTables; ++i) {
            if (this.tableDirectory[i].tag != tag) continue;
            return this.tableDirectory[i].length;
        }
        return 0;
    }

    int getTableOffset(int tag) {
        for (int i = 0; i < this.numTables; ++i) {
            if (this.tableDirectory[i].tag != tag) continue;
            return this.tableDirectory[i].offset;
        }
        return 0;
    }

    DirectoryEntry getDirectoryEntry(int tag) {
        for (int i = 0; i < this.numTables; ++i) {
            if (this.tableDirectory[i].tag != tag) continue;
            return this.tableDirectory[i];
        }
        return null;
    }

    public String getFullName() {
        return this.fullName;
    }

    protected void setStyle() {
        this.setStyle(this.getTableBuffer(1330851634));
    }

    private void setStyle(ByteBuffer os_2Table) {
        if (os_2Table == null || os_2Table.capacity() < 64) {
            super.setStyle();
            return;
        }
        int fsSelection = os_2Table.getChar(62) & 0xFFFF;
        int italic = fsSelection & 1;
        int bold = fsSelection & 0x20;
        int regular = fsSelection & 0x40;
        if (regular != 0 && (italic | bold) != 0) {
            super.setStyle();
            return;
        }
        if ((regular | italic | bold) == 0) {
            super.setStyle();
            return;
        }
        switch (bold | italic) {
            case 1: {
                this.style = 2;
                break;
            }
            case 32: {
                if (FontManager.isSolaris && this.platName.endsWith("HG-GothicB.ttf")) {
                    this.style = 0;
                    break;
                }
                this.style = 1;
                break;
            }
            case 33: {
                this.style = 3;
            }
        }
    }

    private void setStrikethroughMetrics(ByteBuffer os_2Table, int upem) {
        if (os_2Table == null || os_2Table.capacity() < 30 || upem < 0) {
            this.stSize = 0.05f;
            this.stPos = -0.4f;
            return;
        }
        ShortBuffer sb = os_2Table.asShortBuffer();
        this.stSize = (float)sb.get(13) / (float)upem;
        this.stPos = (float)(-sb.get(14)) / (float)upem;
    }

    private void setUnderlineMetrics(ByteBuffer postTable, int upem) {
        if (postTable == null || postTable.capacity() < 12 || upem < 0) {
            this.ulSize = 0.05f;
            this.ulPos = 0.1f;
            return;
        }
        ShortBuffer sb = postTable.asShortBuffer();
        this.ulSize = (float)sb.get(5) / (float)upem;
        this.ulPos = (float)(-sb.get(4)) / (float)upem;
    }

    public void getStyleMetrics(float pointSize, float[] metrics, int offset) {
        metrics[offset] = this.stPos * pointSize;
        metrics[offset + 1] = this.stSize * pointSize;
        metrics[offset + 2] = this.ulPos * pointSize;
        metrics[offset + 3] = this.ulSize * pointSize;
    }

    private String makeString(byte[] bytes, int len, short encoding) {
        String charset;
        if (encoding >= 2 && encoding <= 6) {
            byte[] oldbytes = bytes;
            int oldlen = len;
            bytes = new byte[oldlen];
            len = 0;
            for (int i = 0; i < oldlen; ++i) {
                if (oldbytes[i] == 0) continue;
                bytes[len++] = oldbytes[i];
            }
        }
        switch (encoding) {
            case 1: {
                charset = "UTF-16";
                break;
            }
            case 0: {
                charset = "UTF-16";
                break;
            }
            case 2: {
                charset = "SJIS";
                break;
            }
            case 3: {
                charset = "GBK";
                break;
            }
            case 4: {
                charset = "MS950";
                break;
            }
            case 5: {
                charset = "EUC_KR";
                break;
            }
            case 6: {
                charset = "Johab";
                break;
            }
            default: {
                charset = "UTF-16";
            }
        }
        try {
            return new String(bytes, 0, len, charset);
        }
        catch (UnsupportedEncodingException e) {
            if (FontManager.logging) {
                FontManager.logger.warning(e + " EncodingID=" + encoding);
            }
            return new String(bytes, 0, len);
        }
        catch (Throwable t) {
            return null;
        }
    }

    protected void initNames() {
        byte[] name = new byte[256];
        ByteBuffer buffer = this.getTableBuffer(1851878757);
        if (buffer != null) {
            ShortBuffer sbuffer = buffer.asShortBuffer();
            sbuffer.get();
            int numRecords = sbuffer.get();
            int stringPtr = sbuffer.get() & 0xFFFF;
            block4: for (int i = 0; i < numRecords; ++i) {
                short platformID = sbuffer.get();
                if (platformID != 3) {
                    sbuffer.position(sbuffer.position() + 5);
                    continue;
                }
                short encodingID = sbuffer.get();
                short langID = sbuffer.get();
                short nameID = sbuffer.get();
                int nameLen = sbuffer.get() & 0xFFFF;
                int namePtr = (sbuffer.get() & 0xFFFF) + stringPtr;
                switch (nameID) {
                    case 1: {
                        if (this.familyName != null && langID != 1033) continue block4;
                        buffer.position(namePtr);
                        buffer.get(name, 0, nameLen);
                        this.familyName = this.makeString(name, nameLen, encodingID);
                        continue block4;
                    }
                    case 4: {
                        if (this.fullName != null && langID != 1033) continue block4;
                        buffer.position(namePtr);
                        buffer.get(name, 0, nameLen);
                        this.fullName = this.makeString(name, nameLen, encodingID);
                    }
                }
            }
        }
    }

    protected String lookupName(short findLocaleID, int findNameID) {
        String foundName = null;
        byte[] name = new byte[1024];
        ByteBuffer buffer = this.getTableBuffer(1851878757);
        if (buffer != null) {
            ShortBuffer sbuffer = buffer.asShortBuffer();
            sbuffer.get();
            int numRecords = sbuffer.get();
            int stringPtr = sbuffer.get() & 0xFFFF;
            for (int i = 0; i < numRecords; ++i) {
                short platformID = sbuffer.get();
                if (platformID != 3) {
                    sbuffer.position(sbuffer.position() + 5);
                    continue;
                }
                short encodingID = sbuffer.get();
                short langID = sbuffer.get();
                short nameID = sbuffer.get();
                int nameLen = sbuffer.get() & 0xFFFF;
                int namePtr = (sbuffer.get() & 0xFFFF) + stringPtr;
                if (nameID != findNameID || (foundName != null || langID != 1033) && langID != findLocaleID) continue;
                buffer.position(namePtr);
                buffer.get(name, 0, nameLen);
                foundName = this.makeString(name, nameLen, encodingID);
                if (langID != findLocaleID) continue;
                return foundName;
            }
        }
        return foundName;
    }

    public int getFontCount() {
        return this.directoryCount;
    }

    protected synchronized FontScaler getScaler() {
        if (this.scaler == null) {
            this.scaler = FontManager.getScaler(this, this.fontIndex, this.supportsCJK, this.fileSize);
        }
        return this.scaler;
    }

    public String getPostscriptName() {
        String name = this.lookupName((short)1033, 6);
        if (name == null) {
            return this.fullName;
        }
        return name;
    }

    public String getFontName(Locale locale) {
        if (locale == null) {
            return this.fullName;
        }
        short localeID = FontManager.getLCIDFromLocale(locale);
        String name = this.lookupName(localeID, 4);
        if (name == null) {
            return this.fullName;
        }
        return name;
    }

    public String getFamilyName(Locale locale) {
        if (locale == null) {
            return this.familyName;
        }
        short localeID = FontManager.getLCIDFromLocale(locale);
        String name = this.lookupName(localeID, 1);
        if (name == null) {
            return this.familyName;
        }
        return name;
    }

    public CharToGlyphMapper getMapper() {
        if (this.mapper == null) {
            this.mapper = new TrueTypeGlyphMapper(this);
        }
        return this.mapper;
    }

    protected void initAllNames(int requestedID, HashSet names) {
        byte[] name = new byte[256];
        ByteBuffer buffer = this.getTableBuffer(1851878757);
        if (buffer != null) {
            ShortBuffer sbuffer = buffer.asShortBuffer();
            sbuffer.get();
            int numRecords = sbuffer.get();
            int stringPtr = sbuffer.get() & 0xFFFF;
            for (int i = 0; i < numRecords; ++i) {
                short platformID = sbuffer.get();
                if (platformID != 3) {
                    sbuffer.position(sbuffer.position() + 5);
                    continue;
                }
                short encodingID = sbuffer.get();
                short langID = sbuffer.get();
                short nameID = sbuffer.get();
                int nameLen = sbuffer.get() & 0xFFFF;
                int namePtr = (sbuffer.get() & 0xFFFF) + stringPtr;
                if (nameID != requestedID) continue;
                buffer.position(namePtr);
                buffer.get(name, 0, nameLen);
                names.add(this.makeString(name, nameLen, encodingID));
            }
        }
    }

    String[] getAllFamilyNames() {
        HashSet aSet = new HashSet();
        try {
            this.initAllNames(1, aSet);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return aSet.toArray(new String[0]);
    }

    String[] getAllFullNames() {
        HashSet aSet = new HashSet();
        try {
            this.initAllNames(4, aSet);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return aSet.toArray(new String[0]);
    }

    Point2D.Float getGlyphPoint(long pScalerContext, int glyphCode, int ptNumber) {
        try {
            return this.getScaler().getGlyphPoint(pScalerContext, glyphCode, ptNumber);
        }
        catch (FontScalerException fe) {
            return null;
        }
    }

    private char[] getGaspTable() {
        if (this.gaspTable != null) {
            return this.gaspTable;
        }
        ByteBuffer buffer = this.getTableBuffer(1734439792);
        if (buffer == null) {
            this.gaspTable = new char[0];
            return this.gaspTable;
        }
        CharBuffer cbuffer = buffer.asCharBuffer();
        char format = cbuffer.get();
        if (format > '\u0001') {
            this.gaspTable = new char[0];
            return this.gaspTable;
        }
        char numRanges = cbuffer.get();
        if (4 + numRanges * 4 > this.getTableSize(1734439792)) {
            this.gaspTable = new char[0];
            return this.gaspTable;
        }
        this.gaspTable = new char[2 * numRanges];
        cbuffer.get(this.gaspTable);
        return this.gaspTable;
    }

    public boolean useAAForPtSize(int ptsize) {
        char[] gasp = this.getGaspTable();
        if (gasp.length > 0) {
            for (int i = 0; i < gasp.length; i += 2) {
                if (ptsize > gasp[i]) continue;
                return (gasp[i + 1] & 2) != 0;
            }
            return true;
        }
        if (this.style == 1) {
            return true;
        }
        return ptsize <= 8 || ptsize >= 18;
    }

    public boolean hasSupplementaryChars() {
        return ((TrueTypeGlyphMapper)this.getMapper()).hasSupplementaryChars();
    }

    public String toString() {
        return "** TrueType Font: Family=" + this.familyName + " Name=" + this.fullName + " style=" + this.style + " fileName=" + this.platName;
    }

    private static class TTDisposerRecord
    implements DisposerRecord {
        FileChannel channel = null;

        private TTDisposerRecord() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void dispose() {
            try {
                if (this.channel != null) {
                    this.channel.close();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                this.channel = null;
            }
        }
    }

    class DirectoryEntry {
        int tag;
        int offset;
        int length;

        DirectoryEntry() {
        }
    }
}

