/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.applet.Applet;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Vector;
import net.sourceforge.jnlp.NetxPanel;
import sun.applet.AppletPanel;
import sun.applet.AppletSecurityContextManager;
import sun.applet.AppletViewerPanel;
import sun.applet.PluginAppletViewer;
import sun.applet.PluginDebug;
import sun.applet.PluginStreamHandler;

class PluginAppletPanelFactory {
    PluginAppletPanelFactory() {
    }

    public AppletPanel createPanel(PluginStreamHandler streamhandler, int identifier, long handle, int x, int y, final URL doc, final Hashtable atts) {
        AppletViewerPanel panel = (AppletViewerPanel)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    NetxPanel panel = new NetxPanel(doc, atts, false);
                    AppletViewerPanel.debug("Using NetX panel");
                    PluginDebug.debug(atts.toString());
                    return panel;
                }
                catch (Exception ex) {
                    AppletViewerPanel.debug("Unable to start NetX applet - defaulting to Sun applet", ex);
                    return new AppletViewerPanel(doc, atts);
                }
            }
        });
        double heightFactor = 1.0;
        double widthFactor = 1.0;
        if (atts.get("heightPercentage") != null) {
            heightFactor = (double)((Integer)atts.get("heightPercentage")).intValue() / 100.0;
        }
        if (atts.get("widthPercentage") != null) {
            widthFactor = (double)((Integer)atts.get("widthPercentage")).intValue() / 100.0;
        }
        PluginAppletViewer.reFrame(null, identifier, System.out, heightFactor, widthFactor, 0L, panel);
        panel.init();
        this.initEventQueue(panel);
        String portComponent = doc.getPort() != -1 ? ":" + doc.getPort() : "";
        String codeBase = doc.getProtocol() + "://" + doc.getHost() + portComponent;
        if (atts.get("codebase") != null) {
            try {
                URL appletSrcURL = new URL(codeBase + (String)atts.get("codebase"));
                codeBase = appletSrcURL.getProtocol() + "://" + appletSrcURL.getHost();
            }
            catch (MalformedURLException mfue) {
                // empty catch block
            }
        }
        int maxWait = 60000;
        int wait = 0;
        while (panel == null || !((NetxPanel)panel).isAlive() && wait < maxWait) {
            try {
                Thread.sleep(50L);
                wait += 50;
            }
            catch (InterruptedException ie) {}
        }
        while (panel.getApplet() == null && ((NetxPanel)panel).isAlive()) {
            try {
                Thread.sleep(50L);
                PluginDebug.debug("Waiting for applet to initialize...");
            }
            catch (InterruptedException ie) {}
        }
        Applet a = panel.getApplet();
        if (panel.getApplet() == null) {
            streamhandler.write("instance " + identifier + " reference " + -1 + " fatalError " + "Initialization failed");
            return null;
        }
        PluginDebug.debug("Applet " + a.getClass() + " initialized");
        streamhandler.write("instance " + identifier + " reference 0 initialized");
        AppletSecurityContextManager.getSecurityContext(0).associateSrc(((NetxPanel)panel).getAppletClassLoader(), doc);
        AppletSecurityContextManager.getSecurityContext(0).associateInstance(identifier, ((NetxPanel)panel).getAppletClassLoader());
        return panel;
    }

    public boolean isStandalone() {
        return false;
    }

    private void initEventQueue(AppletPanel panel) {
        PrivilegedAction pa = new PrivilegedAction(){

            public Object run() {
                return System.getProperty("appletviewer.send.event");
            }
        };
        String eventList = (String)AccessController.doPrivileged(pa);
        if (eventList == null) {
            panel.sendEvent(1);
            panel.sendEvent(2);
            panel.sendEvent(3);
        } else {
            String[] events = this.splitSeparator(",", eventList);
            for (int i = 0; i < events.length; ++i) {
                PluginDebug.debug("Adding event to queue: " + events[i]);
                if (events[i].equals("dispose")) {
                    panel.sendEvent(0);
                    continue;
                }
                if (events[i].equals("load")) {
                    panel.sendEvent(1);
                    continue;
                }
                if (events[i].equals("init")) {
                    panel.sendEvent(2);
                    continue;
                }
                if (events[i].equals("start")) {
                    panel.sendEvent(3);
                    continue;
                }
                if (events[i].equals("stop")) {
                    panel.sendEvent(4);
                    continue;
                }
                if (events[i].equals("destroy")) {
                    panel.sendEvent(5);
                    continue;
                }
                if (events[i].equals("quit")) {
                    panel.sendEvent(6);
                    continue;
                }
                if (events[i].equals("error")) {
                    panel.sendEvent(7);
                    continue;
                }
                PluginDebug.debug("Unrecognized event name: " + events[i]);
            }
            while (!panel.emptyEventQueue()) {
            }
        }
    }

    private String[] splitSeparator(String sep, String s) {
        Vector<String> v = new Vector<String>();
        int tokenStart = 0;
        int tokenEnd = 0;
        while ((tokenEnd = s.indexOf(sep, tokenStart)) != -1) {
            v.addElement(s.substring(tokenStart, tokenEnd));
            tokenStart = tokenEnd + 1;
        }
        v.addElement(s.substring(tokenStart));
        Object[] retVal = new String[v.size()];
        v.copyInto(retVal);
        return retVal;
    }
}

