/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthArrowButton;
import javax.swing.plaf.synth.SynthComboPopup;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLabelUI;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.plaf.synth.SynthUI;

class SynthComboBoxUI
extends BasicComboBoxUI
implements PropertyChangeListener,
SynthUI {
    private SynthStyle style;
    private boolean useListColors;
    Insets popupInsets;
    private boolean buttonWhenNotEditable;
    private boolean pressedWhenPopupVisible;
    private ButtonHandler buttonHandler;
    private EditorFocusHandler editorFocusHandler;
    private boolean forceOpaque = false;
    private Insets padding;

    SynthComboBoxUI() {
    }

    public static ComponentUI createUI(JComponent c) {
        return new SynthComboBoxUI();
    }

    public void installUI(JComponent c) {
        this.buttonHandler = new ButtonHandler();
        super.installUI(c);
    }

    protected void installDefaults() {
        super.installDefaults();
        this.padding = UIManager.getInsets("ComboBox.padding");
        this.updateStyle(this.comboBox);
    }

    private void updateStyle(JComboBox comboBox) {
        SynthStyle oldStyle = this.style;
        SynthContext context = this.getContext(comboBox, 1);
        this.style = SynthLookAndFeel.updateStyle(context, this);
        if (this.style != oldStyle) {
            this.popupInsets = (Insets)this.style.get(context, "ComboBox.popupInsets");
            this.useListColors = this.style.getBoolean(context, "ComboBox.rendererUseListColors", true);
            this.buttonWhenNotEditable = this.style.getBoolean(context, "ComboBox.buttonWhenNotEditable", false);
            this.pressedWhenPopupVisible = this.style.getBoolean(context, "ComboBox.pressedWhenPopupVisible", false);
            if (oldStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
            this.forceOpaque = this.style.getBoolean(context, "ComboBox.forceOpaque", false);
        }
        context.dispose();
        if (this.listBox != null) {
            SynthLookAndFeel.updateStyles(this.listBox);
        }
    }

    protected void installListeners() {
        this.comboBox.addPropertyChangeListener(this);
        this.comboBox.addMouseListener(this.buttonHandler);
        this.editorFocusHandler = new EditorFocusHandler(this.comboBox);
        super.installListeners();
    }

    public void uninstallUI(JComponent c) {
        if (this.popup instanceof SynthComboPopup) {
            ((SynthComboPopup)this.popup).removePopupMenuListener(this.buttonHandler);
        }
        super.uninstallUI(c);
        this.buttonHandler = null;
    }

    protected void uninstallDefaults() {
        SynthContext context = this.getContext(this.comboBox, 1);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
    }

    protected void uninstallListeners() {
        this.editorFocusHandler.unregister();
        this.comboBox.removePropertyChangeListener(this);
        this.comboBox.removeMouseListener(this.buttonHandler);
        this.buttonHandler.pressed = false;
        this.buttonHandler.over = false;
        super.uninstallListeners();
    }

    public SynthContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    private SynthContext getContext(JComponent c, int state) {
        return SynthContext.getContext(SynthContext.class, c, SynthLookAndFeel.getRegion(c), this.style, state);
    }

    private Region getRegion(JComponent c) {
        return SynthLookAndFeel.getRegion(c);
    }

    private int getComponentState(JComponent c) {
        if (!(c instanceof JComboBox)) {
            return SynthLookAndFeel.getComponentState(c);
        }
        JComboBox box = (JComboBox)c;
        if (this.shouldActLikeButton()) {
            int state = 1;
            if (!c.isEnabled()) {
                state = 8;
            }
            if (this.buttonHandler.isPressed()) {
                state |= 4;
            }
            if (this.buttonHandler.isRollover()) {
                state |= 2;
            }
            if (box.isFocusOwner()) {
                state |= 0x100;
            }
            return state;
        }
        int basicState = SynthLookAndFeel.getComponentState(c);
        if (box.isEditable() && box.getEditor().getEditorComponent().isFocusOwner()) {
            basicState |= 0x100;
        }
        return basicState;
    }

    protected ComboPopup createPopup() {
        SynthComboPopup p = new SynthComboPopup(this.comboBox);
        p.addPopupMenuListener(this.buttonHandler);
        return p;
    }

    protected ListCellRenderer createRenderer() {
        return new SynthComboBoxRenderer();
    }

    protected ComboBoxEditor createEditor() {
        return new SynthComboBoxEditor();
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (SynthLookAndFeel.shouldUpdateStyle(e)) {
            this.updateStyle(this.comboBox);
        }
    }

    protected JButton createArrowButton() {
        SynthArrowButton button = new SynthArrowButton(5);
        button.setName("ComboBox.arrowButton");
        button.setModel(this.buttonHandler);
        return button;
    }

    public void update(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        SynthLookAndFeel.update(context, g);
        context.getPainter().paintComboBoxBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
        this.paint(context, g);
        context.dispose();
    }

    public void paint(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        this.paint(context, g);
        context.dispose();
    }

    protected void paint(SynthContext context, Graphics g) {
        this.hasFocus = this.comboBox.hasFocus();
        if (!this.comboBox.isEditable()) {
            Rectangle r = this.rectangleForCurrentValue();
            this.paintCurrentValue(g, r, this.hasFocus);
        }
    }

    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        context.getPainter().paintComboBoxBorder(context, g, x, y, w, h);
    }

    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        boolean force;
        ListCellRenderer renderer = this.comboBox.getRenderer();
        Component c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
        boolean shouldValidate = false;
        if (c instanceof JPanel) {
            shouldValidate = true;
        }
        if (c instanceof UIResource) {
            c.setName("ComboBox.renderer");
        }
        boolean bl = force = this.forceOpaque && c instanceof JComponent;
        if (force) {
            ((JComponent)c).setOpaque(false);
        }
        int x = bounds.x;
        int y = bounds.y;
        int w = bounds.width;
        int h = bounds.height;
        if (this.padding != null) {
            x = bounds.x + this.padding.left;
            y = bounds.y + this.padding.top;
            w = bounds.width - (this.padding.left + this.padding.right);
            h = bounds.height - (this.padding.top + this.padding.bottom);
        }
        this.currentValuePane.paintComponent(g, c, this.comboBox, x, y, w, h, shouldValidate);
        if (force) {
            ((JComponent)c).setOpaque(true);
        }
    }

    private boolean shouldActLikeButton() {
        return this.buttonWhenNotEditable && !this.comboBox.isEditable();
    }

    protected Dimension getDefaultSize() {
        SynthComboBoxRenderer r = new SynthComboBoxRenderer();
        Dimension d = this.getSizeForComponent(r.getListCellRendererComponent(this.listBox, " ", -1, false, false));
        return new Dimension(d.width, d.height);
    }

    private Dimension getSizeForComponent(Component comp) {
        this.currentValuePane.add(comp);
        comp.setFont(this.comboBox.getFont());
        Dimension d = comp.getPreferredSize();
        this.currentValuePane.remove(comp);
        return d;
    }

    private static class EditorFocusHandler
    implements FocusListener,
    PropertyChangeListener {
        private JComboBox comboBox;
        private ComboBoxEditor editor = null;
        private Component editorComponent = null;

        private EditorFocusHandler(JComboBox comboBox) {
            this.comboBox = comboBox;
            this.editor = comboBox.getEditor();
            if (this.editor != null) {
                this.editorComponent = this.editor.getEditorComponent();
                if (this.editorComponent != null) {
                    this.editorComponent.addFocusListener(this);
                }
            }
            comboBox.addPropertyChangeListener("editor", this);
        }

        public void unregister() {
            this.comboBox.removePropertyChangeListener(this);
            if (this.editorComponent != null) {
                this.editorComponent.removeFocusListener(this);
            }
        }

        public void focusGained(FocusEvent e) {
            this.comboBox.repaint();
        }

        public void focusLost(FocusEvent e) {
            this.comboBox.repaint();
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ComboBoxEditor newEditor = this.comboBox.getEditor();
            if (this.editor != newEditor) {
                if (this.editorComponent != null) {
                    this.editorComponent.removeFocusListener(this);
                }
                this.editor = newEditor;
                if (this.editor != null) {
                    this.editorComponent = this.editor.getEditorComponent();
                    if (this.editorComponent != null) {
                        this.editorComponent.addFocusListener(this);
                    }
                }
            }
        }
    }

    private final class ButtonHandler
    extends DefaultButtonModel
    implements MouseListener,
    PopupMenuListener {
        private boolean over;
        private boolean pressed;

        private ButtonHandler() {
        }

        private void updatePressed(boolean p) {
            boolean bl = this.pressed = p && this.isEnabled();
            if (SynthComboBoxUI.this.shouldActLikeButton()) {
                SynthComboBoxUI.this.comboBox.repaint();
            }
        }

        private void updateOver(boolean o) {
            boolean old = this.isRollover();
            this.over = o && this.isEnabled();
            boolean newo = this.isRollover();
            if (SynthComboBoxUI.this.shouldActLikeButton() && old != newo) {
                SynthComboBoxUI.this.comboBox.repaint();
            }
        }

        public boolean isPressed() {
            boolean b = SynthComboBoxUI.this.shouldActLikeButton() ? this.pressed : super.isPressed();
            return b || SynthComboBoxUI.this.pressedWhenPopupVisible && SynthComboBoxUI.this.comboBox.isPopupVisible();
        }

        public boolean isArmed() {
            boolean b = SynthComboBoxUI.this.shouldActLikeButton() || SynthComboBoxUI.this.pressedWhenPopupVisible && SynthComboBoxUI.this.comboBox.isPopupVisible();
            return b ? this.isPressed() : super.isArmed();
        }

        public boolean isRollover() {
            return SynthComboBoxUI.this.shouldActLikeButton() ? this.over : super.isRollover();
        }

        public void setPressed(boolean b) {
            super.setPressed(b);
            this.updatePressed(b);
        }

        public void setRollover(boolean b) {
            super.setRollover(b);
            this.updateOver(b);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.updateOver(true);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.updateOver(false);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.updatePressed(true);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.updatePressed(false);
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
            if (SynthComboBoxUI.this.shouldActLikeButton() || SynthComboBoxUI.this.pressedWhenPopupVisible) {
                SynthComboBoxUI.this.comboBox.repaint();
            }
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }
    }

    private static class SynthComboBoxEditor
    implements ComboBoxEditor,
    UIResource {
        protected JTextField editor = new JTextField("", 9);
        private Object oldValue;

        public SynthComboBoxEditor() {
            this.editor.setName("ComboBox.textField");
        }

        public Component getEditorComponent() {
            return this.editor;
        }

        public void setItem(Object anObject) {
            String text;
            if (anObject != null) {
                text = anObject.toString();
                this.oldValue = anObject;
            } else {
                text = "";
            }
            if (!text.equals(this.editor.getText())) {
                this.editor.setText(text);
            }
        }

        public Object getItem() {
            Object newValue = this.editor.getText();
            if (this.oldValue != null && !(this.oldValue instanceof String)) {
                if (newValue.equals(this.oldValue.toString())) {
                    return this.oldValue;
                }
                Class<?> cls = this.oldValue.getClass();
                try {
                    Method method = cls.getMethod("valueOf", String.class);
                    newValue = method.invoke(this.oldValue, this.editor.getText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return newValue;
        }

        public void selectAll() {
            this.editor.selectAll();
            this.editor.requestFocus();
        }

        public void addActionListener(ActionListener l) {
            this.editor.addActionListener(l);
        }

        public void removeActionListener(ActionListener l) {
            this.editor.removeActionListener(l);
        }
    }

    private class SynthComboBoxRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public SynthComboBoxRenderer() {
            this.setName("ComboBox.renderer");
            this.setText(" ");
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            SynthLookAndFeel.resetSelectedUI();
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
                if (!SynthComboBoxUI.this.useListColors) {
                    SynthLookAndFeel.setSelectedUI((SynthLabelUI)SynthLookAndFeel.getUIOfType(this.getUI(), SynthLabelUI.class), isSelected, cellHasFocus, list.isEnabled(), false);
                }
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setFont(list.getFont());
            if (value instanceof Icon) {
                this.setIcon((Icon)value);
                this.setText("");
            } else {
                String text;
                String string = text = value == null ? " " : value.toString();
                if ("".equals(text)) {
                    text = " ";
                }
                this.setText(text);
            }
            if (SynthComboBoxUI.this.comboBox != null) {
                this.setEnabled(SynthComboBoxUI.this.comboBox.isEnabled());
                this.setComponentOrientation(SynthComboBoxUI.this.comboBox.getComponentOrientation());
            }
            return this;
        }

        public void paint(Graphics g) {
            super.paint(g);
            SynthLookAndFeel.resetSelectedUI();
        }
    }
}

