/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.text.BoxView;
import javax.swing.text.CompositeView;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.GlyphView;
import javax.swing.text.JTextComponent;
import javax.swing.text.ParagraphView;
import javax.swing.text.PlainView;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.WrappedPlainView;

public class BasicTextAreaUI
extends BasicTextUI {
    public static ComponentUI createUI(JComponent ta) {
        return new BasicTextAreaUI();
    }

    protected String getPropertyPrefix() {
        return "TextArea";
    }

    protected void installDefaults() {
        super.installDefaults();
    }

    protected void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (evt.getPropertyName().equals("lineWrap") || evt.getPropertyName().equals("wrapStyleWord") || evt.getPropertyName().equals("tabSize")) {
            this.modelChanged();
        } else if ("editable".equals(evt.getPropertyName())) {
            this.updateFocusTraversalKeys();
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        return super.getPreferredSize(c);
    }

    public Dimension getMinimumSize(JComponent c) {
        return super.getMinimumSize(c);
    }

    public View create(Element elem) {
        Document doc = elem.getDocument();
        Object i18nFlag = doc.getProperty("i18n");
        if (i18nFlag != null && i18nFlag.equals(Boolean.TRUE)) {
            return this.createI18N(elem);
        }
        JTextComponent c = this.getComponent();
        if (c instanceof JTextArea) {
            JTextArea area = (JTextArea)c;
            View v = area.getLineWrap() ? new WrappedPlainView(elem, area.getWrapStyleWord()) : new PlainView(elem);
            return v;
        }
        return null;
    }

    View createI18N(Element elem) {
        String kind = elem.getName();
        if (kind != null) {
            if (kind.equals("content")) {
                return new PlainParagraph(elem);
            }
            if (kind.equals("paragraph")) {
                return new BoxView(elem, 1);
            }
        }
        return null;
    }

    public int getBaseline(JComponent c, int width, int height) {
        super.getBaseline(c, width, height);
        Object i18nFlag = ((JTextComponent)c).getDocument().getProperty("i18n");
        Insets insets = c.getInsets();
        if (Boolean.TRUE.equals(i18nFlag)) {
            View rootView = this.getRootView((JTextComponent)c);
            if (rootView.getViewCount() > 0) {
                height = height - insets.top - insets.bottom;
                int baseline = insets.top;
                int fieldBaseline = BasicHTML.getBaseline(rootView.getView(0), width - insets.left - insets.right, height);
                if (fieldBaseline < 0) {
                    return -1;
                }
                return baseline + fieldBaseline;
            }
            return -1;
        }
        FontMetrics fm = c.getFontMetrics(c.getFont());
        return insets.top + fm.getAscent();
    }

    public Component.BaselineResizeBehavior getBaselineResizeBehavior(JComponent c) {
        super.getBaselineResizeBehavior(c);
        return Component.BaselineResizeBehavior.CONSTANT_ASCENT;
    }

    static class PlainParagraph
    extends ParagraphView {
        PlainParagraph(Element elem) {
            super(elem);
            this.layoutPool = new LogicalView(elem);
            this.layoutPool.setParent(this);
        }

        public void setParent(View parent) {
            super.setParent(parent);
            if (parent != null) {
                this.setPropertiesFromAttributes();
            }
        }

        protected void setPropertiesFromAttributes() {
            Container c = this.getContainer();
            if (c != null && !c.getComponentOrientation().isLeftToRight()) {
                this.setJustification(2);
            } else {
                this.setJustification(0);
            }
        }

        public int getFlowSpan(int index) {
            JTextArea area;
            Container c = this.getContainer();
            if (c instanceof JTextArea && !(area = (JTextArea)c).getLineWrap()) {
                return Integer.MAX_VALUE;
            }
            return super.getFlowSpan(index);
        }

        protected SizeRequirements calculateMinorAxisRequirements(int axis, SizeRequirements r) {
            SizeRequirements req = super.calculateMinorAxisRequirements(axis, r);
            Container c = this.getContainer();
            if (c instanceof JTextArea) {
                JTextArea area = (JTextArea)c;
                if (!area.getLineWrap()) {
                    req.minimum = req.preferred;
                } else {
                    req.minimum = 0;
                    req.preferred = this.getWidth();
                    if (req.preferred == Integer.MAX_VALUE) {
                        req.preferred = 100;
                    }
                }
            }
            return req;
        }

        public void setSize(float width, float height) {
            if ((int)width != this.getWidth()) {
                this.preferenceChanged(null, true, true);
            }
            super.setSize(width, height);
        }

        static class LogicalView
        extends CompositeView {
            LogicalView(Element elem) {
                super(elem);
            }

            protected int getViewIndexAtPosition(int pos) {
                Element elem = this.getElement();
                if (elem.getElementCount() > 0) {
                    return elem.getElementIndex(pos);
                }
                return 0;
            }

            protected boolean updateChildren(DocumentEvent.ElementChange ec, DocumentEvent e, ViewFactory f) {
                return false;
            }

            protected void loadChildren(ViewFactory f) {
                Element elem = this.getElement();
                if (elem.getElementCount() > 0) {
                    super.loadChildren(f);
                } else {
                    GlyphView v = new GlyphView(elem);
                    this.append(v);
                }
            }

            public float getPreferredSpan(int axis) {
                if (this.getViewCount() != 1) {
                    throw new Error("One child view is assumed.");
                }
                View v = this.getView(0);
                return v.getPreferredSpan(axis);
            }

            protected void forwardUpdateToView(View v, DocumentEvent e, Shape a, ViewFactory f) {
                v.setParent(this);
                super.forwardUpdateToView(v, e, a, f);
            }

            public void paint(Graphics g, Shape allocation) {
            }

            protected boolean isBefore(int x, int y, Rectangle alloc) {
                return false;
            }

            protected boolean isAfter(int x, int y, Rectangle alloc) {
                return false;
            }

            protected View getViewAtPoint(int x, int y, Rectangle alloc) {
                return null;
            }

            protected void childAllocation(int index, Rectangle a) {
            }
        }
    }
}

