/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.SplitPaneUI;

public class JSplitPane
extends JComponent
implements Accessible {
    private static final String uiClassID = "SplitPaneUI";
    public static final int VERTICAL_SPLIT = 0;
    public static final int HORIZONTAL_SPLIT = 1;
    public static final String LEFT = "left";
    public static final String RIGHT = "right";
    public static final String TOP = "top";
    public static final String BOTTOM = "bottom";
    public static final String DIVIDER = "divider";
    public static final String ORIENTATION_PROPERTY = "orientation";
    public static final String CONTINUOUS_LAYOUT_PROPERTY = "continuousLayout";
    public static final String DIVIDER_SIZE_PROPERTY = "dividerSize";
    public static final String ONE_TOUCH_EXPANDABLE_PROPERTY = "oneTouchExpandable";
    public static final String LAST_DIVIDER_LOCATION_PROPERTY = "lastDividerLocation";
    public static final String DIVIDER_LOCATION_PROPERTY = "dividerLocation";
    public static final String RESIZE_WEIGHT_PROPERTY = "resizeWeight";
    protected int orientation;
    protected boolean continuousLayout;
    protected Component leftComponent;
    protected Component rightComponent;
    protected int dividerSize;
    private boolean dividerSizeSet = false;
    protected boolean oneTouchExpandable;
    private boolean oneTouchExpandableSet;
    protected int lastDividerLocation;
    private double resizeWeight;
    private int dividerLocation = -1;

    public JSplitPane() {
        this(1, UIManager.getBoolean("SplitPane.continuousLayout"), new JButton(UIManager.getString("SplitPane.leftButtonText")), new JButton(UIManager.getString("SplitPane.rightButtonText")));
    }

    public JSplitPane(int newOrientation) {
        this(newOrientation, UIManager.getBoolean("SplitPane.continuousLayout"));
    }

    public JSplitPane(int newOrientation, boolean newContinuousLayout) {
        this(newOrientation, newContinuousLayout, null, null);
    }

    public JSplitPane(int newOrientation, Component newLeftComponent, Component newRightComponent) {
        this(newOrientation, UIManager.getBoolean("SplitPane.continuousLayout"), newLeftComponent, newRightComponent);
    }

    public JSplitPane(int newOrientation, boolean newContinuousLayout, Component newLeftComponent, Component newRightComponent) {
        this.setLayout(null);
        this.setUIProperty("opaque", Boolean.TRUE);
        this.orientation = newOrientation;
        if (this.orientation != 1 && this.orientation != 0) {
            throw new IllegalArgumentException("cannot create JSplitPane, orientation must be one of JSplitPane.HORIZONTAL_SPLIT or JSplitPane.VERTICAL_SPLIT");
        }
        this.continuousLayout = newContinuousLayout;
        if (newLeftComponent != null) {
            this.setLeftComponent(newLeftComponent);
        }
        if (newRightComponent != null) {
            this.setRightComponent(newRightComponent);
        }
        this.updateUI();
    }

    public void setUI(SplitPaneUI ui) {
        if ((SplitPaneUI)this.ui != ui) {
            super.setUI(ui);
            this.revalidate();
        }
    }

    public SplitPaneUI getUI() {
        return (SplitPaneUI)this.ui;
    }

    public void updateUI() {
        this.setUI((SplitPaneUI)UIManager.getUI(this));
        this.revalidate();
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void setDividerSize(int newSize) {
        int oldSize = this.dividerSize;
        this.dividerSizeSet = true;
        if (oldSize != newSize) {
            this.dividerSize = newSize;
            this.firePropertyChange(DIVIDER_SIZE_PROPERTY, oldSize, newSize);
        }
    }

    public int getDividerSize() {
        return this.dividerSize;
    }

    public void setLeftComponent(Component comp) {
        if (comp == null) {
            if (this.leftComponent != null) {
                this.remove(this.leftComponent);
                this.leftComponent = null;
            }
        } else {
            this.add(comp, LEFT);
        }
    }

    public Component getLeftComponent() {
        return this.leftComponent;
    }

    public void setTopComponent(Component comp) {
        this.setLeftComponent(comp);
    }

    public Component getTopComponent() {
        return this.leftComponent;
    }

    public void setRightComponent(Component comp) {
        if (comp == null) {
            if (this.rightComponent != null) {
                this.remove(this.rightComponent);
                this.rightComponent = null;
            }
        } else {
            this.add(comp, RIGHT);
        }
    }

    public Component getRightComponent() {
        return this.rightComponent;
    }

    public void setBottomComponent(Component comp) {
        this.setRightComponent(comp);
    }

    public Component getBottomComponent() {
        return this.rightComponent;
    }

    public void setOneTouchExpandable(boolean newValue) {
        boolean oldValue = this.oneTouchExpandable;
        this.oneTouchExpandable = newValue;
        this.oneTouchExpandableSet = true;
        this.firePropertyChange(ONE_TOUCH_EXPANDABLE_PROPERTY, oldValue, newValue);
        this.repaint();
    }

    public boolean isOneTouchExpandable() {
        return this.oneTouchExpandable;
    }

    public void setLastDividerLocation(int newLastLocation) {
        int oldLocation = this.lastDividerLocation;
        this.lastDividerLocation = newLastLocation;
        this.firePropertyChange(LAST_DIVIDER_LOCATION_PROPERTY, oldLocation, newLastLocation);
    }

    public int getLastDividerLocation() {
        return this.lastDividerLocation;
    }

    public void setOrientation(int orientation) {
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException("JSplitPane: orientation must be one of JSplitPane.VERTICAL_SPLIT or JSplitPane.HORIZONTAL_SPLIT");
        }
        int oldOrientation = this.orientation;
        this.orientation = orientation;
        this.firePropertyChange(ORIENTATION_PROPERTY, oldOrientation, orientation);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setContinuousLayout(boolean newContinuousLayout) {
        boolean oldCD = this.continuousLayout;
        this.continuousLayout = newContinuousLayout;
        this.firePropertyChange(CONTINUOUS_LAYOUT_PROPERTY, oldCD, newContinuousLayout);
    }

    public boolean isContinuousLayout() {
        return this.continuousLayout;
    }

    public void setResizeWeight(double value) {
        if (value < 0.0 || value > 1.0) {
            throw new IllegalArgumentException("JSplitPane weight must be between 0 and 1");
        }
        double oldWeight = this.resizeWeight;
        this.resizeWeight = value;
        this.firePropertyChange(RESIZE_WEIGHT_PROPERTY, oldWeight, value);
    }

    public double getResizeWeight() {
        return this.resizeWeight;
    }

    public void resetToPreferredSizes() {
        SplitPaneUI ui = this.getUI();
        if (ui != null) {
            ui.resetToPreferredSizes(this);
        }
    }

    public void setDividerLocation(double proportionalLocation) {
        if (proportionalLocation < 0.0 || proportionalLocation > 1.0) {
            throw new IllegalArgumentException("proportional location must be between 0.0 and 1.0.");
        }
        if (this.getOrientation() == 0) {
            this.setDividerLocation((int)((double)(this.getHeight() - this.getDividerSize()) * proportionalLocation));
        } else {
            this.setDividerLocation((int)((double)(this.getWidth() - this.getDividerSize()) * proportionalLocation));
        }
    }

    public void setDividerLocation(int location) {
        int oldValue = this.dividerLocation;
        this.dividerLocation = location;
        SplitPaneUI ui = this.getUI();
        if (ui != null) {
            ui.setDividerLocation(this, location);
        }
        this.firePropertyChange(DIVIDER_LOCATION_PROPERTY, oldValue, location);
        this.setLastDividerLocation(oldValue);
    }

    public int getDividerLocation() {
        return this.dividerLocation;
    }

    public int getMinimumDividerLocation() {
        SplitPaneUI ui = this.getUI();
        if (ui != null) {
            return ui.getMinimumDividerLocation(this);
        }
        return -1;
    }

    public int getMaximumDividerLocation() {
        SplitPaneUI ui = this.getUI();
        if (ui != null) {
            return ui.getMaximumDividerLocation(this);
        }
        return -1;
    }

    public void remove(Component component) {
        if (component == this.leftComponent) {
            this.leftComponent = null;
        } else if (component == this.rightComponent) {
            this.rightComponent = null;
        }
        super.remove(component);
        this.revalidate();
        this.repaint();
    }

    public void remove(int index) {
        Component comp = this.getComponent(index);
        if (comp == this.leftComponent) {
            this.leftComponent = null;
        } else if (comp == this.rightComponent) {
            this.rightComponent = null;
        }
        super.remove(index);
        this.revalidate();
        this.repaint();
    }

    public void removeAll() {
        this.rightComponent = null;
        this.leftComponent = null;
        super.removeAll();
        this.revalidate();
        this.repaint();
    }

    public boolean isValidateRoot() {
        return true;
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (constraints != null && !(constraints instanceof String)) {
            throw new IllegalArgumentException("cannot add to layout: constraint must be a string (or null)");
        }
        if (constraints == null) {
            if (this.getLeftComponent() == null) {
                constraints = LEFT;
            } else if (this.getRightComponent() == null) {
                constraints = RIGHT;
            }
        }
        if (constraints != null && (constraints.equals(LEFT) || constraints.equals(TOP))) {
            Component toRemove = this.getLeftComponent();
            if (toRemove != null) {
                this.remove(toRemove);
            }
            this.leftComponent = comp;
            index = -1;
        } else if (constraints != null && (constraints.equals(RIGHT) || constraints.equals(BOTTOM))) {
            Component toRemove = this.getRightComponent();
            if (toRemove != null) {
                this.remove(toRemove);
            }
            this.rightComponent = comp;
            index = -1;
        } else if (constraints != null && constraints.equals(DIVIDER)) {
            index = -1;
        }
        super.addImpl(comp, constraints, index);
        this.revalidate();
        this.repaint();
    }

    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        SplitPaneUI ui = this.getUI();
        if (ui != null) {
            Graphics tempG = g.create();
            ui.finishedPaintingChildren(this, tempG);
            tempG.dispose();
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte count = JComponent.getWriteObjCounter(this);
            count = (byte)(count - 1);
            JComponent.setWriteObjCounter(this, count);
            if (count == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    void setUIProperty(String propertyName, Object value) {
        if (propertyName == DIVIDER_SIZE_PROPERTY) {
            if (!this.dividerSizeSet) {
                this.setDividerSize(((Number)value).intValue());
                this.dividerSizeSet = false;
            }
        } else if (propertyName == ONE_TOUCH_EXPANDABLE_PROPERTY) {
            if (!this.oneTouchExpandableSet) {
                this.setOneTouchExpandable((Boolean)value);
                this.oneTouchExpandableSet = false;
            }
        } else {
            super.setUIProperty(propertyName, value);
        }
    }

    protected String paramString() {
        String orientationString = this.orientation == 1 ? "HORIZONTAL_SPLIT" : "VERTICAL_SPLIT";
        String continuousLayoutString = this.continuousLayout ? "true" : "false";
        String oneTouchExpandableString = this.oneTouchExpandable ? "true" : "false";
        return super.paramString() + ",continuousLayout=" + continuousLayoutString + ",dividerSize=" + this.dividerSize + ",lastDividerLocation=" + this.lastDividerLocation + ",oneTouchExpandable=" + oneTouchExpandableString + ",orientation=" + orientationString;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJSplitPane();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJSplitPane
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        protected AccessibleJSplitPane() {
            super(JSplitPane.this);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = super.getAccessibleStateSet();
            if (JSplitPane.this.getOrientation() == 0) {
                states.add(AccessibleState.VERTICAL);
            } else {
                states.add(AccessibleState.HORIZONTAL);
            }
            return states;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public Number getCurrentAccessibleValue() {
            return new Integer(JSplitPane.this.getDividerLocation());
        }

        public boolean setCurrentAccessibleValue(Number n) {
            if (n == null) {
                return false;
            }
            JSplitPane.this.setDividerLocation(n.intValue());
            return true;
        }

        public Number getMinimumAccessibleValue() {
            return new Integer(JSplitPane.this.getUI().getMinimumDividerLocation(JSplitPane.this));
        }

        public Number getMaximumAccessibleValue() {
            return new Integer(JSplitPane.this.getUI().getMaximumDividerLocation(JSplitPane.this));
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SPLIT_PANE;
        }
    }
}

