/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset.serial;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLInputImpl
implements SQLInput {
    private boolean lastValueWasNull;
    private int idx;
    private Object[] attrib;
    private Map map;

    public SQLInputImpl(Object[] attributes, Map<String, Class<?>> map) throws SQLException {
        if (attributes == null || map == null) {
            throw new SQLException("Cannot instantiate a SQLInputImpl object with null parameters");
        }
        this.attrib = attributes;
        this.idx = -1;
        this.map = map;
    }

    private Object getNextAttribute() throws SQLException {
        if (++this.idx >= this.attrib.length) {
            throw new SQLException("SQLInputImpl exception: Invalid read position");
        }
        return this.attrib[this.idx];
    }

    @Override
    public String readString() throws SQLException {
        String attrib = (String)this.getNextAttribute();
        if (attrib == null) {
            this.lastValueWasNull = true;
            return null;
        }
        this.lastValueWasNull = false;
        return attrib;
    }

    @Override
    public boolean readBoolean() throws SQLException {
        Boolean attrib = (Boolean)this.getNextAttribute();
        if (attrib == null) {
            this.lastValueWasNull = true;
            return false;
        }
        this.lastValueWasNull = false;
        return attrib;
    }

    @Override
    public byte readByte() throws SQLException {
        Byte attrib = (Byte)this.getNextAttribute();
        if (attrib == null) {
            this.lastValueWasNull = true;
            return 0;
        }
        this.lastValueWasNull = false;
        return attrib;
    }

    @Override
    public short readShort() throws SQLException {
        Short attrib = (Short)this.getNextAttribute();
        if (attrib == null) {
            this.lastValueWasNull = true;
            return 0;
        }
        this.lastValueWasNull = false;
        return attrib;
    }

    @Override
    public int readInt() throws SQLException {
        Integer attrib = (Integer)this.getNextAttribute();
        if (attrib == null) {
            this.lastValueWasNull = true;
            return 0;
        }
        this.lastValueWasNull = false;
        return attrib;
    }

    @Override
    public long readLong() throws SQLException {
        Long attrib = (Long)this.getNextAttribute();
        if (attrib == null) {
            this.lastValueWasNull = true;
            return 0L;
        }
        this.lastValueWasNull = false;
        return attrib;
    }

    @Override
    public float readFloat() throws SQLException {
        Float attrib = (Float)this.getNextAttribute();
        if (attrib == null) {
            this.lastValueWasNull = true;
            return 0.0f;
        }
        this.lastValueWasNull = false;
        return attrib.floatValue();
    }

    @Override
    public double readDouble() throws SQLException {
        Double attrib = (Double)this.getNextAttribute();
        if (attrib == null) {
            this.lastValueWasNull = true;
            return 0.0;
        }
        this.lastValueWasNull = false;
        return attrib;
    }

    @Override
    public BigDecimal readBigDecimal() throws SQLException {
        BigDecimal attrib = (BigDecimal)this.getNextAttribute();
        if (attrib == null) {
            this.lastValueWasNull = true;
            return null;
        }
        this.lastValueWasNull = false;
        return attrib;
    }

    @Override
    public byte[] readBytes() throws SQLException {
        byte[] attrib = (byte[])this.getNextAttribute();
        if (attrib == null) {
            this.lastValueWasNull = true;
            return null;
        }
        this.lastValueWasNull = false;
        return attrib;
    }

    @Override
    public Date readDate() throws SQLException {
        Date attrib = (Date)this.getNextAttribute();
        if (attrib == null) {
            this.lastValueWasNull = true;
            return null;
        }
        this.lastValueWasNull = false;
        return attrib;
    }

    @Override
    public Time readTime() throws SQLException {
        Time attrib = (Time)this.getNextAttribute();
        if (attrib == null) {
            this.lastValueWasNull = true;
            return null;
        }
        this.lastValueWasNull = false;
        return attrib;
    }

    @Override
    public Timestamp readTimestamp() throws SQLException {
        Timestamp attrib = (Timestamp)this.getNextAttribute();
        if (attrib == null) {
            this.lastValueWasNull = true;
            return null;
        }
        this.lastValueWasNull = false;
        return attrib;
    }

    @Override
    public Reader readCharacterStream() throws SQLException {
        Reader attrib = (Reader)this.getNextAttribute();
        if (attrib == null) {
            this.lastValueWasNull = true;
            return null;
        }
        this.lastValueWasNull = false;
        return attrib;
    }

    @Override
    public InputStream readAsciiStream() throws SQLException {
        InputStream attrib = (InputStream)this.getNextAttribute();
        if (attrib == null) {
            this.lastValueWasNull = true;
            return null;
        }
        this.lastValueWasNull = false;
        return attrib;
    }

    @Override
    public InputStream readBinaryStream() throws SQLException {
        InputStream attrib = (InputStream)this.getNextAttribute();
        if (attrib == null) {
            this.lastValueWasNull = true;
            return null;
        }
        this.lastValueWasNull = false;
        return attrib;
    }

    @Override
    public Object readObject() throws SQLException {
        Struct s;
        Class c;
        Object attrib = this.getNextAttribute();
        if (attrib == null) {
            this.lastValueWasNull = true;
            return null;
        }
        this.lastValueWasNull = false;
        if (attrib instanceof Struct && (c = (Class)this.map.get((s = (Struct)attrib).getSQLTypeName())) != null) {
            SQLData obj = null;
            try {
                obj = (SQLData)c.newInstance();
            }
            catch (InstantiationException ex) {
                throw new SQLException("Unable to instantiate: " + ex.getMessage());
            }
            catch (IllegalAccessException ex) {
                throw new SQLException("Unable to instantiate: " + ex.getMessage());
            }
            Object[] attribs = s.getAttributes(this.map);
            SQLInputImpl sqlInput = new SQLInputImpl(attribs, this.map);
            obj.readSQL(sqlInput, s.getSQLTypeName());
            return obj;
        }
        return attrib;
    }

    @Override
    public Ref readRef() throws SQLException {
        Ref attrib = (Ref)this.getNextAttribute();
        if (attrib == null) {
            this.lastValueWasNull = true;
            return null;
        }
        this.lastValueWasNull = false;
        return attrib;
    }

    @Override
    public Blob readBlob() throws SQLException {
        Blob attrib = (Blob)this.getNextAttribute();
        if (attrib == null) {
            this.lastValueWasNull = true;
            return null;
        }
        this.lastValueWasNull = false;
        return attrib;
    }

    @Override
    public Clob readClob() throws SQLException {
        Clob attrib = (Clob)this.getNextAttribute();
        if (attrib == null) {
            this.lastValueWasNull = true;
            return null;
        }
        this.lastValueWasNull = false;
        return attrib;
    }

    @Override
    public Array readArray() throws SQLException {
        Array attrib = (Array)this.getNextAttribute();
        if (attrib == null) {
            this.lastValueWasNull = true;
            return null;
        }
        this.lastValueWasNull = false;
        return attrib;
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.lastValueWasNull;
    }

    @Override
    public URL readURL() throws SQLException {
        throw new SQLException("Operation not supported");
    }

    @Override
    public NClob readNClob() throws SQLException {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public String readNString() throws SQLException {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public SQLXML readSQLXML() throws SQLException {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public RowId readRowId() throws SQLException {
        throw new UnsupportedOperationException("Operation not supported");
    }
}

